/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.images;

import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.pdf.viaXSLFO.PartTracker;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.picture.Pic;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.TransformState;
import org.docx4j.model.images.AbstractWordXmlPicture;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.relationships.Relationship;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordXmlPictureE20
extends AbstractWordXmlPicture {
    protected static Logger log = Logger.getLogger(WordXmlPictureE20.class);
    private Inline inline;
    private Anchor anchor;
    private final int extentToPixelConversionFactor = 12700;

    private WordXmlPictureE20(WordprocessingMLPackage wmlPackage, Object anchorOrInline) {
        block15: {
            this.extentToPixelConversionFactor = 12700;
            this.wmlPackage = wmlPackage;
            if (anchorOrInline != null) {
                Node n;
                if (anchorOrInline instanceof Inline) {
                    this.inline = (Inline)anchorOrInline;
                } else if (anchorOrInline instanceof Anchor) {
                    this.anchor = (Anchor)anchorOrInline;
                } else if (anchorOrInline instanceof NodeIterator && (n = ((NodeIterator)anchorOrInline).nextNode()) != null) {
                    Object jaxb = null;
                    try {
                        Unmarshaller u = Context.jc.createUnmarshaller();
                        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                        jaxb = u.unmarshal(n);
                    }
                    catch (JAXBException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (jaxb instanceof JAXBElement) {
                            JAXBElement jb = (JAXBElement)jaxb;
                            if (jb.getDeclaredType().getName().equals("org.docx4j.dml.wordprocessingDrawing.Inline")) {
                                this.inline = (Inline)jb.getValue();
                                break block15;
                            }
                            if (jb.getDeclaredType().getName().equals("org.docx4j.dml.wordprocessingDrawing.Anchor")) {
                                this.anchor = (Anchor)jb.getValue();
                                break block15;
                            }
                            log.error((Object)("UNEXPECTED " + XmlUtils.JAXBElementDebug(jb)));
                            return;
                        }
                        if (jaxb instanceof Inline) {
                            this.inline = (Inline)jaxb;
                            break block15;
                        }
                        if (jaxb instanceof Anchor) {
                            this.anchor = (Anchor)jaxb;
                            break block15;
                        }
                        log.error((Object)jaxb.getClass().getName());
                        return;
                    }
                    catch (ClassCastException e) {
                        log.error((Object)("Couldn't cast " + jaxb.getClass().getName() + " to Anchor or Inline "));
                    }
                }
            }
        }
    }

    private static void debug(WordXmlPictureE20 converter) {
        if (converter.inline != null) {
            log.error((Object)XmlUtils.marshaltoString(converter.inline, true, true, Context.jc, "foo", "bar", Inline.class));
        } else {
            log.error((Object)XmlUtils.marshaltoString(converter.anchor, true, true, Context.jc, "foo", "bar", Anchor.class));
        }
    }

    public static WordXmlPictureE20 createWordXmlPictureFromE20(WordprocessingMLPackage wmlPackage, ConversionImageHandler imageHandler, Object anchorOrInline, Part sourcePart) {
        WordXmlPictureE20 converter = new WordXmlPictureE20(wmlPackage, anchorOrInline);
        converter.readDimensions();
        converter.readHyperlink();
        Pic pic = converter.getPic();
        if (pic == null) {
            log.error((Object)"pic missing!!");
            WordXmlPictureE20.debug(converter);
            return null;
        }
        if (pic.getBlipFill() == null || pic.getBlipFill().getBlip() == null) {
            log.error((Object)"blip missing!!");
            return null;
        }
        CTBlip blip = pic.getBlipFill().getBlip();
        String imgRelId = blip.getEmbed();
        if (imgRelId == null || imgRelId.length() == 0) {
            imgRelId = blip.getLink();
        }
        if (imgRelId != null && imgRelId.length() > 0) {
            converter.handleImageRel(imageHandler, imgRelId, sourcePart);
        } else {
            log.error((Object)"not linked or embedded?!");
        }
        return converter;
    }

    private Pic getPic() {
        if (this.inline != null) {
            if (this.inline.getGraphic() == null || this.inline.getGraphic().getGraphicData() == null || this.inline.getGraphic().getGraphicData().getPic() == null) {
                log.error((Object)"pic missing!!");
                return null;
            }
            return this.inline.getGraphic().getGraphicData().getPic();
        }
        if (this.anchor != null) {
            if (this.anchor.getGraphic() == null || this.anchor.getGraphic().getGraphicData() == null || this.anchor.getGraphic().getGraphicData().getPic() == null) {
                log.error((Object)"pic missing!!");
                return null;
            }
            return this.anchor.getGraphic().getGraphicData().getPic();
        }
        log.error((Object)"Anchor and inline both null!");
        return null;
    }

    public static DocumentFragment createHtmlImgE20(WordprocessingMLPackage wmlPackage, ConversionImageHandler imageHandler, Object wpInline) {
        WordXmlPictureE20 converter = WordXmlPictureE20.createWordXmlPictureFromE20(wmlPackage, imageHandler, wpInline, wmlPackage.getMainDocumentPart());
        return WordXmlPictureE20.getHtmlDocumentFragment(converter);
    }

    public static DocumentFragment createXslFoImgE20(WordprocessingMLPackage wmlPackage, ConversionImageHandler imageHandler, NodeIterator wpInline, HashMap<String, TransformState> modelStates) {
        Part sourcePart = PartTracker.getPartTrackerState(modelStates);
        WordXmlPictureE20 converter = WordXmlPictureE20.createWordXmlPictureFromE20(wmlPackage, imageHandler, wpInline, sourcePart);
        Document d = converter.createXslFoImageElement();
        DocumentFragment docfrag = d.createDocumentFragment();
        docfrag.appendChild(d.getDocumentElement());
        return docfrag;
    }

    private void readDimensions() {
        CTPositiveSize2D size2d = this.getExtent();
        if (size2d == null) {
            log.warn((Object)"wp:inline/wp:extent missing!");
            return;
        }
        this.dimensions = new AbstractWordXmlPicture.Dimensions();
        if (size2d.getCx() != 0L) {
            this.dimensions.width = (int)size2d.getCx() / 12700;
            this.dimensions.widthUnit = "px";
        }
        if (size2d.getCy() != 0L) {
            this.dimensions.height = (int)size2d.getCy() / 12700;
            this.dimensions.heightUnit = "px";
        }
    }

    private CTPositiveSize2D getExtent() {
        if (this.inline != null) {
            return this.inline.getExtent();
        }
        if (this.anchor != null) {
            return this.anchor.getExtent();
        }
        log.error((Object)"Anchor and inline both null!");
        return null;
    }

    private void readHyperlink() {
        if (this.getDocPr() != null && this.getDocPr().getHlinkClick() != null) {
            String linkRelId = this.getDocPr().getHlinkClick().getId();
            if (linkRelId != null && !linkRelId.equals("")) {
                Relationship rel = this.wmlPackage.getMainDocumentPart().getRelationshipsPart().getRelationshipByID(linkRelId);
                if (rel.getTargetMode() == null || rel.getTargetMode().equals("Internal")) {
                    this.setHlinkReference("TODO - save this object");
                } else {
                    this.setHlinkReference(rel.getTarget());
                }
            }
            this.targetFrame = this.getDocPr().getHlinkClick().getTgtFrame();
            this.tooltip = this.getDocPr().getHlinkClick().getTooltip();
        }
    }

    private CTNonVisualDrawingProps getDocPr() {
        if (this.inline != null) {
            if (this.inline.getDocPr() == null) {
                log.error((Object)"DocPr missing!!");
                return null;
            }
            return this.inline.getDocPr();
        }
        if (this.anchor != null) {
            if (this.anchor.getDocPr() == null) {
                log.error((Object)"DocPr missing!!");
                return null;
            }
            return this.anchor.getDocPr();
        }
        log.error((Object)"Anchor and inline both null!");
        return null;
    }
}

