/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import org.docx4j.XmlUtils;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.junit.Assert;

public class AbstractNumberingTest {
    static final String EXPECT_START = "[expect]";
    static final String EXPECT_END = "[/expect]";

    protected void testNumbering(WordprocessingMLPackage wordMLPackage) {
        NumberingDefinitionsPart ndp = wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        Emulator listNumberingEmulator = ndp.getEmulator();
        int assertionCount = 0;
        for (Object o : wordMLPackage.getMainDocumentPart().getContent()) {
            P p;
            if (!(o instanceof P) || (p = (P)o).getPPr() == null) continue;
            String pStyleVal = null;
            if (p.getPPr().getPStyle() != null) {
                pStyleVal = p.getPPr().getPStyle().getVal();
            }
            String numId = null;
            String levelId = null;
            if (p.getPPr().getNumPr() != null) {
                if (p.getPPr().getNumPr().getNumId() != null) {
                    numId = p.getPPr().getNumPr().getNumId().getVal().toString();
                }
                if (p.getPPr().getNumPr().getIlvl() != null) {
                    levelId = p.getPPr().getNumPr().getIlvl().getVal().toString();
                }
            }
            Emulator.ResultTriple rt = Emulator.getNumber(wordMLPackage, pStyleVal, numId, levelId);
            Text text = (Text)XmlUtils.unwrap(((R)p.getContent().get(0)).getContent().get(0));
            String content = text.getValue();
            if (!content.contains(EXPECT_START)) continue;
            int start = content.indexOf(EXPECT_START) + EXPECT_START.length();
            int end = content.indexOf(EXPECT_END);
            String expectedResult = content.substring(start, end);
            Assert.assertTrue((String)("Expected " + expectedResult + " but got " + rt.numString), (boolean)expectedResult.equals(rt.numString));
            ++assertionCount;
        }
        System.out.println("Assertions tested: " + assertionCount);
        Assert.assertTrue((String)"No assertions were tested", (assertionCount > 0 ? 1 : 0) != 0);
    }
}

