/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import org.docx4j.fonts.PhysicalFont;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class Font
extends AbstractRunProperty {
    public static final String CSS_NAME = "font-family";
    public static final String FO_NAME = "font-family";
    private OpcPackage wmlPackage;

    public String getCssName() {
        return "font-family";
    }

    public Font(OpcPackage wmlPackage, RFonts rFonts) {
        this.setObject(rFonts);
        this.wmlPackage = wmlPackage;
    }

    public Font(CSSValue value) {
        this.debug("font-family", value);
        log.warn((Object)"TODO");
    }

    public String getCssProperty() {
        String font = this.getPhysicalFont();
        if (font != null) {
            return Font.composeCss("font-family", font);
        }
        log.warn((Object)("No mapping from " + font));
        return "";
    }

    private String getPhysicalFont() {
        RFonts rFonts = (RFonts)this.getObject();
        String font = rFonts.getAscii();
        if (font == null && this.wmlPackage instanceof WordprocessingMLPackage) {
            font = ((WordprocessingMLPackage)this.wmlPackage).getDefaultFont();
        }
        return Font.getPhysicalFont(this.wmlPackage, font);
    }

    public static String getPhysicalFont(OpcPackage wmlPackage, String fontName) {
        if (!(wmlPackage instanceof WordprocessingMLPackage)) {
            log.error((Object)"Implement me for pptx4j");
            return null;
        }
        PhysicalFont pf = ((WordprocessingMLPackage)wmlPackage).getFontMapper().getFontMappings().get(fontName);
        if (pf != null) {
            log.debug((Object)("Font '" + fontName + "' maps to " + pf.getName()));
            return pf.getName();
        }
        log.warn((Object)("Font '" + fontName + "' is not mapped to a physical font. "));
        return null;
    }

    public void setXslFO(Element foElement) {
        String font = this.getPhysicalFont();
        if (font != null) {
            foElement.setAttribute("font-family", font);
        }
    }

    public void set(RPr rPr) {
        rPr.setRFonts((RFonts)this.getObject());
    }
}

