/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.structure;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.pdf.viaXSLFO.PartTracker;
import org.docx4j.model.TransformState;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.SectPr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderFooterPolicy {
    protected static Logger log = Logger.getLogger(HeaderFooterPolicy.class);
    private HeaderPart firstHeaderActive;
    private HeaderPart firstHeaderActual;
    private FooterPart firstFooterActive;
    private FooterPart firstFooterActual;
    private HeaderPart evenHeader;
    private FooterPart evenFooter;
    private HeaderPart defaultHeader;
    private FooterPart defaultFooter;

    private HeaderFooterPolicy() {
    }

    public HeaderFooterPolicy(SectPr sectPr, HeaderFooterPolicy previousHF, RelationshipsPart rels) {
        if (sectPr == null) {
            log.debug((Object)"No headers/footers in this sectPr");
            return;
        }
        if (previousHF == null) {
            previousHF = new HeaderFooterPolicy();
        }
        List<CTRel> hdrFtrRefs = sectPr.getEGHdrFtrReferences();
        BooleanDefaultTrue titlePage = sectPr.getTitlePg();
        if (this.hasHdrRef(hdrFtrRefs)) {
            this.setHeaderReferences(hdrFtrRefs, rels, titlePage);
        } else {
            this.firstHeaderActual = previousHF.firstHeaderActual;
            if (titlePage != null && titlePage.isVal()) {
                this.firstHeaderActive = previousHF.firstHeaderActual;
            }
            this.defaultHeader = previousHF.defaultHeader;
            this.evenHeader = previousHF.evenHeader;
        }
        if (this.hasFtrRef(hdrFtrRefs)) {
            this.setFooterReferences(hdrFtrRefs, rels, titlePage);
        } else {
            this.firstFooterActual = previousHF.firstFooterActual;
            if (titlePage != null && titlePage.isVal()) {
                this.firstFooterActive = previousHF.firstFooterActual;
            }
            this.defaultFooter = previousHF.defaultFooter;
            this.evenFooter = previousHF.evenFooter;
        }
    }

    private boolean hasHdrRef(List<CTRel> hdrFtrRefs) {
        if (hdrFtrRefs == null) {
            return false;
        }
        for (CTRel rel : hdrFtrRefs) {
            if (!(rel instanceof HeaderReference)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFtrRef(List<CTRel> hdrFtrRefs) {
        if (hdrFtrRefs == null) {
            return false;
        }
        for (CTRel rel : hdrFtrRefs) {
            if (!(rel instanceof FooterReference)) continue;
            return true;
        }
        return false;
    }

    private void setHeaderReferences(List<CTRel> hdrFtrRefs, RelationshipsPart rels, BooleanDefaultTrue titlePage) {
        for (CTRel rel : hdrFtrRefs) {
            String relId = rel.getId();
            log.debug((Object)("for h|f relId: " + relId));
            Part part = rels.getPart(relId);
            if (!(rel instanceof HeaderReference)) continue;
            HeaderReference headerReference = (HeaderReference)rel;
            if (headerReference.getType() == HdrFtrRef.FIRST) {
                this.firstHeaderActual = (HeaderPart)part;
                if (titlePage == null || !titlePage.isVal()) continue;
                log.debug((Object)"setting first page header");
                this.firstHeaderActive = (HeaderPart)part;
                continue;
            }
            if (headerReference.getType() == HdrFtrRef.EVEN) {
                log.debug((Object)"setting even page header");
                this.evenHeader = (HeaderPart)part;
                continue;
            }
            log.debug((Object)"setting default page header");
            this.defaultHeader = (HeaderPart)part;
        }
    }

    private void setFooterReferences(List<CTRel> hdrFtrRefs, RelationshipsPart rels, BooleanDefaultTrue titlePage) {
        for (CTRel rel : hdrFtrRefs) {
            String relId = rel.getId();
            log.debug((Object)("for h|f relId: " + relId));
            Part part = rels.getPart(relId);
            if (!(rel instanceof FooterReference)) continue;
            FooterReference footerReference = (FooterReference)rel;
            if (footerReference.getType() == HdrFtrRef.FIRST) {
                this.firstFooterActual = (FooterPart)part;
                if (titlePage == null || !titlePage.isVal()) continue;
                log.debug((Object)"setting first page footer");
                this.firstFooterActive = (FooterPart)part;
                continue;
            }
            if (footerReference.getType() == HdrFtrRef.EVEN) {
                log.debug((Object)"setting even page footer");
                this.evenFooter = (FooterPart)part;
                continue;
            }
            log.debug((Object)"setting default page footer");
            this.defaultFooter = (FooterPart)part;
        }
    }

    public HeaderPart getFirstHeader() {
        return this.firstHeaderActive;
    }

    public FooterPart getFirstFooter() {
        return this.firstFooterActive;
    }

    public HeaderPart getOddHeader() {
        return this.defaultHeader;
    }

    public FooterPart getOddFooter() {
        return this.defaultFooter;
    }

    public HeaderPart getEvenHeader() {
        return this.evenHeader;
    }

    public FooterPart getEvenFooter() {
        return this.evenFooter;
    }

    public HeaderPart getDefaultHeader() {
        return this.defaultHeader;
    }

    public FooterPart getDefaultFooter() {
        return this.defaultFooter;
    }

    public HeaderPart getHeader(int pageNumber) {
        if (pageNumber == 1 && this.firstHeaderActive != null) {
            return this.firstHeaderActive;
        }
        if (pageNumber % 2 == 0 && this.evenHeader != null) {
            return this.evenHeader;
        }
        return this.defaultHeader;
    }

    public FooterPart getFooter(int pageNumber) {
        if (pageNumber == 1 && this.firstFooterActive != null) {
            return this.firstFooterActive;
        }
        if (pageNumber % 2 == 0 && this.evenFooter != null) {
            return this.evenFooter;
        }
        return this.defaultFooter;
    }

    public static boolean hasDefaultHeaderOrFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultHeader() != null || wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultFooter() != null;
    }

    public static boolean hasFirstHeader(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getFirstHeader() != null;
    }

    public static boolean hasEvenHeader(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getEvenHeader() != null;
    }

    public static boolean hasDefaultHeader(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultHeader() != null;
    }

    public static boolean hasFirstFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getFirstFooter() != null;
    }

    public static boolean hasEvenFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getEvenFooter() != null;
    }

    public static boolean hasDefaultFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        log.debug((Object)("section number: " + sectionNumber));
        return wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultFooter() != null;
    }

    public static Node getFirstHeader(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        Hdr hdr = (Hdr)wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getFirstHeader().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(hdr);
    }

    public static Node getFirstFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        Ftr ftr = (Ftr)wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getFirstFooter().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(ftr);
    }

    public static Node getEvenHeader(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        Hdr hdr = (Hdr)wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getEvenHeader().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(hdr);
    }

    public static Node getEvenFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        Ftr ftr = (Ftr)wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getEvenFooter().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(ftr);
    }

    public static Node getDefaultHeader(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        Hdr hdr = (Hdr)wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultHeader().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(hdr);
    }

    public static Node getDefaultFooter(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        Ftr ftr = (Ftr)wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultFooter().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(ftr);
    }

    public static void inFirstHeader(WordprocessingMLPackage wordmlPackage, HashMap<String, TransformState> modelStates, int sectionNumber) {
        PartTracker.setPartTrackerState(wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getFirstHeader(), modelStates);
    }

    public static void inEvenHeader(WordprocessingMLPackage wordmlPackage, HashMap<String, TransformState> modelStates, int sectionNumber) {
        PartTracker.setPartTrackerState(wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getEvenHeader(), modelStates);
    }

    public static void inDefaultHeader(WordprocessingMLPackage wordmlPackage, HashMap<String, TransformState> modelStates, int sectionNumber) {
        PartTracker.setPartTrackerState(wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultHeader(), modelStates);
    }

    public static void inFirstFooter(WordprocessingMLPackage wordmlPackage, HashMap<String, TransformState> modelStates, int sectionNumber) {
        PartTracker.setPartTrackerState(wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getFirstFooter(), modelStates);
    }

    public static void inEvenFooter(WordprocessingMLPackage wordmlPackage, HashMap<String, TransformState> modelStates, int sectionNumber) {
        PartTracker.setPartTrackerState(wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getEvenFooter(), modelStates);
    }

    public static void inDefaultFooter(WordprocessingMLPackage wordmlPackage, HashMap<String, TransformState> modelStates, int sectionNumber) {
        PartTracker.setPartTrackerState(wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1).getHeaderFooterPolicy().getDefaultFooter(), modelStates);
    }
}

