/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.table;

import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.model.table.TableModel;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.w3c.dom.Node;

public class Cell {
    private static final Logger logger = Logger.getLogger(Cell.class);
    private TableModel table;
    private int row;
    private int col;
    protected int rowspan = 0;
    protected int colspan = 0;
    protected boolean dummy = false;
    protected Node content = null;
    TcPr tcPr;

    public TcPr getTcPr() {
        return this.tcPr;
    }

    public Cell(TableModel table, int row, int col) {
        this.table = table;
        this.row = row;
        this.col = col;
        this.dummy = true;
    }

    public Cell(TableModel table, int row, int col, Tc tc, Node content) {
        this(table, row, col);
        this.dummy = false;
        this.content = content;
        this.tcPr = tc.getTcPr();
        logger.info((Object)("Cell content: " + XmlUtils.w3CDomNodeToString(content)));
        try {
            String vm = tc.getTcPr().getVMerge().getVal();
            if (vm == null) {
                this.dummy = true;
            }
            this.incrementRowSpan();
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        if (this.dummy) {
            this.colspan = table.getCell((int)(row - 1), (int)col).colspan;
        } else {
            try {
                int gridSpan;
                this.colspan = gridSpan = tc.getTcPr().getGridSpan().getVal().intValue();
            }
            catch (NullPointerException ne) {
                // empty catch block
            }
        }
    }

    public int getExtraCols() {
        if (this.colspan < 2) {
            return 0;
        }
        return this.colspan - 1;
    }

    public int getExtraRows() {
        if (this.rowspan > 1) {
            return this.rowspan - 1;
        }
        return 0;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public Node getContent() {
        return this.content;
    }

    public int getColumn() {
        return this.col;
    }

    protected void incrementRowSpan() {
        if (this.dummy) {
            this.table.getCell(this.row - 1, this.col).incrementRowSpan();
        } else {
            ++this.rowspan;
        }
    }

    public String debugStr() {
        String s = null;
        s = this.dummy ? "d" : "r";
        s = s + "(" + this.row + "," + this.col + ")";
        s = s + this.colspan;
        s = s + this.rowspan;
        return s + " ";
    }
}

