/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.table;

import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.Model;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.TransformState;
import org.docx4j.model.table.Cell;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtRow;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModel
extends Model {
    private static final Logger log = Logger.getLogger(TableModel.class);
    private static final int DEFAULT_PAGE_WIDTH_TWIPS = 12240;
    protected List<List<Cell>> cells;
    private int row;
    private int col;
    protected String styleId;
    protected Style effectiveTableStyle;
    protected TblPr tblPr;
    protected TblGrid tblGrid;
    boolean borderConflictResolutionRequired = true;

    public TableModel() {
        this.resetIndexes();
        this.cells = new Vector<List<Cell>>();
    }

    public String getStyleId() {
        return this.styleId;
    }

    public Style getEffectiveTableStyle() {
        return this.effectiveTableStyle;
    }

    public TblPr getTblPr() {
        return this.tblPr;
    }

    public TblGrid getTblGrid() {
        return this.tblGrid;
    }

    public boolean isBorderConflictResolutionRequired() {
        return this.borderConflictResolutionRequired;
    }

    public void resetIndexes() {
        this.row = -1;
        this.col = -1;
    }

    public void startRow() {
        this.cells.add(new Vector());
        ++this.row;
        this.col = -1;
    }

    public void addCell(Tc tc, Node content) {
        ++this.col;
        Cell newCell = new Cell(this, this.row, this.col, tc, content);
        this.cells.get(this.row).add(newCell);
        for (int i = 0; i < newCell.getExtraCols(); ++i) {
            this.addDummyCell();
        }
    }

    private void addDummyCell() {
        ++this.col;
        this.cells.get(this.row).add(new Cell(this, this.row, this.col));
    }

    public Cell getCell(int row, int col) {
        return this.cells.get(row).get(col);
    }

    public String getColName(int col) {
        return "col" + String.valueOf(col + 1);
    }

    public int getColCount() {
        return this.cells.get(0).size();
    }

    public List<List<Cell>> getCells() {
        return this.cells;
    }

    @Override
    public void build(Node node, NodeList children) throws TransformerException {
        Tbl tbl = null;
        try {
            tbl = (Tbl)XmlUtils.unmarshal(node);
        }
        catch (JAXBException e) {
            throw new TransformerException("Node: " + node.getNodeName() + "=" + node.getNodeValue(), e);
        }
        this.build(tbl, children.item(0));
    }

    public void build(Tbl tbl, Node content) throws TransformerException {
        PropertyResolver pr;
        if (tbl.getTblPr() != null && tbl.getTblPr().getTblStyle() != null) {
            this.styleId = tbl.getTblPr().getTblStyle().getVal();
        }
        this.tblGrid = tbl.getTblGrid();
        this.tblPr = tbl.getTblPr();
        try {
            pr = new PropertyResolver(this.wordMLPackage);
        }
        catch (Docx4JException e) {
            throw new TransformerException("Hmmm", e);
        }
        this.effectiveTableStyle = pr.getEffectiveTableStyle(tbl.getTblPr());
        CTTblPrBase tblPr = this.effectiveTableStyle.getTblPr();
        if (tblPr != null && tblPr.getTblCellSpacing() != null) {
            this.borderConflictResolutionRequired = false;
        }
        NodeList cellContents = content.getChildNodes();
        List<Object> rows = tbl.getEGContentRowContent();
        int r = 0;
        for (Object o : rows) {
            Tr tr = null;
            if (o instanceof Tr) {
                this.startRow();
                tr = (Tr)o;
                this.handleRow(cellContents, tr, r);
                ++r;
                continue;
            }
            if (o instanceof JAXBElement && ((JAXBElement)o).getDeclaredType().getName().equals("org.docx4j.wml.Tr")) {
                this.startRow();
                tr = (Tr)((JAXBElement)o).getValue();
                this.handleRow(cellContents, tr, r);
                ++r;
                continue;
            }
            if (o instanceof JAXBElement && ((JAXBElement)o).getDeclaredType().getName().equals("org.docx4j.wml.CTSdtRow")) {
                CTSdtRow sdt = (CTSdtRow)((JAXBElement)o).getValue();
                for (Object content0 : sdt.getSdtContent().getContent()) {
                    if (content0 instanceof Tr) {
                        this.startRow();
                        tr = (Tr)content0;
                        this.handleRow(cellContents, tr, r);
                        ++r;
                        continue;
                    }
                    log.warn((Object)("Unexpected " + content0.getClass().getName()));
                }
                continue;
            }
            if (o instanceof JAXBElement) {
                if (((JAXBElement)o).getDeclaredType().getName().equals("org.docx4j.wml.CTMarkupRange")) continue;
                log.warn((Object)("TODO - skipping JAXBElement:  " + ((JAXBElement)o).getDeclaredType().getName()));
                log.debug((Object)XmlUtils.marshaltoString(o, true));
                continue;
            }
            log.warn((Object)("TODO - skipping:  " + o.getClass().getName()));
            log.debug((Object)XmlUtils.marshaltoString(o, true));
        }
    }

    private void handleRow(NodeList cellContents, Tr tr, int r) {
        System.out.println("Processing r " + r);
        if (this.borderConflictResolutionRequired && tr.getTblPrEx() != null && tr.getTblPrEx().getTblCellSpacing() != null) {
            this.borderConflictResolutionRequired = false;
        }
        List<Object> cells = tr.getEGContentCellContent();
        int c = 0;
        System.out.println("Processing c " + c);
        for (Object o2 : cells) {
            Tc tc = null;
            if (o2 instanceof Tc) {
                tc = (Tc)o2;
            } else if (o2 instanceof JAXBElement && ((JAXBElement)o2).getDeclaredType().getName().equals("org.docx4j.wml.Tc")) {
                tc = (Tc)((JAXBElement)o2).getValue();
            } else if (o2 instanceof JAXBElement && ((JAXBElement)o2).getDeclaredType().getName().equals("org.docx4j.wml.CTSdtCell")) {
                CTSdtCell sdtCell = (CTSdtCell)((JAXBElement)o2).getValue();
                Object o3 = sdtCell.getSdtContent().getContent().get(0);
                if (o3 instanceof JAXBElement && ((JAXBElement)o3).getDeclaredType().getName().equals("org.docx4j.wml.Tc")) {
                    tc = (Tc)((JAXBElement)o3).getValue();
                } else if (o3 instanceof JAXBElement) {
                    log.warn((Object)("TODO - skipping JAXBElement:  " + ((JAXBElement)o3).getDeclaredType().getName()));
                } else {
                    log.warn((Object)("TODO - skipping:  " + o3.getClass().getName()));
                }
                if (sdtCell.getSdtContent().getContent().size() > 1) {
                    log.warn((Object)"w:sdtContent contains more than 1 cell. TODO");
                }
            } else {
                if (o2 instanceof JAXBElement) {
                    log.warn((Object)("TODO - skipping JAXBElement:  " + ((JAXBElement)o2).getDeclaredType().getName()));
                } else {
                    log.warn((Object)("TODO - skipping:  " + o2.getClass().getName()));
                }
                log.debug((Object)XmlUtils.marshaltoString(o2, true));
                continue;
            }
            Node wtrNode = cellContents.item(r);
            if (wtrNode == null) {
                System.out.println("Couldn't find item " + r);
            }
            this.addCell(tc, wtrNode.getChildNodes().item(c));
            ++c;
        }
    }

    @Override
    public Object toJAXB() {
        ObjectFactory factory = Context.getWmlObjectFactory();
        Tbl tbl = factory.createTbl();
        TblPr tblPr = null;
        if (tblPr == null) {
            log.warn((Object)"tblPr is null");
            tblPr = factory.createTblPr();
            TblWidth tblWidth = factory.createTblWidth();
            tblWidth.setW(BigInteger.valueOf(12240L));
            tblWidth.setType("dxa");
            tblPr.setTblW(tblWidth);
        }
        tbl.setTblPr(tblPr);
        if (this.tblGrid == null) {
            log.warn((Object)"tblGrid is null");
            this.tblGrid = factory.createTblGrid();
            int width = Math.round(tbl.getTblPr().getTblW().getW().floatValue() / (float)this.getColCount());
            for (int i = 0; i < this.getColCount(); ++i) {
                TblGridCol tblGridCol = factory.createTblGridCol();
                tblGridCol.setW(BigInteger.valueOf(width));
                this.tblGrid.getGridCol().add(tblGridCol);
            }
        }
        tbl.setTblGrid(this.tblGrid);
        for (int i = 0; i < this.cells.size(); ++i) {
            Tr tr = factory.createTr();
            tbl.getEGContentRowContent().add(tr);
            for (int j = 0; j < this.getColCount(); ++j) {
                TcPrInner.VMerge vm;
                TcPr tcPr;
                Tc tc = factory.createTc();
                Cell cell = this.cells.get(i).get(j);
                if (cell == null) {
                    tr.getEGContentCellContent().add(tc);
                    continue;
                }
                if (cell.isDummy()) {
                    if (j > 0 && (this.cells.get(i).get(j - 1).isDummy() || this.cells.get((int)i).get((int)(j - 1)).colspan > 1)) continue;
                    if (i > 0 && (this.cells.get(i - 1).get(j).isDummy() || this.cells.get((int)(i - 1)).get((int)j).rowspan > 1)) {
                        tcPr = factory.createTcPr();
                        vm = factory.createTcPrInnerVMerge();
                        tcPr.setVMerge(vm);
                        tc.setTcPr(tcPr);
                        tr.getEGContentCellContent().add(tc);
                        P p = factory.createP();
                        tc.getEGBlockLevelElts().add(p);
                        continue;
                    }
                    log.error((Object)("Encountered phantom dummy cell at (" + i + "," + j + ") "));
                    log.debug((Object)this.debugStr());
                    continue;
                }
                tcPr = factory.createTcPr();
                if (cell.colspan > 1) {
                    TcPrInner.GridSpan gridSpan = factory.createTcPrInnerGridSpan();
                    gridSpan.setVal(BigInteger.valueOf(cell.colspan));
                    tcPr.setGridSpan(gridSpan);
                    tc.setTcPr(tcPr);
                }
                if (cell.rowspan > 1) {
                    vm = factory.createTcPrInnerVMerge();
                    vm.setVal("restart");
                    tcPr.setVMerge(vm);
                    tc.setTcPr(tcPr);
                }
                if (cell.colspan > 1 && cell.rowspan > 1) {
                    log.warn((Object)"Both rowspan & colspan set; that will be interesting..");
                }
                tr.getEGContentCellContent().add(tc);
                Node foreign = cell.getContent();
                for (int n = 0; n < foreign.getChildNodes().getLength(); ++n) {
                    try {
                        Object o = XmlUtils.unmarshal(foreign.getChildNodes().item(n));
                        tc.getEGBlockLevelElts().add(o);
                        continue;
                    }
                    catch (JAXBException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return tbl;
    }

    private void debugCellContents(NodeList children) {
        for (int i = 0; i < children.getLength(); ++i) {
            log.debug((Object)i);
            log.debug((Object)children.item(i).getTextContent());
            log.debug((Object)children.item(i).getLocalName());
        }
    }

    public String debugStr() {
        StringBuffer buf = new StringBuffer();
        for (List<Cell> rows : this.cells) {
            for (Cell c : rows) {
                if (c == null) {
                    buf.append("null     ");
                    continue;
                }
                buf.append(c.debugStr());
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static class TableModelTransformState
    implements TransformState {
        int idx = 0;

        public int getIdx() {
            return this.idx;
        }

        public void incrementIdx() {
            ++this.idx;
        }
    }
}

