/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging;

import org.apache.log4j.Logger;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;

public abstract class Base {
    protected static Logger log = Logger.getLogger(Base.class);
    public RelationshipsPart relationships;
    protected ContentType contentType;
    public PartName partName;

    public abstract OpcPackage getPackage();

    public RelationshipsPart getRelationshipsPart() {
        return this.getRelationshipsPart(true);
    }

    public RelationshipsPart getRelationshipsPart(boolean createIfAbsent) {
        if (this instanceof RelationshipsPart) {
            return null;
        }
        if (this.relationships == null && createIfAbsent) {
            this.relationships = RelationshipsPart.createRelationshipsPartForPart(this);
        }
        return this.relationships;
    }

    public void setRelationships(RelationshipsPart relationships) {
        if (relationships != null) {
            relationships.setPackage(this.getPackage());
        }
        this.relationships = relationships;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType.toString();
        }
        log.warn((Object)"WARNING: content type was null. You should set this before adding the part.");
        return null;
    }

    public void setContentType(ContentType contentType) {
        log.debug((Object)("\nSet contentType " + contentType + " on part " + this.getPartName().getName() + "\n\n"));
        this.contentType = contentType;
    }

    public PartName getPartName() {
        if (this.partName == null) {
            log.error((Object)"PartName was null!");
            try {
                return new PartName("/null");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
        return this.partName;
    }

    public abstract boolean setPartShortcut(Part var1, String var2);

    public Relationship addTargetPart(Part targetpart, RelationshipsPart.AddPartBehaviour mode) throws InvalidFormatException {
        return this.addTargetPart(targetpart, mode, null);
    }

    public Relationship addTargetPart(Part targetpart) throws InvalidFormatException {
        return this.addTargetPart(targetpart, RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS, null);
    }

    public Relationship addTargetPart(Part targetpart, String proposedRelId) throws InvalidFormatException {
        return this.addTargetPart(targetpart, RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS, proposedRelId);
    }

    public Relationship addTargetPart(Part targetpart, RelationshipsPart.AddPartBehaviour mode, String proposedRelId) throws InvalidFormatException {
        if (this.getPackage() == null) {
            throw new InvalidFormatException("Package not set; if you are adding part2 to part1, make sure part1 is added first.");
        }
        if (this instanceof RelationshipsPart) {
            throw new InvalidFormatException("You should add your part to the target part, not the target part's relationships part.");
        }
        Relationship rel = this.getRelationshipsPart().addPart(targetpart, mode, this.getPackage().getContentTypeManager(), proposedRelId);
        boolean shortcutSet = this.setPartShortcut(targetpart, targetpart.getRelationshipType());
        if (shortcutSet) {
            log.info((Object)"shortcut was set");
        }
        return rel;
    }
}

