/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging;

import java.net.URI;
import org.docx4j.openpackaging.URIHelper;
import org.junit.Assert;
import org.junit.Test;

public class URIHelperTest {
    public static void main(String[] args) throws Exception {
    }

    @Test
    public void testRelativizeURI() throws Exception {
        URI uri1 = new URI("/word/document.xml");
        URI uri2 = new URI("/word/media/image1.gif");
        URI retURI1to2 = URIHelper.relativizeURI(uri1, uri2);
        Assert.assertEquals((Object)"media/image1.gif", (Object)retURI1to2.getPath());
        URI retURI2to1 = URIHelper.relativizeURI(uri2, uri1);
        Assert.assertEquals((Object)"../document.xml", (Object)retURI2to1.getPath());
        URI uriCustomXml = new URI("/customXml/item1.xml");
        URI uriRes = URIHelper.relativizeURI(uri1, uriCustomXml);
        Assert.assertEquals((Object)"../customXml/item1.xml", (Object)uriRes.toString());
        URI retURI2 = URIHelper.relativizeURI(uri1, uri1);
        Assert.assertEquals((Object)"", (Object)retURI2.getPath());
        URI uri4 = new URI("/");
        try {
            System.out.println(URIHelper.relativizeURI(uri1, uri4));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.out.println(URIHelper.relativizeURI(uri4, uri1));
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

