/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageBmpPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageGifPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageJpegPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageTiffPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileEmfPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileWmfPart;

public class ExternalResourceUtils {
    private static Logger log = Logger.getLogger(ExternalResourceUtils.class);
    protected static final Map<String, String> CONTENT_TYPE_MAP = new TreeMap<String, String>();

    public static BinaryPart getExternalResource(String absoluteTarget) throws Docx4JException {
        URI targetURI = null;
        URL targetURL = null;
        int p = absoluteTarget.lastIndexOf(46);
        String fileExtension = p > -1 ? absoluteTarget.substring(p + 1).toLowerCase() : null;
        String contentType = fileExtension != null ? CONTENT_TYPE_MAP.get(fileExtension) : null;
        BinaryPart binaryPart = null;
        InputStream inStream = null;
        try {
            targetURI = new URI(absoluteTarget.replace('\\', '/'));
        }
        catch (URISyntaxException use) {
            throw new Docx4JException("Invalid absolute Target: '" + absoluteTarget + "'", use);
        }
        try {
            targetURL = targetURI.toURL();
        }
        catch (MalformedURLException mue) {
            throw new Docx4JException("Invalid absolute Target: '" + absoluteTarget + "'", mue);
        }
        try {
            inStream = targetURL.openStream();
            binaryPart = ExternalResourceUtils.createBinaryPart(absoluteTarget, contentType);
            binaryPart.setBinaryData(inStream);
        }
        catch (IOException ioe) {
            throw new Docx4JException("Could not load external resource: '" + absoluteTarget + "'", ioe);
        }
        return binaryPart;
    }

    protected static BinaryPart createBinaryPart(String absoluteTarget, String contentType) {
        ExternalTarget externalTarget = new ExternalTarget(absoluteTarget);
        BinaryPart ret = null;
        ret = "image/jpeg".equals(contentType) ? new ImageJpegPart(externalTarget) : ("image/png".equals(contentType) ? new ImagePngPart(externalTarget) : ("image/gif".equals(contentType) ? new ImageGifPart(externalTarget) : ("image/tiff".equals(contentType) ? new ImageTiffPart(externalTarget) : ("image/bmp".equals(contentType) ? new ImageBmpPart(externalTarget) : ("image/x-emf".equals(contentType) ? new MetafileEmfPart(externalTarget) : ("image/x-wmf".equals(contentType) ? new MetafileWmfPart(externalTarget) : new BinaryPart(externalTarget)))))));
        return ret;
    }

    static {
        CONTENT_TYPE_MAP.put("bmp", "image/bmp");
        CONTENT_TYPE_MAP.put("emf", "image/x-emf");
        CONTENT_TYPE_MAP.put("gif", "image/gif");
        CONTENT_TYPE_MAP.put("jpg", "image/jpeg");
        CONTENT_TYPE_MAP.put("jpeg", "image/jpeg");
        CONTENT_TYPE_MAP.put("png", "image/png");
        CONTENT_TYPE_MAP.put("tiff", "image/tiff");
        CONTENT_TYPE_MAP.put("tif", "image/tiff");
        CONTENT_TYPE_MAP.put("wmf", "image/x-wmf");
    }
}

