/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import org.apache.log4j.Logger;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.Parts;
import org.w3c.dom.Document;

public final class CustomXmlDataStoragePart
extends Part {
    private static Logger log = Logger.getLogger(CustomXmlDataStoragePart.class);
    private CustomXmlDataStorage data;

    public CustomXmlDataStoragePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public CustomXmlDataStoragePart() throws InvalidFormatException {
        super(new PartName("/customXml/item1.xml"));
        this.init();
    }

    @Deprecated
    public CustomXmlDataStoragePart(Parts parts) throws InvalidFormatException {
        int partNum = 1;
        if (parts != null) {
            while (parts.get(new PartName("/customXml/item" + partNum + ".xml")) != null) {
                ++partNum;
            }
        }
        this.partName = new PartName("/customXml/item" + partNum + ".xml");
        log.info((Object)("Using PartName /customXml/item" + partNum + ".xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml");
    }

    public CustomXmlDataStorage getData() {
        return this.data;
    }

    public void setData(CustomXmlDataStorage data) {
        this.data = data;
    }

    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof CustomXmlDataStoragePart)) {
            return false;
        }
        Document doc1 = this.data.getDocument();
        Document doc2 = ((CustomXmlDataStoragePart)other).data.getDocument();
        return doc1.isEqualNode(doc2);
    }
}

