/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.util.List;
import javax.xml.bind.Binder;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.Document;
import org.docx4j.wml.Hdr;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

public class AlternateContentPreprocessorTest {
    @Test
    public void testAlternateContent() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/2010/2010-mcAlternateContent.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getCommentsPart().getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Comments jaxbElement = (Comments)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:pict/v:oval", false);
        int count = list.size();
        Assert.assertTrue((String)("expected oval but got " + count), (count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAlternateContentMDP() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/2010/2010-mcAlternateContent-MDP.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Document jaxbElement = (Document)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:pict/v:oval", false);
        int count = list.size();
        Assert.assertTrue((String)("expected oval but got " + count), (count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGlowAndAlternateContent() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/2010/2010-glow-then-AlternateContent.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Document jaxbElement = (Document)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:pict/v:oval", false);
        int count = list.size();
        Assert.assertTrue((String)("expected oval but got " + count), (count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaderDocx() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/2010/2010-mcAlternateContent-in-header.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        List<SectionWrapper> sectionWrappers = wordMLPackage.getDocumentModel().getSections();
        JaxbXmlPart header = null;
        for (SectionWrapper sw : sectionWrappers) {
            HeaderFooterPolicy hfp = sw.getHeaderFooterPolicy();
            if (hfp.getDefaultHeader() == null) continue;
            header = hfp.getDefaultHeader();
        }
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(header.getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Hdr jaxbElement = (Hdr)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:pict/v:oval", false);
        int count = list.size();
        Assert.assertTrue((String)("expected oval but got " + count), (count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaderFlatOPC() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/2010/2010-mcAlternateContent-in-header.xml";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        List<SectionWrapper> sectionWrappers = wordMLPackage.getDocumentModel().getSections();
        JaxbXmlPart header = null;
        for (SectionWrapper sw : sectionWrappers) {
            HeaderFooterPolicy hfp = sw.getHeaderFooterPolicy();
            if (hfp.getDefaultHeader() == null) continue;
            header = hfp.getDefaultHeader();
        }
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(header.getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Hdr jaxbElement = (Hdr)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:pict/v:oval", false);
        int count = list.size();
        Assert.assertTrue((String)("expected oval but got " + count), (count == 1 ? 1 : 0) != 0);
    }
}

