/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlPart
extends Part {
    protected Document doc;
    private static XPathFactory xPathFactory;
    private static XPath xPath;
    private static DocumentBuilderFactory documentFactory;
    private NamespacePrefixMappings nsContext;

    public XmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public XmlPart() throws InvalidFormatException {
    }

    private NamespacePrefixMappings getNamespaceContext() {
        if (this.nsContext == null) {
            this.nsContext = new NamespacePrefixMappings();
            xPath.setNamespaceContext(this.nsContext);
        }
        return this.nsContext;
    }

    public void setDocument(InputStream is) throws Docx4JException {
        try {
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(is);
        }
        catch (Exception e) {
            throw new Docx4JException("Problems parsing InputStream for part " + this.partName.getName(), e);
        }
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public abstract Document getDocument() throws Docx4JException;

    public String xpathGetString(String xpathString, String prefixMappings) throws Docx4JException {
        try {
            this.getNamespaceContext();
            NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
            String result = xPath.evaluate(xpathString, this.doc);
            log.debug((Object)(xpathString + " ---> " + result));
            return result;
        }
        catch (Exception e) {
            throw new Docx4JException("Problems evaluating xpath '" + xpathString + "'", e);
        }
    }

    public List<Node> xpathGetNodes(String xpathString, String prefixMappings) {
        this.getNamespaceContext();
        NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
        return XmlUtils.xpath(this.doc, xpathString, this.getNamespaceContext());
    }

    public boolean setNodeValueAtXPath(String xpath, String value, String prefixMappings) throws Docx4JException {
        try {
            this.getNamespaceContext();
            NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
            Node n = (Node)xPath.evaluate(xpath, this.doc, XPathConstants.NODE);
            if (n == null) {
                log.debug((Object)"xpath returned null");
                return false;
            }
            log.debug((Object)n.getClass().getName());
            if (n.getChildNodes() != null && n.getChildNodes().getLength() > 0) {
                NodeList nodes = n.getChildNodes();
                for (int i = nodes.getLength(); i > 0; --i) {
                    n.removeChild(nodes.item(i - 1));
                }
            }
            Text t = n.getOwnerDocument().createTextNode(value);
            n.appendChild(t);
            return true;
        }
        catch (Exception e) {
            throw new Docx4JException("Problem setting value at xpath " + xpath);
        }
    }

    @Override
    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof XmlPart)) {
            return false;
        }
        Document doc1 = this.getDocument();
        Document doc2 = ((XmlPart)other).getDocument();
        return doc1.isEqualNode(doc2);
    }

    static {
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            documentFactory = DocumentBuilderFactory.newInstance();
            log.info((Object)"Using javax.xml.parsers.DocumentBuilderFactory: org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
        catch (FactoryConfigurationError fce) {
            log.warn((Object)"Couldn't set javax.xml.parsers.DocumentBuilderFactory: org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            try {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                documentFactory = DocumentBuilderFactory.newInstance();
                log.info((Object)"Using javax.xml.parsers.DocumentBuilderFactory: com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            }
            catch (FactoryConfigurationError fce2) {
                log.warn((Object)"Couldn't set javax.xml.parsers.DocumentBuilderFactory: com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                documentFactory = DocumentBuilderFactory.newInstance();
                log.info((Object)("Falling back to: " + documentFactory.getClass().getName()));
            }
        }
        xPathFactory = XPathFactory.newInstance();
        xPath = xPathFactory.newXPath();
        documentFactory.setNamespaceAware(true);
    }
}

