/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.relationships;

import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.AlteredPartsTest;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AddPartTests {
    protected static Logger log = Logger.getLogger(AlteredPartsTest.class);

    @Before
    public void setUp() throws Exception {
        Context.getWmlObjectFactory();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOverwriteNoPart() throws Exception {
        this.noPart(RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS);
    }

    @Test
    public void testReuseWhenNoPart() throws Exception {
        this.noPart(RelationshipsPart.AddPartBehaviour.REUSE_EXISTING);
    }

    @Test
    public void testRenameWhenNoPart() throws Exception {
        this.noPart(RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
    }

    private void noPart(RelationshipsPart.AddPartBehaviour mode) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        int relsCountBefore = wordMLPackage.getMainDocumentPart().getRelationshipsPart().size();
        int partsCountBefore = wordMLPackage.getParts().getParts().size();
        HeaderPart part = new HeaderPart();
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)part, mode);
        Assert.assertTrue((String)"hmm", (wordMLPackage.getMainDocumentPart().getRelationshipsPart().size() == relsCountBefore + 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"hmm", (wordMLPackage.getParts().getParts().size() == partsCountBefore + 1 ? 1 : 0) != 0);
    }

    @Test
    public void testOverwritePartExistsInPkg() throws Exception {
        this.inPkg(RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS, 0, 1, true);
    }

    @Test
    public void testReusePartExistsInPkg() throws Exception {
        this.inPkg(RelationshipsPart.AddPartBehaviour.REUSE_EXISTING, 0, 1, false);
    }

    @Test
    public void testRenamePartExistsInPkg() throws Exception {
        this.inPkg(RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS, 1, 1, true);
    }

    private void inPkg(RelationshipsPart.AddPartBehaviour mode, int partsAdded, int relsAdded, boolean expectReplace) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        HeaderPart part = new HeaderPart();
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)part, mode);
        int rootRelsCountBefore = wordMLPackage.getRelationshipsPart().size();
        int partsCountBefore = wordMLPackage.getParts().getParts().size();
        HeaderPart part2 = new HeaderPart();
        part2.getContent().add(Context.getWmlObjectFactory().createP());
        Relationship rel = wordMLPackage.addTargetPart((Part)part2, mode);
        Assert.assertTrue((String)"hmm", (wordMLPackage.getRelationshipsPart().size() == rootRelsCountBefore + relsAdded ? 1 : 0) != 0);
        Assert.assertTrue((String)"hmm", (wordMLPackage.getParts().getParts().size() == partsCountBefore + partsAdded ? 1 : 0) != 0);
        HeaderPart result = (HeaderPart)wordMLPackage.getRelationshipsPart().getPart(rel);
        if (expectReplace) {
            Assert.assertTrue((String)"hmm", (result.getContent().size() == 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"hmm", (result.getContent().size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOverwritePartExistsInRels() throws Exception {
        this.inRels(RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS, 0, 0, true);
    }

    @Test
    public void testReusePartExistsInRels() throws Exception {
        this.inRels(RelationshipsPart.AddPartBehaviour.REUSE_EXISTING, 0, 0, false);
    }

    @Test
    public void testRenamePartExistsInRels() throws Exception {
        this.inRels(RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS, 1, 1, true);
    }

    private void inRels(RelationshipsPart.AddPartBehaviour mode, int partsAdded, int relsAdded, boolean expectReplace) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        HeaderPart part = new HeaderPart();
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)part, mode);
        int relsCountBefore = wordMLPackage.getMainDocumentPart().getRelationshipsPart().size();
        int partsCountBefore = wordMLPackage.getParts().getParts().size();
        HeaderPart part2 = new HeaderPart();
        part2.getContent().add(Context.getWmlObjectFactory().createP());
        Relationship rel = wordMLPackage.getMainDocumentPart().addTargetPart((Part)part2, mode);
        Assert.assertTrue((String)"hmm", (wordMLPackage.getMainDocumentPart().getRelationshipsPart().size() == relsCountBefore + relsAdded ? 1 : 0) != 0);
        Assert.assertTrue((String)"hmm", (wordMLPackage.getParts().getParts().size() == partsCountBefore + partsAdded ? 1 : 0) != 0);
        HeaderPart result = (HeaderPart)wordMLPackage.getMainDocumentPart().getRelationshipsPart().getPart(rel);
        if (expectReplace) {
            Assert.assertTrue((String)"hmm", (result.getContent().size() == 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"hmm", (result.getContent().size() == 0 ? 1 : 0) != 0);
        }
    }
}

