/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.opendope.JaxbCustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.samples.AbstractSample;

public class ContentControlsPartsInfo
extends AbstractSample {
    private static Logger log = Logger.getLogger(ContentControlsPartsInfo.class);
    public static HashMap<Part, Part> handled = new HashMap();

    public static void main(String[] args) throws Exception {
        try {
            ContentControlsPartsInfo.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/databinding/invoice.docx";
        }
        OpcPackage opcPackage = OpcPackage.load(new File(inputfilepath));
        RelationshipsPart rp = opcPackage.getRelationshipsPart();
        StringBuilder sb = new StringBuilder();
        ContentControlsPartsInfo.traverseRelationships(opcPackage, rp, sb, "    ");
        ContentControlsPartsInfo.approach2(opcPackage, sb);
        System.out.println(sb.toString());
    }

    public static void printInfo(Part p, StringBuilder sb, String indent) throws Docx4JException {
        String relationshipType = "";
        if (p.getSourceRelationships().size() > 0) {
            relationshipType = p.getSourceRelationships().get(0).getType();
        }
        if (p instanceof CustomXmlDataStoragePart) {
            sb.append("\n" + indent + p.getClass().getName() + ": " + indent + p.getPartName().getName());
            sb.append("\n" + indent + "root element: " + ((CustomXmlDataStoragePart)p).getData().getDocument().getDocumentElement().getLocalName());
        } else if (p instanceof JaxbCustomXmlDataStoragePart) {
            sb.append("\n" + indent + p.getClass().getName() + ": " + indent + p.getPartName().getName());
        } else if (p instanceof CustomXmlDataStoragePropertiesPart) {
            CustomXmlDataStoragePropertiesPart pp = (CustomXmlDataStoragePropertiesPart)p;
            sb.append("\n" + indent + p.getPartName().getName() + "  item id: " + pp.getItemId());
        }
    }

    public static void traverseRelationships(OpcPackage wordMLPackage, RelationshipsPart rp, StringBuilder sb, String indent) throws Docx4JException {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().contains("customXml")) {
                sb.append("\n" + indent + "For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget() + " of type " + r.getType());
            }
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) continue;
            Part part = rp.getPart(r);
            ContentControlsPartsInfo.printInfo(part, sb, indent);
            if (handled.get(part) != null) {
                sb.append(" [additional reference] ");
                continue;
            }
            handled.put(part, part);
            if (part.getRelationshipsPart() == null) continue;
            ContentControlsPartsInfo.traverseRelationships(wordMLPackage, part.getRelationshipsPart(), sb, indent + "    ");
        }
    }

    public static void approach2(OpcPackage pkg, StringBuilder sb) {
        sb.append("\n\n Approach 2:");
        HashMap<PartName, Part> parts = pkg.getParts().getParts();
        HashMap<String, Part> tmp = new HashMap<String, Part>();
        Collection<Part> col = parts.values();
        for (Part entry : col) {
            if (!(entry instanceof CustomXmlDataStoragePart) && !(entry instanceof JaxbCustomXmlDataStoragePart)) continue;
            sb.append("\nFound a CustomXmlDataStoragePart, named " + entry.getPartName().getName());
            if (entry.getRelationshipsPart() == null) continue;
            sb.append("\n.. it has a rels part");
            Relationship r = entry.getRelationshipsPart().getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps");
            if (r == null) {
                sb.append("\n.. but that doesn't point to a  customXmlProps part");
                continue;
            }
            CustomXmlDataStoragePropertiesPart customXmlProps = (CustomXmlDataStoragePropertiesPart)entry.getRelationshipsPart().getPart(r);
            if (customXmlProps == null) {
                sb.append("\n.. but the target seems to be missing?");
                continue;
            }
            String itemId = customXmlProps.getItemId().toLowerCase();
            sb.append("\nIdentified/registered ds:itemId " + itemId);
            if (tmp.get(itemId.toLowerCase()) != null) {
                sb.append("\nDuplicate CustomXML itemId " + itemId + "; check your source docx!");
            }
            tmp.put(itemId, entry);
        }
    }
}

