/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HtmlExporterNG2;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;

public class ConvertInXHTMLDocument {
    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/sample-docx.docx";
        XHTMLImporter.setHyperlinkStyle("Hyperlink");
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
        wordMLPackage.getMainDocumentPart().addTargetPart(ndp);
        ndp.unmarshalDefaultNumbering();
        if (inputfilepath.endsWith("html")) {
            wordMLPackage.getMainDocumentPart().getContent().addAll(XHTMLImporter.convert(new File(inputfilepath), null, wordMLPackage));
        } else if (inputfilepath.endsWith("docx")) {
            WordprocessingMLPackage docx = WordprocessingMLPackage.load(new File(inputfilepath));
            HtmlExporterNG2 exporter = new HtmlExporterNG2();
            FileOutputStream os = new FileOutputStream(inputfilepath + ".html");
            AbstractHtmlExporter.HtmlSettings htmlSettings = new AbstractHtmlExporter.HtmlSettings();
            htmlSettings.setImageDirPath(inputfilepath + "_files");
            htmlSettings.setImageTargetUri(inputfilepath.substring(inputfilepath.lastIndexOf("/") + 1) + "_files");
            StreamResult result = new StreamResult(os);
            ((AbstractHtmlExporter)exporter).html(docx, (Result)result, htmlSettings);
            wordMLPackage.getMainDocumentPart().getContent().addAll(XHTMLImporter.convert(new File(inputfilepath + ".html"), null, wordMLPackage));
        } else {
            return;
        }
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/html_output.docx"));
    }
}

