/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HtmlExporterNG2;
import org.docx4j.convert.out.html.SdtWriter;
import org.docx4j.convert.out.html.TagSingleBox;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.samples.AbstractSample;

public class ConvertOutHtml
extends AbstractSample {
    static boolean save;

    public static void main(String[] args) throws Exception {
        try {
            ConvertOutHtml.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        System.out.println(inputfilepath);
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        HtmlExporterNG2 exporter = new HtmlExporterNG2();
        AbstractHtmlExporter.HtmlSettings htmlSettings = new AbstractHtmlExporter.HtmlSettings();
        htmlSettings.setImageDirPath(inputfilepath + "_files");
        htmlSettings.setImageTargetUri(inputfilepath.substring(inputfilepath.lastIndexOf("/") + 1) + "_files");
        htmlSettings.setUserBodyTop("<H1>TOP!</H1>");
        htmlSettings.setUserBodyTail("<H1>TAIL!</H1>");
        SdtWriter.registerTagHandler("XSLT_PBdr", new TagSingleBox());
        SdtWriter.registerTagHandler("XSLT_Shd", new TagSingleBox());
        OutputStream os = save ? new FileOutputStream(inputfilepath + ".html") : System.out;
        StreamResult result = new StreamResult(os);
        ((AbstractHtmlExporter)exporter).html(wordMLPackage, (Result)result, htmlSettings);
        if (save) {
            System.out.println("Saved: " + inputfilepath + ".html using " + exporter.getClass().getName());
        }
    }

    static {
        inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/sample-docx.xml";
        save = true;
    }
}

