/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import org.docx4j.XmlUtils;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.docProps.custom.ObjectFactory;
import org.docx4j.docProps.custom.Properties;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.samples.AbstractSample;

public class DocProps
extends AbstractSample {
    public static void main(String[] args) throws Exception {
        try {
            DocProps.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/docProps.docx";
        }
        boolean save = false;
        try {
            DocProps.getOutputFilePath(args);
            save = true;
        }
        catch (IllegalArgumentException e) {
            outputfilepath = System.getProperty("user.dir") + "/OUT_DocProps.docx";
        }
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        DocPropsCorePart docPropsCorePart = wordMLPackage.getDocPropsCorePart();
        CoreProperties coreProps = (CoreProperties)docPropsCorePart.getJaxbElement();
        System.out.println("'dc:title' is " + ((SimpleLiteral)coreProps.getTitle().getValue()).getContent().get(0));
        DocPropsExtendedPart docPropsExtendedPart = wordMLPackage.getDocPropsExtendedPart();
        Properties extendedProps = (Properties)docPropsExtendedPart.getJaxbElement();
        System.out.println("'Application' is " + extendedProps.getApplication() + " v." + extendedProps.getAppVersion());
        DocPropsCustomPart docPropsCustomPart = wordMLPackage.getDocPropsCustomPart();
        org.docx4j.docProps.custom.Properties customProps = (org.docx4j.docProps.custom.Properties)docPropsCustomPart.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            if (prop.getLpwstr() != null) {
                System.out.println(prop.getName() + " = " + prop.getLpwstr());
                continue;
            }
            System.out.println(prop.getName() + ": \n " + XmlUtils.marshaltoString((Object)prop, true, Context.jcDocPropsCustom));
        }
        ObjectFactory factory = new ObjectFactory();
        Properties.Property newProp = factory.createPropertiesProperty();
        newProp.setName("mynewcustomprop");
        newProp.setFmtid("{D5CDD505-2E9C-101B-9397-08002B2CF9AE}");
        newProp.setPid(customProps.getNextId());
        newProp.setLpwstr("SomeValue");
        customProps.getProperty().add(newProp);
        if (save) {
            SaveToZipFile saver = new SaveToZipFile(wordMLPackage);
            saver.save(outputfilepath);
            System.out.println("Document saved as " + outputfilepath);
        }
    }
}

