/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.P;

public class HyperlinkTest {
    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        P.Hyperlink link = HyperlinkTest.createHyperlink(mdp, "http://slashdot.org");
        P paragraph = Context.getWmlObjectFactory().createP();
        paragraph.getContent().add(link);
        mdp.addObject(paragraph);
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/OUT_HyperlinkTest.docx"));
    }

    public static P.Hyperlink createHyperlink(MainDocumentPart mdp, String url) {
        try {
            ObjectFactory factory = new ObjectFactory();
            Relationship rel = factory.createRelationship();
            rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
            rel.setTarget(url);
            rel.setTargetMode("External");
            mdp.getRelationshipsPart().addRelationship(rel);
            String hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" " + "xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" >" + "<w:r>" + "<w:rPr>" + "<w:rStyle w:val=\"Hyperlink\" />" + "</w:rPr>" + "<w:t>Link</w:t>" + "</w:r>" + "</w:hyperlink>";
            return (P.Hyperlink)XmlUtils.unmarshalString(hpl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

