/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.io.Load;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;

public class PartLoadFromFileSystem {
    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        String path_in = System.getProperty("user.dir") + "/src/test/resources/parts/";
        FileInputStream in = new FileInputStream(path_in + "[Content_Types].xml");
        ContentTypeManager externalCtm = new ContentTypeManager();
        externalCtm.parseContentTypesFile(in);
        in = new FileInputStream(path_in + "settings.xml");
        PartLoadFromFileSystem.attachForeignPart(wordMLPackage, wordMLPackage.getMainDocumentPart(), externalCtm, "word/settings.xml", in);
        in = new FileInputStream(path_in + "app.xml");
        PartLoadFromFileSystem.attachForeignPart(wordMLPackage, wordMLPackage, externalCtm, "docProps/app.xml", in);
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/OUT_PartLoadFromFileSystem.docx"));
    }

    public static void attachForeignPart(WordprocessingMLPackage wordMLPackage, Base attachmentPoint, ContentTypeManager foreignCtm, String resolvedPartUri, InputStream is) throws Exception {
        Part foreignPart = Load.getRawPart(is, foreignCtm, resolvedPartUri, null);
        attachmentPoint.addTargetPart(foreignPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        ContentTypeManager packageCtm = wordMLPackage.getContentTypeManager();
        packageCtm.addOverrideContentType(foreignPart.getPartName().getURI(), foreignPart.getContentType());
        System.out.println("Attached foreign part: " + resolvedPartUri);
    }
}

