/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;

public class Log4jConfigurator {
    public static synchronized void configure() {
        boolean disabled = Boolean.parseBoolean(Docx4jProperties.getProperties().getProperty("docx4j.Log4j.Configurator.disabled", "false"));
        if (disabled) {
            return;
        }
        if (!Log4jConfigurator.isConfigured()) {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.INFO);
            PatternLayout layout = new PatternLayout("%p %c %x.%M line %L - %m%n");
            ((Appender)Logger.getRootLogger().getAllAppenders().nextElement()).setLayout((Layout)layout);
            Logger log = Logger.getLogger(Log4jConfigurator.class);
            log.info((Object)"Since your log4j configuration (if any) was not found, docx4j has configured log4j automatically.");
            try {
                Conversion.log.setLevel(Level.DEBUG);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static boolean isConfigured() {
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        if (appenders.hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger c = (Logger)loggers.nextElement();
            if (!c.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }
}

