////////////////////////////////////////////////////////////////////////
// Simple Feed Parser
////////////////////////////////////////////////////////////////////////
// Support RSS 0.9x/1.0/2.0 & Atom 0.3/1.0
//
// Version: 1.5
// Author: SiC
// Last Modified: 2005-12-09 10:08:21
////////////////////////////////////////////////////////////////////////

var simpleFeedParser={

  // Member Variables
  error: null,

  // *** Get a XMLDOM object ***
  getXMLDOM: function(){
    var objXMLDOM;
    try{
      objXMLDOM = new ActiveXObject("Microsoft.XMLDOM");
      objXMLDOM.async = false;
    }catch(e){
      this.error = e;
      return null;
    }
    return objXMLDOM;
  },

  // *** Parse feed xml ***
  parse: function(xml){
    var objXMLDOM, xslDOM;
    objXMLDOM=this.getXMLDOM();
    if(!objXMLDOM){
      return this.error.number+":"+simpleAjax.error.description;
    }
    objXMLDOM.loadXML(xml);
    if(objXMLDOM.parseError.errorCode!=0){
      return objXMLDOM.parseError.errorCode+':'+objXMLDOM.parseError.reason;
    }else{
      // RSS 0.9x/2.0 Feed
      var result=this.parseFeedNodes(objXMLDOM,
            ["/rss",
             "/rss/channel/link",
             "/rss/channel/title",
             "//item",
             "title",
             "link",
             "description"]);
      if(result) return result;

      // RSS 1.0 Feed
      var result=this.parseFeedNodes(objXMLDOM,
            ["/rdf:RDF",
             "//rss1:channel/rss1:link",
             "//rss1:channel/rss1:title",
             "//rss1:item",
             "rss1:title",
             "rss1:link",
             "rss1:description"]);
      if(result) return result;

      // Atom 0.3 Feed
      var result=this.parseFeedNodes(objXMLDOM,
            ["/atom03:feed",
             "/atom03:feed/atom03:link[@rel='alternate' and @type='text/html']/@href",
             "/atom03:feed/atom03:title",
             "//atom03:entry",
             "atom03:title",
             ['atom03:link[@rel="alternate" and @type="text/html"]/@href','atom03:link[@rel="alternate"]/@href'],
             ["atom03:content","atom03:summary"]
            ]);
      if(result) return result;

      // Atom 1.0 Feed
      var result=this.parseFeedNodes(objXMLDOM,
            ["/atom:feed",
             "/atom:feed/atom:link[@rel='alternate' and @type='text/html']/@href",
             "/atom:feed/atom:title",
             "//atom:entry",
             "atom:title",
             ['atom:link[@rel="alternate" and @type="text/html"]/@href','atom:link[@rel="alternate"]/@href'],
             ["atom:content","atom:summary"]
            ]);
      if(result) return result;

      return 'Unknown Feed Format'
    }
  },

  // *** Common Function for parse feed nodes ***
  parseFeedNodes: function(objXMLDOM,arrParams){
    objXMLDOM.setProperty("SelectionLanguage", "XPath");
    objXMLDOM.setProperty("SelectionNamespaces", 'xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:atom="http://www.w3.org/2005/Atom" xmlns:atom03="http://purl.org/atom/ns#"  xmlns:rss1="http://purl.org/rss/1.0/"');
    if(objXMLDOM.documentElement.selectSingleNode(arrParams[0])){
      var arrItems=new Array();
      var feedlink=this.parseSingleFeedNode(objXMLDOM, arrParams[1]);
      var feedtitle=this.parseSingleFeedNode(objXMLDOM, arrParams[2]);

      var nodes=objXMLDOM.documentElement.selectNodes(arrParams[3]);
      if(nodes.length>0){
        for(var i=0;i<nodes.length;i++){
          var link=this.parseSingleFeedNode(nodes[i], arrParams[5]);
          var title=this.parseSingleFeedNode(nodes[i], arrParams[4]);
          var description=this.parseSingleFeedNode(nodes[i], arrParams[6]);
          if(title==""){ (link!="") ? title=link : "" };
          if(title!=""||link!="") arrItems.push({"title":title, "link":link, "description":description});
        }
      }
      return {"title":feedtitle, "link":feedlink, "items":arrItems};
    }else{
      return null;
    }
  },

  parseSingleFeedNode: function(node, arrParams){
    if(typeof(arrParams)=="string") arrParams=new Array(arrParams);
    for(var i=0;i<arrParams.length;i++){
      var item=node.selectSingleNode(arrParams[i]);
      if(item){
        return item.text;
      }
    }
    return "";
  }

}