unit kys_script;

interface

uses
  SysUtils,
  Classes,
  windows,
  Dialogs,
  Math,
  SDL,
  lua,
  kys_main,
  kys_event,
  kys_engine,
  kys_battle;

//ʼű,нű
procedure InitialScript;
procedure DestroyScript;
function ExecScript(filename, functionname: pchar): integer;

//ָ,װָ
function Pause(L: Plua_state): integer; cdecl;
function GetMousePosition(L: Plua_state): integer; cdecl;
function ClearButton(L: Plua_state): integer; cdecl;
function CheckButton(L: Plua_state): integer; cdecl;
function GetButton(L: Plua_state): integer; cdecl;
function GetTime(L: Plua_state): integer; cdecl;
function ExecEvent(L: Plua_state): integer; cdecl;

function Clear(L: Plua_state): integer; cdecl;
function Talk(L: Plua_state): integer; cdecl;
function GetItem(L: Plua_state): integer; cdecl;
function AddItem(L: Plua_state): integer; cdecl;
function ShowString(L: Plua_state): integer; cdecl;
function ShowStringWithBox(L: Plua_state): integer; cdecl;
function Menu(L: Plua_state): integer; cdecl;
function AskYesOrNo(L: Plua_state): integer; cdecl;
function ModifyEvent(L: Plua_state): integer; cdecl;
function UseItem(L: Plua_state): integer; cdecl;
function HaveItem(L: Plua_state): integer; cdecl;
function AnotherGetItem(L: Plua_state): integer; cdecl;
function CompareProInTeam(L: Plua_state): integer; cdecl;
function AllLeave(L: Plua_state): integer; cdecl;
function AskBattle(L: Plua_state): integer; cdecl;
function TryBattle(L: Plua_state): integer; cdecl;
function AskJoin(L: Plua_state): integer; cdecl;
function Join(L: Plua_state): integer; cdecl;
function AskRest(L: Plua_state): integer; cdecl;
function Rest(L: Plua_state): integer; cdecl;
function LightScence(L: Plua_state): integer; cdecl;
function DarkScence(L: Plua_state): integer; cdecl;
function Dead(L: Plua_state): integer; cdecl;
function InTeam(L: Plua_state): integer; cdecl;
function TeamIsFull(L: Plua_state): integer; cdecl;
function LeaveTeam(L: Plua_state): integer; cdecl;
function LearnMagic(L: Plua_state): integer; cdecl;
//function Sprintf(L: Plua_state): integer; cdecl;
function GetMainMapPosition(L: Plua_state): integer; cdecl;
function SetMainMapPosition(L: Plua_state): integer; cdecl;
function GetScencePosition(L: Plua_state): integer; cdecl;
function SetScencePosition(L: Plua_state): integer; cdecl;
function GetScenceFace(L: Plua_state): integer; cdecl;
function SetScenceFace(L: Plua_state): integer; cdecl;
function Delay(L: Plua_state): integer; cdecl;
function DrawRect(L: Plua_state): integer; cdecl;
function MemberAmount(L: Plua_state): integer; cdecl;
function GetMember(L: Plua_state): integer; cdecl;
function PutMember(L: Plua_state): integer; cdecl;
function GetRolePro(L: Plua_state): integer; cdecl;
function PutRolePro(L: Plua_state): integer; cdecl;
function GetItemPro(L: Plua_state): integer; cdecl;
function PutItemPro(L: Plua_state): integer; cdecl;
function GetMagicPro(L: Plua_state): integer; cdecl;
function PutMagicPro(L: Plua_state): integer; cdecl;
function GetScencePro(L: Plua_state): integer; cdecl;
function PutScencePro(L: Plua_state): integer; cdecl;
function GetScenceMapPro(L: Plua_state): integer; cdecl;
function PutScenceMapPro(L: Plua_state): integer; cdecl;
function GetScenceEventPro(L: Plua_state): integer; cdecl;
function PutScenceEventPro(L: Plua_state): integer; cdecl;
function JudgeScenceEvent(L: Plua_state): integer; cdecl;
function PlayMusic(L: Plua_state): integer; cdecl;
function PlayWave(L: Plua_state): integer; cdecl;
function WalkFromTo(L: Plua_state): integer; cdecl;
function ScenceFromTo(L: Plua_state): integer; cdecl;
function PlayAnimation(L: Plua_state): integer; cdecl;
function GetNameAsString(L: Plua_state): integer; cdecl;
function ChangeScence(L: Plua_state): integer; cdecl;
function ShowPicture(L: Plua_state): integer; cdecl;
function GetItemList(L: Plua_state): integer; cdecl;
function GetCurrentScence(L: Plua_state): integer; cdecl;
function GetCurrentEvent(L: Plua_state): integer; cdecl;

function GetBattleNumber(L: Plua_state): integer; cdecl;
function SelectOneAim(L: Plua_state): integer; cdecl;
function GetBattlePro(L: Plua_state): integer; cdecl;
function PutBattlePro(L: Plua_state): integer; cdecl;
function PlayAction(L: Plua_state): integer; cdecl;
//function GetRoundNumber(L: Plua_state): integer; cdecl;
function PlayHurtValue(L: Plua_state): integer; cdecl;
function SetAminationLayer(L: Plua_state): integer; cdecl;
function ClearRoleFromBattle(L: Plua_state): integer; cdecl;
function AddRoleIntoBattle(L: Plua_state): integer; cdecl;
function ForceBattleResult(L: Plua_state): integer; cdecl;

implementation

procedure InitialScript;
begin
  LoadLua;
  LoadLuaLib;
  Lua_script := lua_open;
  luaopen_base(Lua_script);
  luaopen_table(Lua_script);
  luaopen_math(Lua_script);
  luaopen_string(Lua_script);

  lua_register(Lua_script, 'pause', Pause);
  lua_register(Lua_script, 'getmouseposition', GetMousePosition);
  lua_register(Lua_script, 'clearbutton', ClearButton);
  lua_register(Lua_script, 'checkbutton', CheckButton);
  lua_register(Lua_script, 'getbutton', GetButton);
  lua_register(Lua_script, 'gettime', GetTime);
  lua_register(Lua_script, 'execevent', ExecEvent);

  lua_register(Lua_script, 'clear', Clear);
  lua_register(Lua_script, 'talk', Talk);
  lua_register(Lua_script, 'getitem', GetItem);
  lua_register(Lua_script, 'additem', AddItem);
  lua_register(Lua_script, 'showstring', ShowString);
  lua_register(Lua_script, 'showstringwithbox', ShowStringWithBox);
  lua_register(Lua_script, 'menu', Menu);
  lua_register(Lua_script, 'askyesorno', AskYesOrNo);
  lua_register(Lua_script, 'modifyevent', ModifyEvent);
  lua_register(Lua_script, 'useitem', UseItem);
  lua_register(Lua_script, 'haveitem', HaveItem);
  lua_register(Lua_script, 'anothergetitem', AnotherGetItem);
  lua_register(Lua_script, 'compareprointeam', CompareProInTeam);
  lua_register(Lua_script, 'allleave', AllLeave);
  lua_register(Lua_script, 'askbattle', AskBattle);
  lua_register(Lua_script, 'trybattle', TryBattle);
  lua_register(Lua_script, 'askjoin', AskJoin);
  lua_register(Lua_script, 'join', Join);
  lua_register(Lua_script, 'askrest', AskRest);
  lua_register(Lua_script, 'rest', Rest);
  lua_register(Lua_script, 'lightscence', LightScence);
  lua_register(Lua_script, 'darkscence', DarkScence);
  lua_register(Lua_script, 'dead', Dead);
  lua_register(Lua_script, 'inteam', InTeam);
  lua_register(Lua_script, 'teamisfull', TeamIsFull);
  lua_register(Lua_script, 'leaveteam', LeaveTeam);
  lua_register(Lua_script, 'learnmagic', LearnMagic);
  //lua_register(Lua_script, 'sprintf', Sprintf);
  lua_register(Lua_script, 'getmainmapposition', GetMainMapPosition);
  lua_register(Lua_script, 'setmainmapposition', SetMainMapPosition);
  lua_register(Lua_script, 'getscenceposition', GetScencePosition);
  lua_register(Lua_script, 'setscenceposition', SetScencePosition);
  lua_register(Lua_script, 'getscenceface', GetScenceFace);
  lua_register(Lua_script, 'setscenceface', SetScenceFace);
  lua_register(Lua_script, 'delay', Delay);
  lua_register(Lua_script, 'drawrect', DrawRect);
  lua_register(Lua_script, 'memberamount', MemberAmount);
  lua_register(Lua_script, 'getmember', GetMember);
  lua_register(Lua_script, 'putmember', PutMember);
  lua_register(Lua_script, 'getrolepro', GetRolePro);
  lua_register(Lua_script, 'putrolepro', PutRolePro);
  lua_register(Lua_script, 'getitempro', GetItemPro);
  lua_register(Lua_script, 'putitempro', PutItemPro);
  lua_register(Lua_script, 'getmagicpro', GetMagicPro);
  lua_register(Lua_script, 'putmagicpro', PutMagicPro);
  lua_register(Lua_script, 'getscencepro', GetScencePro);
  lua_register(Lua_script, 'putscencepro', PutScencePro);
  lua_register(Lua_script, 'getscencemappro', GetScenceMapPro);
  lua_register(Lua_script, 'putscencemappro', PutScenceMapPro);
  lua_register(Lua_script, 'getscenceeventpro', GetScenceEventPro);
  lua_register(Lua_script, 'putscenceeventpro', PutScenceEventPro);
  lua_register(Lua_script, 'judgescenceevent', JudgeScenceEvent);
  lua_register(Lua_script, 'playmusic', PlayMusic);
  lua_register(Lua_script, 'playwave', PlayWave);
  lua_register(Lua_script, 'walkfromto', WalkFromTo);
  lua_register(Lua_script, 'scencefromto', ScenceFromTo);
  lua_register(Lua_script, 'playanimation', PlayAnimation);
  lua_register(Lua_script, 'getnameasstring', GetNameAsString);
  lua_register(Lua_script, 'changescence', ChangeScence);
  lua_register(Lua_script, 'showpicture', ShowPicture);
  lua_register(Lua_script, 'getitemlist', GetItemList);
  lua_register(Lua_script, 'getcurrentscence', GetCurrentScence);
  lua_register(Lua_script, 'getcurrentevent', GetCurrentEvent);

  lua_register(Lua_script, 'getbattlenumber', GetBattleNumber);
  lua_register(Lua_script, 'selectoneaim', SelectOneAim);
  lua_register(Lua_script, 'getbattlepro', GetBattlePro);
  lua_register(Lua_script, 'putbattlepro', PutBattlePro);
  lua_register(Lua_script, 'playaction', PlayAction);
  lua_register(Lua_script, 'playhurtvalue', PlayHurtValue);
  lua_register(Lua_script, 'setaminationlayer', SetAminationLayer);
  lua_register(Lua_script, 'clearrolefrombattle', ClearRoleFromBattle);
  lua_register(Lua_script, 'addroleintobattle', AddRoleIntoBattle);
  lua_register(Lua_script, 'forcebattleresult', ForceBattleResult);

end;

procedure DestroyScript;
begin
  lua_close(Lua_script);
  UnloadLuaLib;
  UnloadLua;
end;

function ExecScript(filename, functionname: pchar): integer;
var
  Script: string;
  Data: string;
  h: integer;
  len: integer;
begin
  if fileexists(filename) then
  begin
    h := fileopen(filename, fmopenread);
    len := fileseek(h, 0, 2);
    setlength(Script, len);
    fileseek(h, 0, 0);
    fileread(h, Script[1], len);
    fileclose(h);
    //writeln(script);
    lual_loadbuffer(Lua_script, @script[1], length(script), 'code');
    lua_pcall(Lua_script, 0, 0, 0);
    //lua_dofile(Lua_script,pchar(filename[1]));
    lua_getglobal(Lua_script, functionname);
    //lua_dostring(Lua_script,'f2()');
    result := lua_pcall(Lua_script, 0, 1, 0);
    //writeln(result);
  end;

end;

function Pause(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, waitanykey);
  result := 1;

end;

function GetMousePosition(L: Plua_state): integer; cdecl;
var
  x, y: integer;
begin
  SDL_PollEvent(@event);
  sdl_getmousestate(x, y);
  lua_pushnumber(L, x);
  lua_pushnumber(L, y);
  result := 2;

end;

function ClearButton(L: Plua_state): integer; cdecl;
begin
  //event.type_ := 0;
  event.key.keysym.sym := 0;
  event.button.button := 0;
  result := 0;

end;

//鰴
//event.key.keysym.sym = 1 when mouse motion.

function CheckButton(L: Plua_state): integer; cdecl;
var
  t: integer;
begin
  SDL_PollEvent(@event);
  if (event.button.button > 0) then
  begin
    t := 1;
  end
  else
  begin
    t := 0;
  end;
  lua_pushnumber(L, t);
  sdl_delay(10);
  result := 1;

end;

function GetButton(L: Plua_state): integer; cdecl;
var
  t: integer;
begin
  lua_pushnumber(L, event.key.keysym.sym);
  lua_pushnumber(L, event.button.button);
  result := 2;

end;

function ExecEvent(L: Plua_state): integer; cdecl;
var
  n, e, i: integer;
begin
  n := lua_gettop(L);
  e := floor(lua_tonumber(L, -n));
  for i := 0 to n - 2 do
  begin
    x50[$7100 + i] := floor(lua_tonumber(L, -n + 1 + i));
  end;
  callevent(e);
  result := 0;

end;

//ȡǰʱ

function GetTime(L: Plua_state): integer; cdecl;
var
  t: integer;
begin
  t := floor(time * 86400);
  lua_pushnumber(L, t);
  result := 1;

end;

function Clear(L: Plua_state): integer; cdecl;
begin
  Redraw;
  result := 0;

end;

function Talk(L: Plua_state): integer; cdecl;
var
  rnum, dismode: integer;
  content: widestring;
  len, headx, heady, diagx, diagy, width, line, w1, l1, i: integer;
  str: widestring;
begin
  rnum := floor(lua_tonumber(L, -3));
  dismode := floor(lua_tonumber(L, -2));
  content := lua_tostring(L, -1);

  width := 48;
  line := 4;

  case dismode of
    0:
      begin
        headx := 40;
        heady := 80;
        diagx := 100;
        diagy := 30;
      end;
    1:
      begin
        headx := 546;
        heady := CENTER_Y * 2 - 80;
        diagx := 10;
        diagy := CENTER_Y * 2 - 130;
      end;
    2:
      begin
        headx := -1;
        heady := -1;
        diagx := 100;
        diagy := 30;
      end;
    5:
      begin
        headx := 40;
        heady := CENTER_Y * 2 - 80;
        diagx := 100;
        diagy := CENTER_Y * 2 - 130;
      end;
    4:
      begin
        headx := 546;
        heady := 80;
        diagx := 10;
        diagy := 30;
      end;
    3:
      begin
        headx := -1;
        heady := -1;
        diagx := 100;
        diagy := CENTER_Y * 2 - 130;
      end;
  end;
  drawrectanglewithoutframe(0, diagy - 10, 640, 120, 0, 40);
  if headx > 0 then
    drawheadpic(rnum, headx, heady);
  len := length(content);

  w1 := 0;
  l1 := 0;
  for i := 1 to len do
  begin
    if content[i] <> '*' then
    begin
      str := content[i];
      drawshadowtext(@str[1], diagx + w1 * 10, diagy + l1 * 22, colcolor($FF), colcolor($0));
      if integer(str[1]) < 128 then
        w1 := w1 + 1
      else
        w1 := w1 + 2;
      if w1 >= width then
      begin
        w1 := 0;
        l1 := l1 + 1;
      end;
    end
    else
    begin
      w1 := 0;
      l1 := l1 + 1;
    end;
    if (l1 >= 4) and (i < len) then
    begin
      sdl_updaterect(screen, 0, 0, screen.w, screen.h);
      WaitAnyKey;
      Redraw;
      drawrectanglewithoutframe(0, diagy - 10, 640, 120, 0, 40);
      if headx > 0 then
        drawheadpic(rnum, headx, heady);
      w1 := 0;
      l1 := 0;
    end;
  end;
  sdl_updaterect(screen, 0, 0, screen.w, screen.h);
  waitanykey;
  redraw;
  result := 0;

end;

function GetItem(L: Plua_state): integer; cdecl;
var
  inum, amount: integer;
begin
  //writeln(lua_gettop(L));
  inum := floor(lua_tonumber(L, -2));
  amount := floor(lua_tonumber(L, -1));
  instruct_2(inum, amount);
  result := 0;

end;

function AddItem(L: Plua_state): integer; cdecl;
var
  inum, amount: integer;
begin
  //writeln(lua_gettop(L));
  inum := floor(lua_tonumber(L, -2));
  amount := floor(lua_tonumber(L, -1));
  instruct_32(inum, amount);
  result := 0;

end;

function ShowString(L: Plua_state): integer; cdecl;
var
  x, y: integer;
  str: widestring;
begin
  x := floor(lua_tonumber(L, -3));
  y := floor(lua_tonumber(L, -2));
  str := ' ' + lua_tostring(L, -1);
  DrawShadowText(@str[1], x, y, colcolor(5), colcolor(7));
  sdl_updaterect(screen, 0, 0, screen.w, screen.h);
  result := 0;

end;

function ShowStringWithBox(L: Plua_state): integer; cdecl;
var
  x, y, i, w, h, wt: integer;
  str: widestring;
begin
  x := floor(lua_tonumber(L, -3));
  y := floor(lua_tonumber(L, -2));
  str := ' ' + lua_tostring(L, -1);
  h := 1;
  w := 0;
  wt := 0;
  for i := 1 to length(str) do
  begin
    wt := wt + 1;
    if integer(str[i]) > 128 then
      wt := wt + 1;
    if str[i] = '*' then
    begin
      h := h + 1;
      wt := 0;
    end;
    if wt > w then
      w := wt;
  end;
  DrawRectangle(x + 17, y - 2, w * 10 + 25, h * 22 + 5, 0, colcolor(255), 30);
  DrawShadowText(@str[1], x, y, colcolor(5), colcolor(7));
  sdl_updaterect(screen, 0, 0, screen.w, screen.h);
  result := 0;

end;

function Menu(L: Plua_state): integer; cdecl;
var
  menu, x, y, w, n, m, i: integer;
  p: widestring;
begin

  n := floor(lua_tonumber(L, -5));
  setlength(menustring, m);

  for i := 0 to n - 1 do
  begin
    lua_pushnumber(L, i + 1);
    lua_gettable(L, -2);
    p := lua_tostring(L, -1);
    if p[1] = ' ' then
      menustring[i] := p
    else
      menustring[i] := ' ' + p;
    lua_pop(L, 1);
  end;

  w := floor(lua_tonumber(L, -2));
  y := floor(lua_tonumber(L, -3));
  x := floor(lua_tonumber(L, -4));
  lua_pushnumber(L, CommonScrollMenu(x, y, w, n - 1, 10));
  result := 1;

end;

function AskYesOrNo(L: Plua_state): integer; cdecl;
var
  x, y: integer;
begin
  setlength(menustring, 2);
  menustring[0] := ' ';
  menustring[1] := ' ';
  y := floor(lua_tonumber(L, -2));
  x := floor(lua_tonumber(L, -1));
  lua_pushnumber(L, CommonMenu2(x, y, 78));
  result := 1;
  //writeln(result);

end;

function ModifyEvent(L: Plua_state): integer; cdecl;
var
  x: array of integer;
  i, n: integer;
begin
  n := lua_gettop(L);
  setlength(x, n);
  for i := 0 to n - 1 do
  begin
    x[i] := floor(lua_tonumber(L, -(n - i)));
  end;
  if n = 13 then
    instruct_3(x);
  if n = 4 then
  begin
    if x[0] = -2 then
      x[0] := CurScence;
    if x[1] = -2 then
      x[1] := CurEvent;
    Ddata[x[0], x[1], x[2]] := x[3];
  end;
  result := 0;

end;

function UseItem(L: Plua_state): integer; cdecl;
var
  inum, temp: integer;
begin
  //write(curitem);
  inum := floor(lua_tonumber(L, -1));
  temp := 0;
  if inum = CurItem then
    temp := 1;
  lua_pushnumber(L, temp);
  result := 1;

end;

function HaveItem(L: Plua_state): integer; cdecl;
var
  inum, n, i: integer;
begin
  inum := floor(lua_tonumber(L, -1));
  for i := 0 to MAX_ITEM_AMOUNT do
  begin
    if RItemlist[i].Number = inum then
    begin
      n := RItemlist[i].Amount;
      break;
    end;
  end;
  lua_pushnumber(L, n);
  result := 1;

end;

//ǶѵõƷ

function AnotherGetItem(L: Plua_state): integer; cdecl;
begin
  instruct_41(floor(lua_tonumber(L, -3)), floor(lua_tonumber(L, -2)), floor(lua_tonumber(L, -1)));
  result := 0;

end;

//ĳԵĳֵ

function CompareProInTeam(L: Plua_state): integer; cdecl;
var
  n, i: integer;
begin
  n := 0;
  for i := 0 to 5 do
  begin
    if Rrole[TeamList[i]].data[floor(lua_tonumber(L, -2))] = floor(lua_tonumber(L, -1)) then
      n := n + 1;
  end;

  lua_pushnumber(L, n);
  result := 1;

end;

function AllLeave(L: Plua_state): integer; cdecl;
begin
  instruct_59;
  result := 0;
end;

function AskBattle(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, instruct_5(1, 0));
  result := 1;

end;

function TryBattle(L: Plua_state): integer; cdecl;
var
  t: integer;
begin
  if battle(floor(lua_tonumber(L, -2)), floor(lua_tonumber(L, -1))) then
    t := 1
  else
    t := 0;
  lua_pushnumber(L, t);
  result := 1;

end;

function AskJoin(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, instruct_9(1, 0));
  result := 1;

end;

function Join(L: Plua_state): integer; cdecl;
begin
  instruct_10(floor(lua_tonumber(L, -1)));
  result := 0;

end;

function AskRest(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, instruct_11(1, 0));
  result := 1;

end;

function Rest(L: Plua_state): integer; cdecl;
begin
  instruct_12;
  result := 0;

end;

function LightScence(L: Plua_state): integer; cdecl;
begin
  instruct_13;
  result := 0;

end;

function DarkScence(L: Plua_state): integer; cdecl;
begin
  instruct_14;
  result := 0;

end;

function Dead(L: Plua_state): integer; cdecl;
begin
  instruct_15;
  result := 0;

end;

function InTeam(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, instruct_16(floor(lua_tonumber(L, -1)), 1, 0));
  result := 1;

end;

function TeamIsFull(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, instruct_20(1, 0));
  result := 1;

end;

function LeaveTeam(L: Plua_state): integer; cdecl;
begin
  instruct_21(floor(lua_tonumber(L, -1)));
  result := 0;

end;

function LearnMagic(L: Plua_state): integer; cdecl;
var
  n, i, m: integer;
  x: array of integer;
begin
  n := lua_gettop(L);
  setlength(x, n);
  for i := 0 to n - 1 do
  begin
    x[i] := floor(lua_tonumber(L, -(n - i)));
  end;
  if n = 2 then
  begin
    instruct_33(x[0], x[1], 0);
  end;
  if n = 3 then
  begin
    StudyMagic(x[0], 0, x[1], x[2], 0);
  end;
  if n = 4 then
  begin
    StudyMagic(x[0], x[1], x[2], x[3], 0);
  end;
  result := 0;

end;

//ȡͼ

function GetMainMapPosition(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, My);
  lua_pushnumber(L, Mx);
  result := 2;
end;

//ıͼ

function SetMainMapPosition(L: Plua_state): integer; cdecl;
begin
  Mx := floor(lua_tonumber(L, -1));
  My := floor(lua_tonumber(L, -2));
  result := 0;
end;

//ȡ

function GetScencePosition(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, Sy);
  lua_pushnumber(L, Sx);
  result := 2;
end;

//ı䳡

function SetScencePosition(L: Plua_state): integer; cdecl;
begin
  Sx := floor(lua_tonumber(L, -1));
  Sy := floor(lua_tonumber(L, -2));
  result := 0;
end;

function GetScenceFace(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, SFace);
  result := 1;
end;

function SetScenceFace(L: Plua_state): integer; cdecl;
begin
  Sface := floor(lua_tonumber(L, -1));
  result := 0;
end;

//ʱ

function Delay(L: Plua_state): integer; cdecl;
begin
  sdl_delay(floor(lua_tonumber(L, -1)));
  result := 0;
end;

//ƾ

function DrawRect(L: Plua_state): integer; cdecl;
var
  n, i: integer;
  x: array of integer;
begin
  n := lua_gettop(L);
  setlength(x, n);
  for i := 0 to n - 1 do
  begin
    x[i] := floor(lua_tonumber(L, -(n - i)));
  end;
  result := 0;
  if n = 7 then
    DrawRectangle(x[0], x[1], x[2], x[3], x[4], x[5], x[6]);
  if n = 6 then
    DrawRectangleWithoutFrame(x[0], x[1], x[2], x[3], x[4], x[5]);
  result := 0;

end;

//

function MemberAmount(L: Plua_state): integer; cdecl;
var
  n, i: integer;
begin
  n := 0;
  for i := 0 to 5 do
  begin
    if TeamList[i] >= 0 then
      n := n + 1;
  end;

  lua_pushnumber(L, n);
  result := 1;

end;

//Ϣ

function GetMember(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, TeamList[floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//дϢ

function PutMember(L: Plua_state): integer; cdecl;
begin
  TeamList[floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -2));
  result := 0;

end;

//Ϣ

function GetRolePro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, Rrole[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//дϢ

function PutRolePro(L: Plua_state): integer; cdecl;
begin
  Rrole[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -3));
  result := 0;

end;

//ƷϢ

function GetItemPro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, Ritem[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//дƷϢ

function PutItemPro(L: Plua_state): integer; cdecl;
begin
  Ritem[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -3));
  result := 0;

end;

//书Ϣ

function GetMagicPro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, Rmagic[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//д书Ϣ

function PutMagicPro(L: Plua_state): integer; cdecl;
begin
  Rmagic[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -3));
  result := 0;

end;

//Ϣ

function GetScencePro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, Rscence[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//дϢ

function PutScencePro(L: Plua_state): integer; cdecl;
begin
  Rscence[floor(lua_tonumber(L, -2))].Data[floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -3));
  result := 0;

end;

//ͼϢ

function GetScenceMapPro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, sdata[floor(lua_tonumber(L, -4)), floor(lua_tonumber(L, -3)), floor(lua_tonumber(L, -2)), floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//дͼϢ

function PutScenceMapPro(L: Plua_state): integer; cdecl;
begin
  sdata[floor(lua_tonumber(L, -4)), floor(lua_tonumber(L, -3)), floor(lua_tonumber(L, -2)), floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -5));
  result := 0;

end;

//¼Ϣ

function GetScenceEventPro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, ddata[floor(lua_tonumber(L, -3)), floor(lua_tonumber(L, -2)), floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//д¼Ϣ

function PutScenceEventPro(L: Plua_state): integer; cdecl;
begin
  ddata[floor(lua_tonumber(L, -3)), floor(lua_tonumber(L, -2)), floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -4));
  result := 0;

end;

function JudgeScenceEvent(L: Plua_state): integer; cdecl;
var
  t: integer;
begin
  t := 0;
  if DData[CurScence, floor(lua_tonumber(L, -3)), 2 + floor(lua_tonumber(L, -2))] = floor(lua_tonumber(L, -1)) then t := 1;
  lua_pushnumber(L, t);
  result := 1;
end;

function PlayMusic(L: Plua_state): integer; cdecl;
begin
  instruct_66(floor(lua_tonumber(L, -1)));
  result := 0;
end;

function PlayWave(L: Plua_state): integer; cdecl;
begin
  instruct_67(floor(lua_tonumber(L, -1)));
  result := 0;
end;

function WalkFromTo(L: Plua_state): integer; cdecl;
var
  x1, x2, y1, y2: integer;
begin
  x1 := floor(lua_tonumber(L, -4));
  y1 := floor(lua_tonumber(L, -3));
  x2 := floor(lua_tonumber(L, -2));
  y2 := floor(lua_tonumber(L, -1));
  instruct_30(x1, x2, y1, y2);
  result := 0;

end;

function ScenceFromTo(L: Plua_state): integer; cdecl;
var
  x1, x2, y1, y2: integer;
begin
  x1 := floor(lua_tonumber(L, -4));
  y1 := floor(lua_tonumber(L, -3));
  x2 := floor(lua_tonumber(L, -2));
  y2 := floor(lua_tonumber(L, -1));
  instruct_25(x1, x2, y1, y2);
  result := 0;

end;

function PlayAnimation(L: Plua_state): integer; cdecl;
var
  t, i1, i2: integer;
begin
  t := floor(lua_tonumber(L, -3));
  i1 := floor(lua_tonumber(L, -2));
  i2 := floor(lua_tonumber(L, -1));
  instruct_27(t, i1, i2);
  result := 0;

end;

function GetNameAsString(L: Plua_state): integer; cdecl;
var
  str: string;
  typenum, num: integer;
  p1: pchar;
begin
  typenum := floor(lua_tonumber(L, -2));
  num := floor(lua_tonumber(L, -1));
  case typenum of
    0: p1 := @Rrole[num].Name;
    1: p1 := @Ritem[num].Name;
    2: p1 := @Rscence[num].Name;
    3: p1 := @Rmagic[num].Name;
  end;
  str := big5tounicode(p1);
  lua_pushstring(L, @str[1]);
  result := 1;

end;

function ChangeScence(L: Plua_state): integer; cdecl;
var
  x, y, n: integer;
begin
  n := lua_gettop(L);
  CurScence := floor(lua_tonumber(L, -n));
  if n = 1 then
  begin
    x := RScence[CurScence].EntranceX;
    y := RScence[CurScence].EntranceY;
  end
  else
  begin
    x := floor(lua_tonumber(L, -n + 1));
    y := floor(lua_tonumber(L, -n + 2));
  end;
  Cx := x + Cx - Sx;
  Cy := y + Cy - Sy;
  Sx := x;
  Sy := y;
  instruct_14;
  InitialScence;
  Drawscence;
  instruct_13;
  ShowScenceName(CurScence);
  CheckEvent3;
  result := 0;

end;

function ShowPicture(L: Plua_state): integer; cdecl;
var
  t, p, n, x, y: integer;
begin
  n := lua_gettop(L);
  x := floor(lua_tonumber(L, -2));
  y := floor(lua_tonumber(L, -1));
  if n = 4 then
  begin
    t := floor(lua_tonumber(L, -4));
    p := floor(lua_tonumber(L, -3));
    case t of
      0: DrawMPic(p, x, y);
      1: DrawSPic(p, x, y, 0, 0, screen.w, screen.h);
      2: DrawBPic(p, x, y, 0);
      3: DrawHeadPic(p, x, y);
      4: DrawEPic(p, x, y);
      //5:
    end;
  end;
  if n = 3 then
  begin
    display_img(lua_tostring(L, -3), x, y);
  end;
  result := 0;

end;

function GetItemList(L: Plua_state): integer; cdecl;
var
  i: integer;
begin
  i := floor(lua_tonumber(L, -1));
  lua_pushnumber(L, RItemList[i].Number);
  lua_pushnumber(L, RItemList[i].Amount);
  result := 2;
end;

function GetCurrentScence(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, CurScence);
  result := 1;

end;

function GetCurrentEvent(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, CurEvent);
  result := 1;

end;

//ȡս

function GetBattleNumber(L: Plua_state): integer; cdecl;
var
  n, i, rnum, t: integer;
begin
  n := lua_gettop(L);
  if n = 0 then
    lua_pushnumber(L, x50[28005]);
  if n = 1 then
  begin
    rnum := floor(lua_tonumber(L, -1));
    t := -1;
    for i := 0 to broleamount - 1 do
    begin
      if Brole[i].rnum = rnum then
      begin
        t := i;
        break;
      end;
    end;
    lua_pushnumber(L, t);
  end;
  result := 1;

end;

//ѡĿ

function SelectOneAim(L: Plua_state): integer; cdecl;
begin
  if floor(lua_tonumber(L, -1)) = 0 then
    selectaim(floor(lua_tonumber(L, -3)), floor(lua_tonumber(L, -2)));
  lua_pushnumber(L, bfield[2, Ax, Ay]);
  result := 1;
end;

//ȡս

function GetBattlePro(L: Plua_state): integer; cdecl;
begin
  lua_pushnumber(L, Brole[floor(lua_tonumber(L, -2))].data[floor(lua_tonumber(L, -1))]);
  result := 1;

end;

//дս

function PutBattlePro(L: Plua_state): integer; cdecl;
begin
  Brole[floor(lua_tonumber(L, -2))].data[floor(lua_tonumber(L, -1))] := floor(lua_tonumber(L, -3));
  result := 0;

end;

function PlayAction(L: Plua_state): integer; cdecl;
var
  bnum, mtype, enum: integer;
begin
  bnum := floor(lua_tonumber(L, -3));
  mtype := floor(lua_tonumber(L, -2));
  enum := floor(lua_tonumber(L, -1));
  playActionAmination(bnum, mtype);
  playMagicAmination(bnum, mtype);
  result := 0;

end;

//function GetRoundNumber(L: Plua_state): integer; cdecl;

function PlayHurtValue(L: Plua_state): integer; cdecl;
var
  mode: integer;
begin
  mode := floor(lua_tonumber(L, -1));
  showhurtvalue(mode);
  result := 0;

end;

function SetAminationLayer(L: Plua_state): integer; cdecl;
var
  x, y, w, h, t, i1, i2: integer;
begin
  x := floor(lua_tonumber(L, -5));
  y := floor(lua_tonumber(L, -4));
  w := floor(lua_tonumber(L, -3));
  h := floor(lua_tonumber(L, -2));
  t := floor(lua_tonumber(L, -1));

  for i1 := x to x + w - 1 do
    for i2 := y to y + h - 1 do
      bfield[4, i1, i2] := t;

  result := 0;

end;

function ClearRoleFromBattle(L: Plua_state): integer; cdecl;
var
  t: integer;
begin
  t := floor(lua_tonumber(L, -1));
  Brole[t].Dead := 1;
  result := 0;

end;

function AddRoleIntoBattle(L: Plua_state): integer; cdecl;
var
  rnum, team, x, y, bnum: integer;
begin
  bnum := broleamount;
  broleamount := broleamount + 1;
  team := floor(lua_tonumber(L, -4));
  rnum := floor(lua_tonumber(L, -3));
  x := floor(lua_tonumber(L, -2));
  y := floor(lua_tonumber(L, -1));

  Brole[bnum].rnum := rnum;
  Brole[bnum].Team := team;
  Brole[bnum].X := x;
  Brole[bnum].Y := y;
  Brole[bnum].Face := 1;
  Brole[bnum].Dead := 0;
  Brole[bnum].Step := 0;
  Brole[bnum].Acted := 1;
  Brole[bnum].ShowNumber := -1;
  Brole[bnum].ExpGot := 0;

  lua_pushnumber(L, bnum);
  result := 1;

end;

//ǿս

function ForceBattleResult(L: Plua_state): integer; cdecl;
begin
  Bstatus := floor(lua_tonumber(L, -1));
  result := 0;
end;

end.

