/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ExpanderDrawData
extends DrawData {
    public ExpanderDrawData() {
        this.state = new int[1];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData(0, this.getClassId());
            int n3 = 1;
            if ((this.style & 0x400) != 0) {
                n3 = 2;
            }
            SIZE sIZE = new SIZE();
            OS.GetThemePartSize(n2, gC.handle, 2, n3, null, 1, sIZE);
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rECT.left + sIZE.cx;
            rECT.top = rectangle.y;
            rECT.bottom = rECT.top + sIZE.cy;
            OS.DrawThemeBackground(n2, gC.handle, 2, n3, rECT, null);
            OS.CloseThemeData(n2);
        }
    }

    char[] getClassId() {
        return TREEVIEW;
    }

    int[] getPartId(int n2) {
        int n3 = 2;
        int n4 = 1;
        if ((this.style & 0x400) != 0) {
            n4 = 2;
        }
        return new int[]{n3, n4};
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        if (!rectangle.contains(point)) {
            return -1;
        }
        int n2 = OS.OpenThemeData(0, this.getClassId());
        SIZE sIZE = new SIZE();
        int[] nArray = this.getPartId(0);
        OS.GetThemePartSize(n2, 0, nArray[0], nArray[1], null, 1, sIZE);
        OS.CloseThemeData(n2);
        if (new Rectangle(rectangle.x, rectangle.y, sIZE.cx, sIZE.cy).contains(point)) {
            return 0;
        }
        return -1;
    }
}

