/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RowLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 3;
    public boolean wrap = true;
    public boolean pack = true;
    public boolean fill = false;
    public boolean justify = false;
    public int marginLeft = 3;
    public int marginTop = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    public RowLayout() {
    }

    public RowLayout(int n2) {
        this.type = n2;
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Point point = this.type == 256 ? this.layoutHorizontal(composite, false, n2 != -1 && this.wrap, n2, bl2) : this.layoutVertical(composite, false, n3 != -1 && this.wrap, n3, bl2);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    Point computeSize(Control control, boolean bl2) {
        int n2 = -1;
        int n3 = -1;
        RowData rowData = (RowData)control.getLayoutData();
        if (rowData != null) {
            n2 = rowData.width;
            n3 = rowData.height;
        }
        return control.computeSize(n2, n3, bl2);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        if (this.type == 256) {
            this.layoutHorizontal(composite, true, this.wrap, rectangle.width, bl2);
        } else {
            this.layoutVertical(composite, true, this.wrap, rectangle.height, bl2);
        }
    }

    Point layoutHorizontal(Composite composite, boolean bl2, boolean bl3, int n2, boolean bl4) {
        int n3;
        Object object;
        int n4;
        Control[] controlArray = composite.getChildren();
        int n5 = 0;
        int n6 = 0;
        while (n6 < controlArray.length) {
            Control control = controlArray[n6];
            RowData rowData = (RowData)control.getLayoutData();
            if (rowData == null || !rowData.exclude) {
                controlArray[n5++] = controlArray[n6];
            }
            ++n6;
        }
        if (n5 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (!this.pack) {
            n4 = 0;
            while (n4 < n5) {
                Control control = controlArray[n4];
                object = this.computeSize(control, bl4);
                n6 = Math.max(n6, ((Point)object).x);
                n7 = Math.max(n7, ((Point)object).y);
                ++n4;
            }
            n8 = n7;
        }
        n4 = 0;
        int n9 = 0;
        if (bl2) {
            object = composite.getClientArea();
            n4 = ((Rectangle)object).x;
            n9 = ((Rectangle)object).y;
        }
        object = null;
        boolean bl5 = false;
        Rectangle[] rectangleArray = null;
        if (bl2 && (this.justify || this.fill)) {
            rectangleArray = new Rectangle[n5];
            object = new int[n5];
        }
        int n10 = 0;
        int n11 = this.marginLeft + this.marginWidth;
        int n12 = this.marginTop + this.marginHeight;
        int n13 = 0;
        while (n13 < n5) {
            Control control = controlArray[n13];
            if (this.pack) {
                Point point = this.computeSize(control, bl4);
                n6 = point.x;
                n7 = point.y;
            }
            if (bl3 && n13 != 0 && n11 + n6 > n2) {
                bl5 = true;
                if (bl2 && (this.justify || this.fill)) {
                    object[n13 - 1] = n8;
                }
                n11 = this.marginLeft + this.marginWidth;
                n12 += this.spacing + n8;
                if (this.pack) {
                    n8 = 0;
                }
            }
            if (this.pack || this.fill) {
                n8 = Math.max(n8, n7);
            }
            if (bl2) {
                int n14 = n11 + n4;
                n3 = n12 + n9;
                if (this.justify || this.fill) {
                    rectangleArray[n13] = new Rectangle(n14, n3, n6, n7);
                } else {
                    control.setBounds(n14, n3, n6, n7);
                }
            }
            n10 = Math.max(n10, n11 += this.spacing + n6);
            ++n13;
        }
        n10 = Math.max(n4 + this.marginLeft + this.marginWidth, n10 - this.spacing);
        if (!bl5) {
            n10 += this.marginRight + this.marginWidth;
        }
        if (bl2 && (this.justify || this.fill)) {
            n13 = 0;
            int n15 = 0;
            if (!bl5) {
                n13 = Math.max(0, (n2 - n10) / (n5 + 1));
                n15 = Math.max(0, (n2 - n10) % (n5 + 1) / 2);
            } else if (this.fill || this.justify) {
                int n16 = 0;
                if (n5 > 0) {
                    object[n5 - 1] = n8;
                }
                n3 = 0;
                while (n3 < n5) {
                    if (object[n3] != false) {
                        int n17;
                        int n18 = n3 - n16 + 1;
                        if (this.justify) {
                            n17 = 0;
                            int n19 = n16;
                            while (n19 <= n3) {
                                n17 += rectangleArray[n19].width + this.spacing;
                                ++n19;
                            }
                            n13 = Math.max(0, (n2 - n17) / (n18 + 1));
                            n15 = Math.max(0, (n2 - n17) % (n18 + 1) / 2);
                        }
                        n17 = n16;
                        while (n17 <= n3) {
                            if (this.justify) {
                                rectangleArray[n17].x += n13 * (n17 - n16 + 1) + n15;
                            }
                            if (this.fill) {
                                rectangleArray[n17].height = (int)object[n3];
                            }
                            ++n17;
                        }
                        n16 = n3 + 1;
                    }
                    ++n3;
                }
            }
            int n20 = 0;
            while (n20 < n5) {
                if (!bl5) {
                    if (this.justify) {
                        rectangleArray[n20].x += n13 * (n20 + 1) + n15;
                    }
                    if (this.fill) {
                        rectangleArray[n20].height = n8;
                    }
                }
                controlArray[n20].setBounds(rectangleArray[n20]);
                ++n20;
            }
        }
        return new Point(n10, n12 + n8 + this.marginBottom + this.marginHeight);
    }

    Point layoutVertical(Composite composite, boolean bl2, boolean bl3, int n2, boolean bl4) {
        int n3;
        Object object;
        int n4;
        Control[] controlArray = composite.getChildren();
        int n5 = 0;
        int n6 = 0;
        while (n6 < controlArray.length) {
            Control control = controlArray[n6];
            RowData rowData = (RowData)control.getLayoutData();
            if (rowData == null || !rowData.exclude) {
                controlArray[n5++] = controlArray[n6];
            }
            ++n6;
        }
        if (n5 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (!this.pack) {
            n4 = 0;
            while (n4 < n5) {
                Control control = controlArray[n4];
                object = this.computeSize(control, bl4);
                n6 = Math.max(n6, ((Point)object).x);
                n7 = Math.max(n7, ((Point)object).y);
                ++n4;
            }
            n8 = n6;
        }
        n4 = 0;
        int n9 = 0;
        if (bl2) {
            object = composite.getClientArea();
            n4 = ((Rectangle)object).x;
            n9 = ((Rectangle)object).y;
        }
        object = null;
        boolean bl5 = false;
        Rectangle[] rectangleArray = null;
        if (bl2 && (this.justify || this.fill)) {
            rectangleArray = new Rectangle[n5];
            object = new int[n5];
        }
        int n10 = 0;
        int n11 = this.marginLeft + this.marginWidth;
        int n12 = this.marginTop + this.marginHeight;
        int n13 = 0;
        while (n13 < n5) {
            Control control = controlArray[n13];
            if (this.pack) {
                Point point = this.computeSize(control, bl4);
                n6 = point.x;
                n7 = point.y;
            }
            if (bl3 && n13 != 0 && n12 + n7 > n2) {
                bl5 = true;
                if (bl2 && (this.justify || this.fill)) {
                    object[n13 - 1] = n8;
                }
                n11 += this.spacing + n8;
                n12 = this.marginTop + this.marginHeight;
                if (this.pack) {
                    n8 = 0;
                }
            }
            if (this.pack || this.fill) {
                n8 = Math.max(n8, n6);
            }
            if (bl2) {
                int n14 = n11 + n4;
                n3 = n12 + n9;
                if (this.justify || this.fill) {
                    rectangleArray[n13] = new Rectangle(n14, n3, n6, n7);
                } else {
                    control.setBounds(n14, n3, n6, n7);
                }
            }
            n10 = Math.max(n10, n12 += this.spacing + n7);
            ++n13;
        }
        n10 = Math.max(n9 + this.marginTop + this.marginHeight, n10 - this.spacing);
        if (!bl5) {
            n10 += this.marginBottom + this.marginHeight;
        }
        if (bl2 && (this.justify || this.fill)) {
            n13 = 0;
            int n15 = 0;
            if (!bl5) {
                n13 = Math.max(0, (n2 - n10) / (n5 + 1));
                n15 = Math.max(0, (n2 - n10) % (n5 + 1) / 2);
            } else if (this.fill || this.justify) {
                int n16 = 0;
                if (n5 > 0) {
                    object[n5 - 1] = n8;
                }
                n3 = 0;
                while (n3 < n5) {
                    if (object[n3] != false) {
                        int n17;
                        int n18 = n3 - n16 + 1;
                        if (this.justify) {
                            n17 = 0;
                            int n19 = n16;
                            while (n19 <= n3) {
                                n17 += rectangleArray[n19].height + this.spacing;
                                ++n19;
                            }
                            n13 = Math.max(0, (n2 - n17) / (n18 + 1));
                            n15 = Math.max(0, (n2 - n17) % (n18 + 1) / 2);
                        }
                        n17 = n16;
                        while (n17 <= n3) {
                            if (this.justify) {
                                rectangleArray[n17].y += n13 * (n17 - n16 + 1) + n15;
                            }
                            if (this.fill) {
                                rectangleArray[n17].width = (int)object[n3];
                            }
                            ++n17;
                        }
                        n16 = n3 + 1;
                    }
                    ++n3;
                }
            }
            int n20 = 0;
            while (n20 < n5) {
                if (!bl5) {
                    if (this.justify) {
                        rectangleArray[n20].y += n13 * (n20 + 1) + n15;
                    }
                    if (this.fill) {
                        rectangleArray[n20].width = n8;
                    }
                }
                controlArray[n20].setBounds(rectangleArray[n20]);
                ++n20;
            }
        }
        return new Point(n11 + n8 + this.marginRight + this.marginWidth, n10);
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        string = String.valueOf(string) + "type=" + (this.type != 256 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = String.valueOf(string) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginTop != 0) {
            string = String.valueOf(string) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginRight != 0) {
            string = String.valueOf(string) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginBottom != 0) {
            string = String.valueOf(string) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string = String.valueOf(string) + "spacing=" + this.spacing + " ";
        }
        string = String.valueOf(string) + "wrap=" + this.wrap + " ";
        string = String.valueOf(string) + "pack=" + this.pack + " ";
        string = String.valueOf(string) + "fill=" + this.fill + " ";
        string = String.valueOf(string) + "justify=" + this.justify + " ";
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

