/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.CHOOSECOLOR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    Display display;
    int width;
    int height;
    RGB rgb;

    public ColorDialog(Shell shell) {
        this(shell, 32768);
    }

    public ColorDialog(Shell shell, int n2) {
        super(shell, n2);
        this.checkSubclass();
    }

    int CCHookProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 272: {
                RECT rECT = new RECT();
                OS.GetWindowRect(n2, rECT);
                this.width = rECT.right - rECT.left;
                this.height = rECT.bottom - rECT.top;
                if (this.title == null || this.title.length() == 0) break;
                TCHAR tCHAR = new TCHAR(0, this.title, true);
                OS.SetWindowText(n2, tCHAR);
                break;
            }
            case 2: {
                RECT rECT = new RECT();
                OS.GetWindowRect(n2, rECT);
                int n6 = rECT.right - rECT.left;
                int n7 = rECT.bottom - rECT.top;
                if (n6 >= this.width && n7 >= this.height && n6 > this.width) break;
            }
        }
        return 0;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int n2;
        int n3;
        int n4 = this.parent.handle;
        Callback callback = new Callback(this, "CCHookProc", 4);
        int n5 = callback.getAddress();
        if (n5 == 0) {
            SWT.error(3);
        }
        this.display = this.parent.display;
        if (this.display.lpCustColors == 0) {
            int n6 = OS.GetProcessHeap();
            this.display.lpCustColors = OS.HeapAlloc(n6, 8, 64);
        }
        CHOOSECOLOR cHOOSECOLOR = new CHOOSECOLOR();
        cHOOSECOLOR.lStructSize = CHOOSECOLOR.sizeof;
        cHOOSECOLOR.Flags = 272;
        cHOOSECOLOR.lpfnHook = n5;
        cHOOSECOLOR.hwndOwner = n4;
        cHOOSECOLOR.lpCustColors = this.display.lpCustColors;
        if (this.rgb != null) {
            cHOOSECOLOR.Flags |= 1;
            int n7 = this.rgb.red & 0xFF;
            n3 = this.rgb.green << 8 & 0xFF00;
            n2 = this.rgb.blue << 16 & 0xFF0000;
            cHOOSECOLOR.rgbResult = n7 | n3 | n2;
        }
        Shell shell = null;
        if ((this.style & 0x30000) != 0) {
            shell = this.display.getModalDialogShell();
            this.display.setModalDialogShell(this.parent);
        }
        n3 = OS.ChooseColor(cHOOSECOLOR);
        if ((this.style & 0x30000) != 0) {
            this.display.setModalDialogShell(shell);
        }
        if (n3 != 0) {
            n2 = cHOOSECOLOR.rgbResult & 0xFF;
            int n8 = cHOOSECOLOR.rgbResult >> 8 & 0xFF;
            int n9 = cHOOSECOLOR.rgbResult >> 16 & 0xFF;
            this.rgb = new RGB(n2, n8, n9);
        }
        callback.dispose();
        if (n3 == 0) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

