"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var _extends = function (child, parent) {
  child.prototype = Object.create(parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  child.__proto__ = parent;
};

var Container = require("./container");

// CSS at-rule like “this.keyframes name { }”.
//
// Can contain declarations (like this.font-face or this.page) ot another rules.
var AtRule = (function (Container) {
  var AtRule = function AtRule(defaults) {
    this.type = "atrule";
    Container.call(this, defaults);
  };

  _extends(AtRule, Container);

  _classProps(AtRule, null, {
    stringify: {
      writable: true,


      // Stringify at-rule
      value: function (builder, semicolon) {
        var name = "@" + this.name;
        var params = this.params ? this.stringifyRaw("params") : "";

        if (typeof (this.afterName) != "undefined") {
          name += this.afterName;
        } else if (params) {
          name += " ";
        }

        if (this.childs) {
          this.stringifyBlock(builder, name + params);
        } else {
          var before = this.style("beforeRule");
          if (before) builder(before);
          var end = (this.between || "") + (semicolon ? ";" : "");
          builder(name + params + end, this);
        }
      }
    },
    append: {
      writable: true,


      // Hack to mark, that at-rule contains childs
      value: function (child) {
        if (!this.childs) this.childs = [];
        return Container.prototype.append.call(this, child);
      }
    },
    prepend: {
      writable: true,


      // Hack to mark, that at-rule contains childs
      value: function (child) {
        if (!this.childs) this.childs = [];
        return Container.prototype.prepend.call(this, child);
      }
    },
    insertBefore: {
      writable: true,


      // Hack to mark, that at-rule contains childs
      value: function (exist, add) {
        if (!this.childs) this.childs = [];
        return Container.prototype.insertBefore.call(this, exist, add);
      }
    },
    insertAfter: {
      writable: true,


      // Hack to mark, that at-rule contains childs
      value: function (exist, add) {
        if (!this.childs) this.childs = [];
        return Container.prototype.insertAfter.call(this, exist, add);
      }
    }
  });

  return AtRule;
})(Container);

module.exports = AtRule;