"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var CssSyntaxError = require("./css-syntax-error");
var PreviousMap = require("./previous-map");
var Parser = require("./parser");

var path = require("path");

var sequence = 0;

var Input = (function () {
  var Input = function Input(css, opts) {
    if (opts === undefined) opts = {};
    this.css = css.toString();
    this.opts = opts;

    if (this.css[0] == "\ufeff" || this.css[0] == "\ufffe") {
      this.css = this.css.slice(1);
    }

    sequence += 1;
    this.id = "<input css " + sequence + ">";

    this.safe = !!this.opts.safe;

    if (this.opts.map == "inline") {
      this.opts.map = { inline: true };
      console.warn("Shortcut map: \"inline\" is deprecated " + "and will be remove in 3.1");
    }
    if (this.opts.from) {
      this.file = path.resolve(this.opts.from);
    }

    var map = new PreviousMap(this.css, this.opts, this.id);
    if (map.text) {
      this.map = map;
      var file = map.consumer().file;
      if (!this.file && file) this.file = this.mapResolve(file);
    }

    this.from = this.file ? this.file : this.id;
    if (this.map) this.map.file = this.from;
  };

  _classProps(Input, null, {
    error: {
      writable: true,


      // Throw syntax error from this input
      value: function (message, line, column) {
        throw new CssSyntaxError(this, message, line, column);
      }
    },
    origin: {
      writable: true,


      // Get origin position of code if source map was given
      value: function (line, column) {
        if (!this.map) return false;
        var consumer = this.map.consumer();

        var from = consumer.originalPositionFor({ line: line, column: column });
        if (!from.source) return false;

        var result = {
          file: this.mapResolve(from.source),
          line: from.line,
          column: from.column
        };

        var source = consumer.sourceContentFor(result.file);
        if (source) result.source = source;

        return result;
      }
    },
    mapResolve: {
      writable: true,


      // Return path relative from source map root
      value: function (file) {
        return path.resolve(this.map.consumer().sourceRoot || ".", file);
      }
    }
  });

  return Input;
})();

module.exports = Input;