"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var _extends = function (child, parent) {
  child.prototype = Object.create(parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  child.__proto__ = parent;
};

var Declaration = require("./declaration");
var Container = require("./container");
var Comment = require("./comment");
var AtRule = require("./at-rule");
var Result = require("./result");
var Rule = require("./rule");

// Root of CSS
var Root = (function (Container) {
  var Root = function Root(defaults) {
    this.type = "root";
    this.childs = [];
    Container.call(this, defaults);
  };

  _extends(Root, Container);

  _classProps(Root, null, {
    remove: {
      writable: true,


      // Fix space when we remove first child
      value: function (child) {
        child = this.index(child);

        if (child === 0 && this.childs.length > 1) {
          this.childs[1].before = this.childs[child].before;
        }

        return Container.prototype.remove.call(this, child);
      }
    },
    normalize: {
      writable: true,


      // Fix spaces on insert before first rule
      value: function (child, sample, type) {
        var childs = Container.prototype.normalize.call(this, child, sample, type);

        for (var i = 0; i < childs.length; i++) {
          if (type == "prepend") {
            if (this.childs.length > 1) {
              sample.before = this.childs[1].before;
            } else if (this.childs.length == 1) {
              sample.before = this.after;
            }
          } else {
            if (this.childs.length > 1) {
              if (sample) childs[i].before = sample.before;
            } else {
              childs[i].before = this.after;
            }
          }
        }

        return childs;
      }
    },
    stringify: {
      writable: true,


      // Stringify styles
      value: function (builder) {
        this.stringifyContent(builder);
        if (this.after) builder(this.after);
      }
    },
    toResult: {
      writable: true,


      // Generate processing result with optional source map
      value: function (opts) {
        if (opts === undefined) opts = {};
        return new Result(this, opts);
      }
    }
  });

  return Root;
})(Container);

module.exports = Root;