"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var _extends = function (child, parent) {
  child.prototype = Object.create(parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  child.__proto__ = parent;
};

var Container = require("./container");
var Declaration = require("./declaration");
var list = require("./list");

// CSS rule like “a { }”
var Rule = (function (Container) {
  var Rule = function Rule(defaults) {
    this.type = "rule";
    this.childs = [];
    Container.call(this, defaults);
  };

  _extends(Rule, Container);

  _classProps(Rule, null, {
    selectors: {
      // Shortcut to get selectors as array

      get: function () {
        return list.comma(this.selector);
      },
      set: function (values) {
        this.selector = values.join(", ");
      }
    },
    stringify: {
      writable: true,


      // Stringify rule
      value: function (builder) {
        this.stringifyBlock(builder, this.stringifyRaw("selector"));
      }
    }
  });

  return Rule;
})(Container);

module.exports = Rule;