(function(d, w) {
	var upgrade = {
		//接口类
		__interface__: {
			//读取媒资接口
			getMediaStore: function(data, success, fail, error) {
				KgSuperCall.GetUserInfo(function(info) {
					info = JSON.parse(info || '{}');
					var source = {},
						resource = [];
					for (var i in data) {
						resource.push({
							type: "audio",
							id: 0,
							hash: data[i].hash,
							album_id: data[i].album_id || "",
							name: data[i].filename || data[i].singername + " - " + data[i].songname + "." + data[i].extname
						});
					}
					KgSuperCall.postData(JSON.stringify({
						url: "http://media.store.kugou.com/v1/get_res_privilege",
						param: JSON.stringify({
							appid: 1001,
							clientver: KgSuperCall.GetVersion().toString(),
							userid: +info.kugouid || 0,
							token: info.token || "",
							vip: info.isVIP == 1 ? info.VIPtype : 0,
							behavior: "download",
							relate: 1,
							resource: resource
						})
					}), function(res) {
						if (res == "") {
							error && error();
						} else {
							res = JSON.parse(res);
							if (res && res.status == 1) {
								success && success(res);
							} else if (res && res.status == 0) {
								fail && fail(res);
							} else {
								error && error();
							}
						}
					});
				});
			},
			//请求包月套餐查询用户月套餐余额
			getVipInfo: function(success, fail, error) {
				KgSuperCall.GetUserInfo(function(info) {
					info = JSON.parse(info || '{}');
					KgSuperCall.postData(JSON.stringify({
						url: "http://media.store.kugou.com/v1/get_remain_quota",
						param: JSON.stringify({
							appid: 1001,
							clientver: KgSuperCall.GetVersion().toString(),
							userid: +info.kugouid || 0,
							token: info.token || "",
							vip: info.isVIP == 1 ? info.VIPtype : 0
						})
					}), function(res) {
						res = JSON.parse(res);
						if (res && res.status == 1) {
							success && success(res);
						} else if (res && res.status == 0) {
							fail && fail(res);
						} else {
							error && error();
						}
					});
				});
			},
			//获取磁盘路径
			getDirPath : function(data){
				if(this.curPath){
					return this.curPath;
				}
				var curPath = "";
				data = JSON.parse(data);
				for (var i in data.data) {
					if (data.data[i].active) {
						curPath = data.data[i].path;
						break;
					}
				}
				this.curPath = curPath;
			},
			//获取磁盘大小
			getHardDistSize: function(path, fn) {
				var par = {
					path: path,
					callback: "getHardDistSize" + Math.random().toString().substr(2, 9)
				};
				KgSuperCall.getHardDistSize(JSON.stringify(par));
				w[par.callback] = function(data) {
					fn && fn(JSON.parse(data));
				};
			},
			//批量读取媒资接口
			batchMediaStore: function(data, success, fail, error) {
				var me = upgrade;
				var len = data.length,
					base = 500,
					count = Math.ceil(len / base);
				var newData = [],
					interfaceData = [];
				for (var i = 0; i < count; i++) {
					newData.push(data.slice(base * i, base * (i + 1)));
				}
				var loadData = function(i, fn) {
					me.__interface__.getMediaStore(newData[i], function(res) {
						if (interfaceData.length == 0) {
							interfaceData = res;
						} else {
							interfaceData.data = interfaceData.data.concat(res.data);
						}
						i++;
						if (i < newData.length) {
							loadData.apply(loadData, [i, fn]);
						} else {
							fn & fn(1);
						}
					}, function() {
						fn & fn(0);
					}, function() {
						fn & fn(-1);
					});
				}
				loadData(0, function(flag) {
					if (flag == 1) {
						success(interfaceData);
					} else if (flag == 0) {
						fail();
					} else {
						error();
					}
				});
			}
		},
		//展示类
		__view__: {
			//显示模块
			showView: function(type, data, wrap) {
				var json = {};
				if (type == "load") {
					json = {
						status: 0
					};
					json["data"] = data || {};
				} else if (type == "info") {
					json = {
						status: 0
					};
					json["data"] = data || {};
				} else if (type == "error") {
					json = {
						status: 0
					};
					json["data"] = data || {};
				} else {
					json = data;
				}
				d.getElementById(wrap || "wrapper").innerHTML = template(type, {
					data: json
				}).toString();
				var $button = d.querySelector(".button");
				var $reload = d.querySelector("#reload");
				$button.onclick = function() {
					if (this.dataset.status == -1) {
						KgSuperCall.closeWindow();
					}
				};
				if($reload){
					$reload.onclick = function() {
						w.refreshTab();
					};
				}
			},
			//显示弹窗
			showPop : function(msg){
				var pop = d.getElementById("pop-wrapper");
				pop.innerHTML = template("pop", {
					msg: msg
				}).toString();
				var $close = d.querySelector(".pop-close");
				var $btn = d.querySelectorAll(".pop-btns a")[0];
				$btn.onclick = $close.onclick = function(e) {
					pop.innerHTML = "";
				};
			},
			//复选框操作
			checkBox: function(ele, fn, checked) {
				var me = upgrade;
				var checkedCallBack = function(ele, condition, fn) {
					if (condition) {
						ele.className = ele.className.replace(/checkboxed/ig, "");
						if (ele.dataset && ele.dataset.index) {
							ele.parentNode.className = ele.parentNode.className.replace(/current/ig, "");
						}
						fn && fn(0, ele.dataset && ele.dataset.index);
					} else {
						ele.className += " checkboxed";
						if (ele.dataset && ele.dataset.index) {
							ele.parentNode.className += " current";
						}
						fn && fn(1, ele.dataset && ele.dataset.index);
					}
				};
				if (typeof checked == "undefined") {
					ele.onclick = function(e) {
						checkedCallBack(ele, ele.className.indexOf("checkboxed") != -1, fn);
						me.__util__.stopEvent(e);
					};
				} else {
					checkedCallBack(ele, !checked, fn);
				}
			},
			//显示虚表
			showVirtualTable: function(datas, fn) {
				var me = upgrade;
				me.__view__.showView("main", {
					status: 1,
					ckball: 1,
					data: []
				});
				var $virtual = d.getElementById("virtual"),
					$virtualContainer = d.getElementById("virtual-container"),
					$virtualBox = d.getElementById("virtual-box"),
					$virtualList = d.getElementById("virtual-list");
				var table = new virtualTable(datas, {
						height: 32,
						client: 7,
						callback: function(s, e) {
							var newData = [];
							for (var i in datas) {
								if (i >= s && i < e) {
									newData.push(datas[i]);
								}
							}
							me.__view__.showView("list", newData, "virtual-list");
							fn && fn();
						}
					}),
					h = table.set();
				$virtual.style.height = h.clientHeight + "px";
				$virtualBox.style.height = h.clientHeight + "px";
				$virtualContainer.style.height = h.totalHeight + "px";
				$virtual.onscroll = function() {
					var s = table.scroll.apply(table, [this.scrollTop]);
					$virtualBox.style.marginTop = s.clientTop + "px";
					$virtualList.style.marginTop = s.groupTop + "px";
				}
				table.init();
			},

			//展示后业务逻辑入口
			main: function(datas){
				var me = upgrade;
				//复选框操作
				var $checkbox = d.querySelectorAll("#virtual-list .checkbox"),
					$list = d.querySelectorAll("#virtual-list li"),
					$checkboxAll = d.querySelector("#checkboxAll"),
					$checkboxLocal = d.querySelector("#checkboxLocal"),
					$total = d.querySelectorAll(".total b");
				//显示容量和总数
				var showTotal = function() {
						var data = me.__data__.getSelectedData(datas);
						var size = 0;
						for (var i in data) {
							size += data[i].sizeAfter;
						}
						$total[0].innerHTML = data.length;
						$total[1].innerHTML = me.__data__.formatSize(size);
						$total[1].className = size == 0 ? "" : "strong";
					},
					//歌曲复选
					ckbCallback = function(ischeck, fn, fn2) {
						for (var i = 0; i < $checkbox.length; i++) {
							(function(i) {
								me.__view__.checkBox($checkbox[i], function(ischeck, index) {
									me.__data__.setDataStatus(datas, index, ischeck);
									showTotal();
									if ((fn2 && !fn2())) {
										return false;
									}
									var status = me.__data__.getDataStatus(datas);
									if (status.all) {
										ckbAllCallback(1, function() {
											return false;
										});
									} else if (status.local) {
										ckbLocalCallback(1, function() {
											return false;
										});
									} else {
										ckbAllCallback(0, function() {
											return false;
										});
										ckbLocalCallback(0, function() {
											return false;
										});
									}
								}, ischeck && fn ? fn((me.__data__.getData(datas, $checkbox[i].dataset.index))) : ischeck);
							})(i);
						}
					},
					//全选
					ckbAllCallback = function(ischeck, fn) {
						me.__view__.checkBox($checkboxAll, function(ischeck) {
							if (!fn || (fn && fn())) {
								if (ischeck) {
									ckbLocalCallback(0, function() {
										return false;
									});
								}
								me.__data__.setDataStatus(datas, "all", ischeck);
								ckbCallback(ischeck,null,function(){return false;});
							}
						}, ischeck);
					},
					//本地选
					ckbLocalCallback = function(ischeck, fn) {
						me.__view__.checkBox($checkboxLocal, function(ischeck) {
							if (!fn || (fn && fn())) {
								if (ischeck) {
									ckbAllCallback(0, function() {
										return false;
									});
								}
								me.__data__.setDataStatus(datas, "local", ischeck);
								ckbCallback(ischeck, function(data) {
									return data.islocal == "1";
								},function(){return false;});
							}
						}, ischeck);
					};
				//初始化复选框
				ckbCallback();
				ckbAllCallback();
				ckbLocalCallback();
				//读取数据后设置复选框状态
				var status = me.__data__.getDataStatus(datas);
				if (status.all) {
					ckbAllCallback(1);
				} else if (status.local) {
					ckbLocalCallback(1);
				} else {
					ckbCallback(1, function(data) {
						return data.checked;
					});
				}
				//复选文本触发
				for (var i = 0; i < $list.length; i++) {
					(function(i){
						$list[i].onclick = function(){
							this.getElementsByClassName("checkbox")[0].click();
						};
					})(i);
				}
				$checkboxAll.nextElementSibling.onclick = function(){
					$checkboxAll.click();
				}
				$checkboxLocal.nextElementSibling.onclick = function(){
					$checkboxLocal.click();
				}
			}
		},
		//工具类
		__util__: {
			//按二进制低位取到高位
			getBinary: function(val, num) {
				var str = parseInt(val).toString("2");
				if (str.length >= num) {
					return +(str.substr(str.length - num, 1));
				}
				return 0;
			},
			//扩展对象
			extend: function(target, options) {
				for (var i in options) {
					target[i] = options[i];
				}
				return target;
			},
			//阻止冒泡
			stopEvent: function(event) {
				event = window.event || event;
				if (event.stopPropagation) {
					event.stopPropagation();
				} else {
					event.cancelBubble = true;
				}
			}
		},
		//数据封装类
		__data__: {
			//数据过滤
			filter: function(file, data, loginInfo, ups) {
				var me = upgrade;
				var status = data.status,
					hightest = false,
					needlogin = me.__util__.getBinary(data.fail_process, 1),
					needvip = me.__util__.getBinary(data.fail_process, 2),
					needbuy = me.__util__.getBinary(data.fail_process, 3),
					needpkg = me.__util__.getBinary(data.fail_process, 4);
				//已是最高音质且是本地歌曲
				if (file.bitrate > 340 && file.islocal == "1") {
					return false;
				}
				//多音质没有最高音质
				if (data.relate_goods) {
					for (var i in data.relate_goods) {
						if (data.relate_goods[i].level == 5) {
							hightest = true;
						}
					}
					if (!hightest) {
						return false;
					}
				}
				//下载禁止
				if ([4, 5, 6, 7, 12, 13, 14, 15].indexOf(data.privilege) != -1) {
					return false;
				}
				//非免费无购买 登陆后免费使用 没有登录
				if (!status && needlogin && !loginInfo.logined) {
					return false;
				}
				//非免费无购买 可升级VIP免费用 不是vip
				if (!status && needvip && !loginInfo.isVIP) {
					return false;
				}
				//非免费无购买 需要购买
				if (!status && needbuy) {
					return false;
				}
				//非免费无购买 可升级音乐包免费使用 没登录 或者登录了也没开通音乐包
				if (!status && needpkg && (!loginInfo.logined || (loginInfo.logined && ups <= 3))) {
					return false;
				}
				return true;
			},
			//转换格式
			formatSize: function(size) {
				return size == 0 ? 0 : parseFloat(size / 1024 / 1024).toFixed(2) + "M";
			},
			//是否存在needpkg数据
			needpkg: function(datas) {
				var me = upgrade,
					flag = false;
				for (var i in datas) {
					var data = datas[i],
						status = data.status,
						needpkg = me.__util__.getBinary(data.fail_process, 3);
					if (!status && needpkg && [4, 5, 6, 7, 12, 13, 14, 15].indexOf(data.privilege) != -1) {
						flag = true;
						break;
					}
					if (data.relate_goods) {
						flag = arguments.callee.apply(this, data.relate_goods);
					}
				}
				return flag;
			},
			//数据组装
			build: function(file, data, index) {
				var me = upgrade;
				var newData = {};
				me.__util__.extend(newData, data);
				var apeSize = flacSize = 0;
				var apeData = [],flacData = [];
				for (var j in newData.relate_goods) {
					var tmp = newData.relate_goods[j];
					if (tmp.level == 5) {
						if (tmp.info.extname == "ape") {
							apeSize = tmp.info.filesize;
							apeData.push(tmp);
						}
						if (tmp.info.extname == "flac") {
							flacSize = tmp.info.filesize;
							flacData.push(tmp);
						}
					}
				}
				newData.name = file.filename.replace(/.mp3|.mp4|.flac|.ape|.m4a/ig, "");
				newData.sizeAfter = apeSize || flacSize;
				newData.sizeBefore = file.size;
				newData.qualityData = apeData.length != 0 ? apeData[0] : (flacData.length != 0 ? flacData[0] : null);
				newData.checked = 1;
				newData.index = index;
				newData.islocal = file.islocal;
				newData.userdataid = file.userdataid;
				return newData;
			},
			//封装下载歌曲
			buildSong: function(datas) {
				var songs = [];
				for (var i in datas) {
					var data = datas[i].qualityData;
					if (data) {
						var json = {
							"filename": ((datas[i].name.replace(/.mp3|.mp4|.flac|.ape|.m4a/ig, "")) + "." + data.info.extname).replace(/【[^(【|】)]+】/gi, "").replace(/\\/g, "\\\\").replace(/"/g, '\\"'),
							"hash": data.hash,
							"size": data.info.filesize.toString(),
							"duration": data.info.duration.toString(),
							"bitrate": data.info.bitrate.toString(),
							"isfilehead": data.info.flag.toString() || "0",
							"mvhash": "",
							"mvtrack": "0",
							"mvstate": "0",
							"ismvfilehead": "0",
							"isvip": "0",
							"privilege": data.privilege.toString(),
							"album_id": data.album_id.toString() || "0",
							"islocal": datas[i].islocal.toString(),
							"userdataid": datas[i].userdataid.toString()
						};
						songs.push(json);
					}
				}
				return songs;
			},
			//获取数据索引
			getData :function(datas,index){
				var j = 0;
				for(var i in datas){
					if(datas[i].index == index){
						j = i;
						break;
					}
				}
				return datas[j];
			},
			//判断歌曲选择状态
			getDataStatus: function(datas) {
				var localLen = localCount = allCount = 0;
				for (var i in datas) {
					if (datas[i].islocal == "1") {
						localLen++;
					}
				}
				for (var i in datas) {
					if (datas[i].checked) {
						if (datas[i].islocal == "1") {
							localCount++;
						}
						allCount++;
					}
				}
				return {
					all: allCount != 0 && datas.length == allCount,
					local: localLen != 0 && localLen == localCount && allCount == localCount
				};
			},
			//设置歌曲选择状态
			setDataStatus: function(datas, index, checked) {
				var me = upgrade;
				if (!isNaN(+index)) {
					(me.__data__.getData(datas, index)).checked = checked;
				} else if (index == "all") {
					for (var i in datas) {
						datas[i].checked = checked;
					}
				} else if (index == "local") {
					for (var i in datas) {
						if (checked) {
							datas[i].checked = datas[i].islocal == "1" ? checked : !checked;
						} else {
							datas[i].checked = checked;
						}
					}
				} 
			},
			//获取选中歌曲
			getSelectedData : function(datas){
				var newData = [];
				for(var i in datas){
					if(datas[i].checked){
						newData.push(datas[i]);
					}
				}
				return newData;
			}
		},
		//升级歌曲
		updateSong: function(files, datas, fn) {
			var me = upgrade;
			var songs = me.__data__.buildSong(datas);
			var path = me.__interface__.getDirPath();
			var totalSize = 0;
			var source = files.SourceData;
			var json = {
				"Source": source.Source || "",
				"SourceFile": source.SourceFile || "",
				"SourcePath": source.SourcePath || "",
				"ClassName": source.ClassName || "",
				"Files":(songs),
				"Count": songs.length,
				"DownloadPath": path
			};
			for (var i in songs) {
				totalSize += (+songs[i].size);
			}
			if (datas.length == 0) {
				fn && fn(-1);
				return false;
			}
			me.__interface__.getHardDistSize(path, function(d) {
				if (d.size > 0 && d.size < (totalSize / 1024).toFixed(2)) {
					fn && fn(0);
				} else {
					var exp = /^Source$|^SourceFile$|^SourcePath$|^DownloadPath$|^ClassName$|^Files$|^Count$/gi;
					for (var i in source) {
						exp.lastIndex = 0;
						if (exp.test(i)) {
							continue;
						}
						json[i] = source[i];
					}
					external.SuperCall(816, JSON.stringify(json));
					fn && fn(1);
				}
			});
		},
		//初始化入口
		init: function(datas) {
			var me = upgrade;
			var file = datas.SourceData.Files;
			me.__view__.showView("load");
			if(file.length == 0){
				me.__view__.showView("info");
				return false;
			}
			KgSuperCall.GetUserInfo(function(info) {
				info = JSON.parse(info || '{}');
				me.__interface__.batchMediaStore(file, function(res) {
					//条件过滤
					var deal = function(ups) {
						var newData = [];
						point: for (var i in res.data) {
							if (!me.__data__.filter(file[i], res.data[i], info, ups)) {
								continue;
							}
							for (var j in res.data[i].relate_goods) {
								if (!me.__data__.filter(file[i], res.data[i].relate_goods[j], info, ups)) {
									continue point;
								}
							}
							newData.push(me.__data__.build(file[i], res.data[i], i));
						}
						//过滤数据后无数据
						if(newData.length == 0){
							me.__view__.showView("info");
							return false;
						}
						//生成虚表
						me.__view__.showVirtualTable(newData,function(){
							//每                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            