/* 
 * Copyright 2015 kugou.com
 * Creator: Green
 * $Author: linweijian $
 * $Date: 2015-01-24 $
 */
/**
 * 下载逻辑
 * @return {[type]} [description]
 */
function downModule() {
	var dm = arguments.callee;
	/**
	 * 存储临时变量
	 * @type {Object}
	 */
	var globalTemp = {
		//接口数据(包括插入的专辑数据)(切换音质操作会重新写入)
		interface_data: [],
		//歌曲勾选索引
		songlist_check_index: [],
		//vip勾选索引
		vip_check_index: [-1],
		//专辑是否已加入
		album: [],
		//选择的音质
		choise_level: undefined,
		//因重渲染需记录滚动高度
		scroll_height: 0,
		//是否为mv
		goods_ismv : false, 
		//媒体商店数据，和interface_data不同的是，保留原始数据
		mediaFiles : {},
		//源数据（过滤后的）
		sourceFiles : {},
		//定义过滤的条件(是vip、没权限)
		dataFilter: function(data) {
			return (data['isvip'] || data['copyright']);
		},
		formMV : false
	};
	/**
	 * 对外的存储临时变量
	 * @type {Array}
	 */
	dm.sourceTempFile = [];
	dm.abtest = "b";
	dm.hasLogOpen = false;//是否包月/升级包后统计
	/**
	 * 单选框操作
	 * 全选、反选、单选、组选
	 * @param  {[type]} ele [description]
	 * @param  {[type]} options [description]
	 * @return {[type]}     [description]
	 */
	function checkBoxInit(ele, options) {
		var that = arguments.callee;
		if (arguments.length === 0) {
			//清除对象
			that.clear = function() {
				checkBoxInit.array = undefined;
			};
			return that;
		}
		var ckbName = "charge_ckb_checked",
			ckbAllName = "charge_ckb_all",
			disabledName = "charge_ckb_disabled",
			groupName = "charge_ckb_group";
		//操作单选框
		checkedCallBack = function(ele, condition) {
				if (condition) {
					ele.className = ele.className.replace(/charge_ckb_checked/ig, "");
					ele.checked = false;
				} else {
					ele.className += " " + ckbName;
					ele.checked = true;
				}
			},
			//获取选中的值
			getvalue = function(data) {
				var array = [],
					ele;
				for (var i in data) {
					var temp = data[i];
					if (temp.className.indexOf(ckbAllName) != -1) {
						ele = temp;
						continue;
					}
					if (temp.className.indexOf(ckbName) != -1) {
						array.push(i);
					}
				}
				return [array,ele];
			},
			checkCallback = function(ele, _condition,onlyread) {
				var condition = typeof _condition != 'undefined' ? _condition : (ele.className.indexOf(ckbName) != -1),
					datas = checkBoxInit.array[ele.group];
				if (ele.className.indexOf(ckbAllName) != -1) {
					checkedCallBack(ele, condition);
					//全选/反选
					for (var i in datas) {
						checkedCallBack(datas[i], condition);
					}
					if(!onlyread){
						ele.callback(!condition);
					}
				} else {
					var ckbGroup = ele.className.match(/charge_ckb_group_(\d+)/);
					checkedCallBack(ele, condition);
					//组选
					for (var j in datas) {
						var temp = datas[j];
						if (ckbGroup !== null && temp.className.indexOf(ckbGroup[0]) != -1) {
							checkedCallBack(temp, condition);
						}
					}
					//全选
					var array = getvalue(datas);
					if (array[1]) {
						checkedCallBack(array[1], array[0].length != datas.length - 1);
					}
					if(!onlyread){
						ele.callback(array[0]);
					}
				}
			}
		if (options.checked === undefined) {
			ele.group = options.group || 0;
			ele.callback = options.callback || function() {};
			ele.disabled = options.disabled;
			if (ele.disabled) {
				ele.className += " " + disabledName;
			}
			if (typeof checkBoxInit.array == 'undefined') {
				checkBoxInit.array = [];
			}
			if (typeof checkBoxInit.array[ele.group] == 'undefined') {
				checkBoxInit.array[ele.group] = [];
			}
			ele.onclick = (function(e) {
				if (ele.disabled !== true) {
					checkCallback(ele,undefined,false);
				}
				Kg.stopEvent(e);
			});
			if (ele.disabled !== true) {
				checkedCallBack(ele, true);
				checkBoxInit.array[ele.group].push(ele);
			}
			return;
		}
		if (options.checked == "auto") {
			checkCallback(ele, undefined, false);
			return;
		}
		if (ele.disabled !== true) {
			checkCallback(ele, !options.checked,options.onlyread);
		}
	}
	/**
	 * 复选框操作
	 * @param  {[type]}   ele      [description]
	 * @param  {Function} options [description]
	 * @return {[type]}            [description]
	 */
	function radioBoxInit(ele, options) {
		var that = arguments.callee;
		if (arguments.length === 0) {
			//清除对象
			that.clear = function() {
				radioBoxInit.array = undefined;
			};
			return that;
		}
		var ckbName = "charge_radio_checked";
		ele.className = ele.className.replace(/charge_radio_checked/ig, "");
		ele.checked = options.checked;
		if (options.callback) {
			ele.callback = options.callback || function() {};
			ele.onclick = function() {
				if (ele.className.indexOf(ckbName) == -1) {
					for (var i in radioBoxInit.array) {
						var temp = radioBoxInit.array[i];
						temp.checked = false;
						temp.className = temp.className.replace(/charge_radio_checked/ig, "");
					}
					ele.className += " " + ckbName;
					ele.checked = true;
				}
				ele.callback();
			}
			if (typeof radioBoxInit.array == 'undefined') {
				radioBoxInit.array = [];
			}
			radioBoxInit.array.push(ele);
		}
		if (ele.checked) {
			ele.onclick();
		}
	}
	/**
	 * 错误提示
	 * @param  {[type]} msg [description]
	 * @return {[type]}     [description]
	 */
	function error(userInfo,msg) {
		chargeUtil.bindView("error", {
			msg: msg
		}, document.body);
		windowSize("error",userInfo);
		Kg.$("#error_btn")[0].onclick = function() {
			this.blur();
			KgSuperCall.closeWindow();
		};
	}
	/**
	 * APM统计
	 * @param  {[type]} delay [description]
	 * @return {[type]}       [description]
	 */
	function apmStat(delay, state, err) {
		if (apmStat.flag) {
			return;
		}
		apmStat.flag = true;
		var datetime = (new Date()).getTime() - startTime;
		if (delay) {
			delayTime = (new Date()).getTime() - delayTime;
		}
		var fs = "";
		typeof state == 'undefined' && (state = 1);
		if (state === 0) {
			fs = "&fs=" + err;
		}
		KgSuperCall.addAPM(70032, state, "_sample_rate_=100&datetime=" + datetime + "&loadtime=" + apmLoadTime + "&delay=" + delayTime + fs);
	}
	/**
	 * 列表操作计算
	 * @param  {[type]} datas  [description]
	 * @param  {[type]} indexs [description]
	 * @param  {[type]} point  [description]
	 * @return {[type]}        [description]
	 */
	function compute(datas, indexs, point,single) {
		var count = 0, //歌曲数量
			capacity = 0, //容量
			price = 0, //总价
			pay_arr = [], //需要付费歌曲
			pay_point = 0, //消耗的歌曲数
			pay = 0, //实付款
			intact = false,//无损，用于统计
			login = false,
			ckb_point = 0, //勾选的长度
			songs = [], //选中商品到客户端操作的信息
			vipGoods = [], //选中商品信息，vip
			moneyGoodsInfo =[],
			moneyGoods = []; //选中商品信息，酷币
		var onlymoney = false;//只要有一首酷币支付全部酷币支付
		//不选
		if (indexs === false) {
			count = capacity = price = ckb_point = 0;
			pay_arr = moneyGoods = vipGoods = moneyGoodsInfo = [];
		} else {
			var temp = [];
			for (var i in datas) {
				//新的需求后。批量无版权、专属vip直接过滤
				if(globalTemp.dataFilter(datas[i]) && !single){
					continue;
				}
				temp.push(datas[i]);
			}
			//全选/单个选
			var d = (indexs === true ? temp : indexs),
				albuminfo = {};
			count = ckb_point = d.length;
			for (var i in d) {
				var data = (indexs === true ? d[i] : temp[d[i]]);
				capacity += parseFloat(data.info.filesize_value);
				if (data.price_value !== 0 && (data.group_id == undefined || data.group_id != albuminfo[data.group_id])) {
					price = chargeUtil.floatAdd(price, data.price_value);
					pay_arr.push(data);
					moneyGoods.push({
						type: data.type,
						id: data.id,
						hash: data.type == 'album' ? '' : data.hash,
						name: data.type == 'album' ? '' : data.name,
						album_id: data.album_id || ""
					});
					moneyGoodsInfo.push(data);
				}
				if(data.onlymoney == 1){
					onlymoney = true;
				}
				if ((data.price_value === 0 && !data.group_id)) {
					ckb_point--;
				}
				if (data.group_id) {
					albuminfo[data.group_id] = data.group_id;
				}
				if(data.islogin){
					login = true;
				}
				if (!intact) {
					if (data.level == 5) {
						intact = true;
					}
				}
				var songstr = [
					(data.name.replace(/.mp3|.mp4|.flac|.ape|.m4a/ig, "")) + "." + data.info.extname,
					data.hash,
					data.info.filesize,
					data.info.duration,
					data.info.bitrate,
					"undefined",
					0,
					data.info.flag || 0,
					0, 0, 0,
					data.privilege,
					data.album_id || "0"
				].join("|");
				songs.push(songstr);
			}
		}
		capacity = parseFloat(capacity).toFixed(2);
		//没有点数
		if (point === 0) {
			pay = price;
		} else {
			moneyGoods = [];
			moneyGoodsInfo = [];
			//按照顺序扣除点数对应的价格
			var pkg_price = 0,
				deduction = 0; //抵扣
			for (var i in pay_arr) {
				var data = pay_arr[i];
				pkg_price += data.pkg_price;
				if (pkg_price <= point && !onlymoney) {
					deduction = chargeUtil.floatAdd(deduction, data.price_value);
					pay_point += data.pkg_price;
					vipGoods.push({
						type: data.type,
						id: data.id,
						hash: data.type == 'album' ? '' : data.hash,
						name: data.type == 'album' ? '' : data.name,
						album_id: data.album_id || ""
					});
				} else {
					pkg_price -= data.pkg_price;
					moneyGoods.push({
						type: data.type,
						id: data.id,
						hash: data.type == 'album' ? '' : data.hash,
						name: data.type == 'album' ? '' : data.name,
						album_id: data.album_id || ""
					});
					moneyGoodsInfo.push(data);
				}
			}
			pay = chargeUtil.floatSub(price, deduction);
		}
		return {
			count: count,
			capacity: capacity,
			price: price,
			pay_point: pay_point,
			ckb_point: ckb_point,
			goods_point: ckb_point - pay_point,
			pay: pay,
			intact: intact,
			login: login,
			moneyGoods: moneyGoods,
			moneyGoodsInfo: moneyGoodsInfo,
			vipGoods: vipGoods,
			songs: songs
		};
	}
	/**
	 * 数据转换：排序 、转换、专辑
	 * @param  {[type]} datas [description]
	 * @return {[type]}      [description]
	 */
	function buildDatas(datas, single) {
		var new_datas = [];
		chargeUtil.copyObject(datas, new_datas);
		var albuminfo = {};
		for (var i in new_datas) {
			var data = new_datas[i];
			var ismoneybuy = chargeUtil.getBinary(data.status, 3), //是否酷币消费
				isvipbuy = chargeUtil.getBinary(data.status, 2), //是否vip消费
				isfree = chargeUtil.getBinary(data.status, 1), //是否免费
				pkg = chargeUtil.getBinary(data.fail_process, 4), //可升级音乐包免费使用（不需要扣点）
				isbuy = chargeUtil.getBinary(data.fail_process, 3), //需要单独购买（VIP包月或酷币）
				isvip = chargeUtil.getBinary(data.fail_process, 2), //可升级VIP免费用
				islogin = chargeUtil.getBinary(data.fail_process, 1), //登录后可以免费使用
				iscanmoney = chargeUtil.getBinary(data.pay_type, 2), //可酷币支付
				iscanvip = chargeUtil.getBinary(data.pay_type, 1); //可VIP包月套餐支付
			//数据设置属性数据
			//歌曲名去除后缀
			data.name = data.name.replace(/.mp3|.mp4|.flac|.ape|.m4a/ig, "");
			//价格是分单位要除以100
			data.price = (data.price / 100).toFixed(2);
			data.price.toString().split(".")[1] == "00" && (data.price = parseInt(data.price));
			//是否可扣点
			data.onlymoney = 0;
			// 专属vip
			data.isvip = isvip;
			//有无版权
			data.copyright = (chargeUtil.getIndex([4, 5, 6, 7, 12, 13, 14, 15], data.privilege) != -1);
			//登录后可以免费使用
			data.islogin = islogin;
			//单曲歌曲名显示后缀
			if (single) {
				data.name += "." + data.info.extname;
			}
			if (isfree == 1) {
				data.price_text = '免费';
				data.isfree = 1;
				data.price_value = 0;
			} else if (data.isvip == 1 || data.copyright) {
				data.price_text = '--';
				data.price_value = 0;
			} else if (ismoneybuy == 1 || isvipbuy == 1) {
				data.price_text = '已购买';
				data.isfree = 1;
				data.price_value = 0;
			} else if (ismoneybuy === 0 && isvipbuy === 0 && isfree === 0) {
				if(isbuy == 1){
					if(iscanmoney == 1 && iscanvip == 0){
						data.onlymoney = 1;//只能酷币购买
					}
				}
				data.price_text = data.price_value = +data.price;
			}
			//批量的专辑
			if (data.type == 'album' && !single) {
				if (data.id != albuminfo[data.id]) {
					albuminfo[data.id] = data.id;
					data.group_id = data.id;
				} else {
					data.price_text = '--';
					data.group_id = data.id;
				}
			}
			//音质
			if (data.level == 2) {
				data.level_name = "标准音质";
			} else if (data.level == 4) {
				data.level_name = "高品音质";
			} else if (data.level == 5) {
				data.level_name = "无损音质";
			}
			data.info.filesize_value = parseFloat(data.info.filesize / 1024 / 1024).toFixed(2);
		}
		return new_datas;
	}
	/**
	 * 业务层相关 包括数据请求转换、界面渲染操作
	 * @param  {[type]} behavior [行为]
	 * @param  {[type]} options  [description]
	 * @return {[type]}          [description]
	 */
	function render(behavior, options) {
		var that = arguments.callee;
		//全局存储
		chargeUtil.copyObject(options.interfaceData, globalTemp.interface_data);
		//临时存储
		var temp_song_free = false,
			temp_song_free_init = true,
			temp_song_change = true;
		//勾选免费框状态
		//购买信息
		var goods_num = 0, //消耗vip点数
			goods_money = 0, //消耗酷币
			goods_datas_vip = [], //勾选的歌曲-vip（用于接口）
			goods_datas_money = [], //勾选的歌曲-酷币（用于接口）
			goods_datas_money_info = [],//给单曲支付带过去的信息
			goods_song = [], //勾选的歌曲（用于下载）
			goods_capacity = 0; //勾选的歌曲容量
		var need_login = false, //是否需要登录
			has_intact = false; //是否有无损歌曲
		var goods_isfree = true;//歌曲是否免费
		that.doStatus = {
			remain: undefined, //vip余额
			from: "package", //购买音乐包
			upgrade: 3
		};
		var goods_noFilter = false;//直接不阻拦下载
		var hasLogStat = false;//是否统计
		var hasLogStat2 = false;//是否统计
		var hasLogAB = false;//是否AB统计
		var banner = null;
		var loadBanner = false;
		//业务逻辑控制{输出/操作}
		that.control = function(type, options) {
			var pay = Kg.$("#pay_wrap")[0],
				area = Kg.$(".charge_btn_area"),
				btn1 = area.find("a").eq(0),
				btn2 = area.find("a").eq(1),
				need = Kg.$(".charge_need"),
				info = Kg.$(".charge_info"),
				mv = Kg.$(".charge_mv"),
				ext = '<i class="l"></i><i class="r"></i>',
				album_temp;
			area.removeClass("pc_temp_ab_area");
			btn1.removeClass("pc_temp_ab_link").removeClass("pc_temp_auto_btn04");	
			btn2.removeClass("pc_temp_auto_btn04");
			if (that.doStatus.upgrade == -1 && options.isvip != 1) {
				btn2.addClass("none");
				btn1.removeClass("none").removeClass("pc_temp_auto_btn03").addClass("pc_temp_disable_btn03").html("<span>支付并下载</span>");
				btn1.addClass("pc_temp_auto_btn04");
				return;
			}
			btn2.removeClass("none");
			btn1.removeClass("none").removeClass("pc_temp_auto_btn03").removeClass("pc_temp_disable_btn03").html("<span>支付并下载</span>");
			goods_noFilter = false;
			hasLogAB = false;
			//按钮状态
			function btnStatus(t) {
				var txt, val;
				switch (t) {
					case 1:
						txt = "<span>包月购买(<font>8</font>元/300首)</span>";
						val = "package";
						break;
					case 2:
						txt = "<span>购买专辑</span>";
						val = "album";
						break;
					case 3:
						txt = "<span>升级音乐包</span>";
						val = "updePackage";
						break;
					case 5:
						txt = "<span>开通vip会员</span>";
						val = "openVip";
						break;
					case 6:
						txt = "<span>开通VIP</span>";
						val = "openMV";
						break;
				}
				btn2.removeClass("none").removeClass("pc_temp_auto_btn03").attr("data-type", val).html(txt);
				if(t == 1){
					btn2.addClass("pc_temp_auto_btn03")
				}
			}
			//MV状态改变
			function changeStatus(func) {
				if (type == 'action' || options.mode == 'downloadlist' || options.free) {
					if (options.ismv) {
						info.hide();
						mv.show();
						btn1.removeClass("none").html("<span>立即下载</span>");
						btn2.addClass("none");
						btn1.addClass("pc_temp_auto_btn04");
						// if (options.userInfo.isVIP == 1) {
						// 	btn1.removeClass("none").html("立即下载" + ext);
						// 	btn2.addClass("none");
						// } else {
						// 	btn1.addClass("none");
						// 	btnStatus(6);
						// }
					} else {
						info.show();
						mv.hide();
						func && func();
					}
				}
			}
			//输出
			function output(t) {
				var str = '<ul class="charge_info"><li>';
				switch (t) {
					case 1:

						str += '<i class="charge_icon_question" style="margin-right:10px;"></i><span class="charge_novip">应版权方要求，'+ (options.mode == 'download' ? '此' : '部分') +'歌曲需付费下载，开通音乐包即可畅享百万高品质音乐</span><span class="charge_right hide"><a href="javascript:;" onclick="return false;">查询余额</a></span>';
						break;
					case 2:
						str += '<span class="charge_novip">本月音乐包剩余<b class="strong1 size18">' + that.doStatus.remain + '</b>首，本次下载消耗<b class="strong2 pay_point size18">0</b>首</span><span class="charge_need">，还需支付<b class="strong2 size18 pay">0</b>元</span><span class="charge_right hide charge_need"><a href="javascript:;" onclick="return false;">查询余额</a></span>';
						break;
					case 3:
						str += '<span class="charge_novip">本月音乐包剩余<b class="strong1 size18">0</b>首，本月额度已用完</span><span class="charge_right hide"><a href="javascript:;" onclick="return false;">查询余额</a></span>';
						break;
					case 5:
						str += '<span class="charge_novip">本月音乐包剩余<b class="strong1 size18">' + that.doStatus.remain + '</b>首，本次下载消耗<b class="strong2 pay_point size18">0</b>首'+ (options.album != false ? "（包含付费专辑多首歌曲）":"") +"</span>";
						break;
					case 7:
						str += '<i class="charge_icon_question" style="margin-right:10px;"></i><span class="charge_novip">应版权方要求，' + (options.mode == 'download' ? '本' : options.album == 'all' ? '所有' : '部分') + '歌曲需购买专辑后下载'+(options.mode == 'download' ? '<i class="charge_line"></i>专辑价格：<b class="strong2 size18 pay">0</b>元' : '')+'</font></span>';
						str += (options.mode == 'download' ? '<span class="charge_right hide"><a href="javascript:;" onclick="return false;">查询余额</a></span>':'');
						break;
					case 8:
						str +='<i class="charge_icon_question" style="margin-right:10px;"></i><span class="charge_novip">应版权方要求，'+ (options.mode == 'download' ? '本' : '') +'歌曲需开通vip才提供下载</span>';
						break;
					case 9:
						str +='<i class="charge_icon_question" style="margin-right:10px;"></i><span class="charge_novip">应版权方要求，部分歌曲需付费后下载</span>';
						break;
					case 10:
						str += '<i class="charge_icon_question" style="margin-right:10px;"></i><span class="charge_novip">应版权方要求，' + (options.mode == 'download' ? '本' : '部分') + '歌曲需支付后下载</span><span class="charge_right hide"><a href="javascript:;" onclick="return false;">查询余额</a></span>';
						break;
					case 11:
						str +='<i class="charge_icon_question" style="margin-right:10px;"></i><span class="charge_novip">唱片公司要求该歌曲不提供下载服务</span>';
						break;
					default: break;
				}
				str += '</li></ul><div class="charge_mv"><span>惊喜!海量MV免费下载</span></div>';
				return str; 
			}
			//需开通VIP
			if(options.isvip == 1){
				changeStatus(function() {
					pay.innerHTML = output(8);
					btn1.addClass("none");
					btn2.addClass("pc_temp_auto_btn04");
					btnStatus(5);
				});
				return false;
			}
			//用于单曲有mv且歌曲本身无版权
			if(options.nocopyright){
				pay.innerHTML = output(11);
				changeStatus(function() {
					btn1.html("<span>立即下载</span>").removeClass("none").addClass("pc_temp_disable_btn03");
					btn2.addClass("none");
					btn1.addClass("pc_temp_auto_btn04");
				});
				return false;
			}
			//特殊情况(如果全是disabled无版权，专属vip)
			if(options.disable){
				pay.innerHTML = output(9);
				changeStatus(function() {
					btn1.html("<span>立即下载</span>").removeClass("none").addClass("pc_temp_disable_btn03");
					btn2.addClass("none");
					btn1.addClass("pc_temp_auto_btn04");
				});
				return false;
			}
			//专辑(废弃)
			if (options.album && options.album != 'some' && false) {
				if (type == 'output') {
					if (options.album == true || options.album == 'all' || options.album == 'free') {
						pay.innerHTML = output(7);
					}
				}
				changeStatus(function() {
					if (options.album == true || (options.album == 'all' && options.userInfo.logined == 0)) {
						btnStatus(2);
						btn1.addClass("none");
					} else if (options.album == 'all' || options.album == 'free') {
						btn1.html("<span>立即下载</span>").removeClass("none");
						btn2.addClass("none");
						if (options.album == 'all') {
							btn1.addClass("pc_temp_disable_btn03");
						}
					}
				});
				return false;
			}
			//免费
			if (options.free) {
				changeStatus(function() {
					//按钮
					btn1.removeClass("none");
					need.length > 0 && (need.css("visibility", "hidden"));
					btn1.html("<span>立即下载</span>");
					btn2.addClass("none");
					btn1.addClass("pc_temp_auto_btn04");
				});
				return false;
			}
			//新增情况，非音乐包 直接全选不阻拦下载
			if (that.doStatus.upgrade == 3 && options.mode == 'downloadlist' && KgSuperCall.GetVersion() >= 80400) {//先撤离，加个很大版本不执行
				goods_noFilter = true;
				if (type == 'output') {
					pay.innerHTML = output(1);
				}
				changeStatus(function() {
					btn1.html("<span>立即下载</span>").removeClass("none");
					btn2.addClass("none");
					btn1.addClass("pc_temp_auto_btn04");
				});
				return false;
			}
			//只允许酷币(歌曲可选择切换)
			if(options.onlymoney){
				if (type == 'output' || that.control.setTips != 0) {
					pay.innerHTML = output(10);
				}
				//设置可为调整tips内容
				that.control.setTips = 0;
				changeStatus(function() {
					btn1.removeClass("none");
					btn2.addClass("none");
					if (options.album && globalTemp.formMV && options.mode == 'download') {
						btn1.html('<span>购买专辑(<font class="pay bold"></font>元 / 张)</span>');
					}else{
						btn1.html((options.mode == 'download' ? "<span>立即购买" : "<span>立即购买") + '(<font class="pay bold"></font>元/<font class="pay_count"></font>首)</span>');
					}
					btn1.addClass("pc_temp_auto_btn03");
					btn1.addClass("pc_temp_auto_btn04");
				});
				return false;
			}
			//需要开通音乐包(没登陆/非VIP)
			if(that.doStatus.upgrade == 3){
				if (type == 'output' || that.control.setTips == 0) {
					pay.innerHTML = output(1);
				}
				//设置可为调整tips内容
				that.control.setTips = 1;
				changeStatus(function() {
					btn1.removeClass("none");
					btnStatus(1);
					btn1.html((options.mode == 'download' ? "<span>单首购买" : "<span>按首购买") + '(<font class="pay bold"></font>元/<font class="pay_count"></font>首)</span>');
					btn1.addClass("pc_temp_auto_btn03");
					// if(dm.abtest == "b"){
						// area.addClass("pc_temp_ab_area");
						btn1.addClass("pc_temp_ab_link");
						btn2.addClass("pc_temp_auto_btn04");
						btn1.addClass("none");
						dm.abtest == "a" && (btn2.html("<span>音乐包购买(<font>8元</font>/月)</span>"));
						dm.abtest == "b" && (btn2.html("<span>音乐包购买</span>"));
					// }
				});
				hasLogAB = true;
				if(!hasLogStat){
					hasLogStat = true;
					chargeUtil.logStat(1,"收费弹窗","收费弹窗",null,null,"音乐包下载弹窗展示量");
				}
				if (!hasLogStat2 && globalTemp.sourceFiles.Files.length == 1) {
					hasLogStat2 = true;
					var sourceFilename = globalTemp.sourceFiles.Files[0].filename || (globalTemp.sourceFiles.Files[0].singername + " - " + globalTemp.sourceFiles.Files[0].songname);
					chargeUtil.logStat(1, "收费弹窗", "单曲统计", sourceFilename, null, "下载弹窗展示量");
				}
				return false;
			}
			//不需要升级(开通了音乐包/VIP 且有剩余点数)
			if (options.enough == 1) {
				if (type == 'output' || that.control.setTips == 0) {
					pay.innerHTML = output(5);
				}
				//设置可为调整tips内容
				that.control.setTips = 2;
				changeStatus(function() {
					need.length > 0 && (need.css("visibility", "hidden"));
					btn1.removeClass("none").html("<span>立即下载(消耗<font class=\"pay_point\"></font>首)</span>");
					btn1.addClass("pc_temp_auto_btn03");
					btn2.addClass("none");
					btn1.addClass("pc_temp_auto_btn04");
				});
				if(dm.hasLogOpen){
					dm.hasLogOpen = false;
					chargeUtil.logStat(1, "PC内嵌页", "下载窗口", null, (dm.abtest == "a" ? "弱化按首购买A类用户" : "弱化按首购买B类用户"), "包月购买成功购买量");
				}
				return false;
			}
			//使用酷币
			if (that.doStatus.upgrade == 5) {
				if (type == 'output' || that.control.setTips == 0) {
					pay.innerHTML = that.doStatus.remain > 0 ? output(2) : output(3);
				}
				//设置可为调整tips内容
				that.control.setTips = 3;
				changeStatus(function() {
					need.length > 0 && (need.css("visibility", "visible"));
					btn1.removeClass("none");
					btn2.addClass("none");
					btn1.html((options.mode == 'download' ? "<span>单首购买" : "<span>按首购买") + '(<font class="pay bold"></font>元/<font class="pay_count"></font>首)</span>');
					btn1.addClass("pc_temp_auto_btn03");
					btn1.addClass("pc_temp_auto_btn04");
				});
				if (!hasLogStat2 && globalTemp.sourceFiles.Files.length == 1) {
					hasLogStat2 = true;
					var sourceFilename = globalTemp.sourceFiles.Files[0].filename || (globalTemp.sourceFiles.Files[0].singername + " - " + globalTemp.sourceFiles.Files[0].songname);
					chargeUtil.logStat(1, "收费弹窗", "单曲统计", sourceFilename, null, "下载弹窗展示量");
				}
				return false;
			}
			//需要升级音乐包
			if (that.doStatus.upgrade == 4) {
				if (type == 'output' || that.control.setTips == 0) {
					pay.innerHTML = that.doStatus.remain > 0 ? output(2) : output(3);
				}
				//设置可为调整tips内容
				that.control.setTips = 4;
				changeStatus(function() {
					need.length > 0 && (need.css("visibility", "visible"));
					btn1.removeClass("none");
					btnStatus(3);
					btn1.html((options.mode == 'download' ? "<span>单首购买" : "<span>按首购买") + '(<font class="pay bold"></font>元/<font class="pay_count"></font>首)</span>');
					btn1.addClass("pc_temp_auto_btn03");
					// if(dm.abtest == "b"){
						// area.addClass("pc_temp_ab_area");
						btn1.addClass("pc_temp_ab_link");	
						btn2.addClass("pc_temp_auto_btn04");
						btn1.addClass("none");

					// }
				});
				hasLogAB = true;
				if (!hasLogStat2 && globalTemp.sourceFiles.Files.length == 1) {
					hasLogStat2 = true;
					var sourceFilename = globalTemp.sourceFiles.Files[0].filename || (globalTemp.sourceFiles.Files[0].singername + " - " + globalTemp.sourceFiles.Files[0].songname);
					chargeUtil.logStat(1, "收费弹窗", "单曲统计", sourceFilename, null, "下载弹窗展示量");
				}
				return false;
			}
		};
		//价格计算及其渲染
		that.computeRender = function(datas, index, remain,single,func) {
			var o = compute(datas, index,remain,single);
			goods_num = +o.pay_point;
			goods_money = o.pay == 0 ? 0 : +(o.pay * 100).toFixed(2);
			goods_money.toString().split(".")[1] == "00" && (goods_money = parseInt(goods_money));
			goods_datas_vip = o.vipGoods;
			goods_datas_money = o.moneyGoods;
			goods_datas_money_info = o.moneyGoodsInfo;
			goods_capacity = o.capacity;
			goods_song = o.songs;
			need_login = o.login;
			has_intact = o.intact;
			func && func();
			var info = Kg.$(".charge_info"),
				pay = Kg.$(".pay"),
				charge_tips = Kg.$(".charge_tips"),
				pay_count = charge_tips.find(".pay_count"),
				goods_count = Kg.$(".charge_btn_area .pay_count"),
				pay_point = Kg.$(".pay_point"),
				hide = info.find(".hide"),
				total = Kg.$(".charge_total"),
				type = Kg.$(".charge_type"),
				money = Kg.$(".charge_money");
			if (total.length > 0) {
				total.find("font").html(o.count);
			}
			if (type.length > 0) {
				type.find("font").html(o.capacity);
			}
			if (money.length > 0) {
				money.find("font").html(o.price);
			}
			if (pay.length > 0) {
				pay.html(o.pay);
			}
			if (goods_count.length > 0 && o.goods_point > 1) {
				goods_count.html(o.goods_point);
			}
			if(charge_tips.length > 0){
				if (o.ckb_point == 0) {
					charge_tips.css("display", "none");
				} else {
					charge_tips.css("display", "inline-block");
				}
				if (pay_count.length > 0) {
					pay_count.html(o.ckb_point);
				}
			}
			if (pay_point.length > 0) {
				pay_point.html(o.pay_point);
			}
		};
		//切换音质
		that.changeQuality = function(datas, level, index) {
			var array = [],
				temp_level = level,
				build = function(data, j) {
					var temp = {};
					//如果是专辑数据要做特殊处理
					if (data.type == 'album') {
						data.level = data.relate_goods[0].level;
						for (var i in data.relate_goods) {
							data.relate_goods[i].type = 'album';
							data.relate_goods[i].id = data.id;
						}
					}
					chargeUtil.copyObject(data.relate_goods[j], temp);
					temp.relate_goods = [];
					chargeUtil.copyObject(data.relate_goods, temp.relate_goods);
					return temp;
				},
				setStatus = function(data){
					goods_isfree = true;
					for (var i in data) {
						if (!data[i].isfree) {
							goods_isfree = false;
							break;
						}
					}
					if (typeof that.doStatus.remain == "undefined") {
						that.doStatus.upgrade = (options.userInfo.logined == 1 && goods_isfree != 1) ? -1 : 3;
					}
				}
			if (datas.length > 1) {
				point: for (var i in datas) {
					if (typeof index != 'undefined') {
						if (index == i) {
							level = temp_level;
						} else {
							level = undefined;
						}
					}
					for (var j in datas[i].relate_goods) {
						if (datas[i].relate_goods[j].level == (level || datas[i].level)) {
							array.push(build(datas[i], j));
							continue point;
						}
					}
					//找不到了就最后一个
					array.push(build(datas[i], datas[i].relate_goods.length - 1));
				}
				array = buildDatas(array);
				setStatus(array);
				that.downloadRender(array);
				that.downloadlistAction.rebuild = false;
				that.downloadlistAction(array);
			} else {
				var find = false;
				for (var j in datas[0].relate_goods) {
					if (datas[0].relate_goods[j].level == (level || datas[0].level)) {
						datas[0] = build(datas[0], j);
						find = true;
						break;
					}
				}
				if (!find) {
					//找不到了就最后一个
					datas[0] = build(datas[0], datas[0].relate_goods.length - 1);
				}
				chargeUtil.copyObject(datas, array);
				array = buildDatas(array, true);
				setStatus(array);
				array[0].relate_goods = buildDatas(array[0].relate_goods, true);
				that.downloadRender(array);
				if (that.doStatus.upgrade == 3 && !goods_isfree && globalTemp.formMV == false) {
					that.downloadChargeAction(array);
				} else {
					that.downloadAction(array, (globalTemp.choise_level || array[0].level));
				}
			}
			globalTemp.interface_data = array;
			var vipCount = 0;
			//可升级VIP免费用
			if (options.userInfo.isVIP != 1) {
				for (var j in array) {
					if(array[j].isvip == 1){
						vipCount++;
					}
				}
			}
			if (goods_isfree || !options.userInfo.logined) {
				!that.changeQuality.init && apmStat(true);
				that.changeQuality.init = true;
				return false;
			}
			//登录情况下不是免费不是vip专属
			if (goods_isfree == false && options.userInfo.logined && (vipCount != array.length)) {
				function render(init) {
					if (array.length == 1) {
						if (that.doStatus.upgrade == 3 && !goods_isfree && globalTemp.formMV == false) {
							init && apmStat(true);
							that.downloadRender(array);
							that.downloadChargeAction(array);
						} else {
							init && apmStat(true);
							that.downloadAction(array, (globalTemp.choise_level || array[0].level));
							that.downloadResize(array);
						}
					} else {
						init && apmStat(true);
						that.downloadlistAction(array);
					}
				}
				if (typeof that.doStatus.remain == "undefined") {
					chargeInterface.getVipInfo(function(res2) {
						that.doStatus.remain = res2.data.remain;
						that.doStatus.upgrade = res2.data.upgrade;
						render(true);
					});
				}else{
					render();
				}
			}
			return array;
		};
		//批量下载操作
		that.downloadlistAction = function(datas) {
			//单选框操作
			var ckb = Kg.$(".charge_songlist .charge_ckb"), //勾选框
				ckball = Kg.$(".charge_song .charge_ckb_all")[0], //全选框
				ckbfree = Kg.$(".charge_song .charge_ckb_free"), //免费勾选框
				ckbenabled = [], //enabled的勾选框
				list = Kg.$(".charge_songlist li"); //列表
			var filterDatas = [];
			var freeTotal = 0;
			//不可用条数
			var tepm_disabled = (function() {
				var disable = {},
					count = 0;
				for (var i = 0; i < datas.length; i++) {
					if (globalTemp.dataFilter(datas[i])) {
						disable[i] = 1;
						count++;
					}else{
						filterDatas.push(datas[i]);
					}
				}
				disable["count"] = count;
				return disable;
			})();
			//没有disabled的单选框
			for (var i = 0; i < ckb.length; i++) {
				if (!ckb[i].className.match(/charge_ckb_disabled/)) {
					ckbenabled.push(ckb[i]);
				}
			}
			//包含全选框
			ckb.push(ckball);
			//如果有临时数据则绑定对应单选框
			function createCkb() {
				checkBoxInit(ckball, {checked: false,onlyread: true});
				if(temp_song_free && ckbfree.length >0){
					checkBoxInit(ckbfree[0], {checked: true});
					return;
				}
				if (globalTemp.songlist_check_index.length > 0) {
					temp_song_change = false;
					for (var i in globalTemp.songlist_check_index) {
						checkBoxInit(ckbenabled[globalTemp.songlist_check_index[i]], {
							checked: true,
							onlyread: i == globalTemp.songlist_check_index.length - 1 ? false : true
						});
					}
					temp_song_change = true;
				} else if (globalTemp.songlist_check_index === false) {
					temp_song_change = false;
					checkBoxInit(ckball, {checked: false});
					temp_song_change = true;
				} else if (globalTemp.songlist_check_index === true) {
					temp_song_change = false;
					checkBoxInit(ckball, {checked: true});
					temp_song_change = true;
				} else {
					checkBoxInit(ckball, {checked: true});
				}
			}
			//重新绑定套餐信息的操作
			function chargeInfoAction() {
				var info = Kg.$(".charge_info"),
					charge_right = Kg.$(".charge_info .charge_right");
				if (charge_right.length > 0) {
					charge_right[0].onclick = function() {
						var t = this;
						if (options.userInfo.logined == 0) {
							KgSuperCall.CallSoftUserLogin();
							return;
						}
						t.innerHTML = '<i class="charge_icon_loading"></i>正在查询中';
						Dn.queryBalance(function(d) {
							if (d.status == 1) {
								var m = d.data;
								m.toString().split(".")[1] == "00" && (m = parseInt(m));
								t.innerHTML = '余额：<b style="padding-left:0;margin-left:-5px;">' + m + '</b>酷币';
							} else {
								t.innerHTML = d.data;
							}
						});
					};
				}
			}
			//control参数
			var control_temp = {
				userInfo: options.userInfo,
				free: goods_isfree,
				mode: "downloadlist",
				//专辑状态
				album: (function() {
					var a = 0,b = 0;
					for (var i in datas) {
						if (datas[i].type == 'album') {a++;} else if (datas[i].price_value == 0) {b++;}
					}
					if (a == datas.length) {return 'all';} else if (a != 0) {if (b == datas.length - a) {return 'free';}return 'some';} else {return false;}
				})(),
				//特殊情况
				disable : (function(){
					var d = true;
					for (var i in datas) {
						if (!globalTemp.dataFilter(datas[i])) {
							                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  