///////////////////////////////////////////////////
//
// SPREADrock Description Resource
// (c) 2009 Jack's Secret Stash
// All rights reserved.
//
///////////////////////////////////////////////////

CONTAINER OSpreadRock
{
	NAME OSpreadRock;
	INCLUDE Obase;

	GROUP SPREADROCK_GENERAL
	{
		DEFAULT 1;
		
		LONG	SPREADROCK_PRIMITIVE						{ CYCLE {
																		SPREADROCK_PRIMITIVE_SPHERE;
																		SPREADROCK_PRIMITIVE_SHAPE1;
																		SPREADROCK_PRIMITIVE_SHAPE2;
																		SPREADROCK_PRIMITIVE_CUSTOMSHAPE;
															}	}
															
		LINK	SPREADROCK_PRIMITIVE_CUSTOMSHAPE_LINK		{ ACCEPT { 5100; } }
		
		SEPARATOR											{ LINE; }

		VECTOR	SPREADROCK_SIZE								{ UNIT METER; MIN 0.1; }
		VECTOR	SPREADROCK_SIZE_CUSTOMSHAPE					{ UNIT PERCENT; MIN 0.001; }
		
		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 2;
			
			GROUP
			{
				LONG	SPREADROCK_ORIENT							{ CYCLE {
																				SPREADROCK_ORIENT_X;
																				SPREADROCK_ORIENT_Y;
																				SPREADROCK_ORIENT_Z;
																	}	}
			}
			GROUP
			{
				BOOL	SPREADROCK_DROPAXIS							{  }
			}
		}
		
		
		SEPARATOR											{ LINE; }
		
		LONG	SPREADROCK_SUB								{ MIN 5; }
		LONG	SPREADROCK_PRIMITIVE_SUB					{ MIN 1; }
		
		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 2;
			
			GROUP
			{
				BOOL	SPREADROCK_PRESUBDIV						{  }
				BOOL	SPREADROCK_POSTSUBDIV						{  }
			}
			
			GROUP
			{
				LONG	SPREADROCK_PRESUBDIV_VAL					{ MIN 1; }
				LONG	SPREADROCK_POSTSUBDIV_VAL					{ MIN 1; }
			}
		}
	}
	
	GROUP SPREADROCK_NOISE
	{
		
		BOOL	SPREADROCK_USE_NORMALS						{  }
		BOOL	SPREADROCK_NOISE_STATIC						{  }
		
		SEPARATOR											{ LINE; }

		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 2;
			
			GROUP
			{
				REAL	SPREADROCK_NOISE_STRENGTH					{ MIN 0.0; }
			}
			
			GROUP
			{
				REAL	SPREADROCK_NOISE_OFFSET						{  }
			}
		}
	
		SEPARATOR											{  }
		
		LONG	SPREADROCK_NOISE_TYPE						{ CYCLE {
																SPREADROCK_NOISE_TYPE_TURBULENCE;
																SPREADROCK_NOISE_TYPE_WAVY;
																SPREADROCK_NOISE_TYPE_NOISE;
															}	}
		VECTOR	SPREADROCK_NOISE_SCALE						{ STEP 0.01; }
		REAL	SPREADROCK_NOISE_OCT						{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SPREADROCK_NOISE_SHIFT						{ STEP 0.01; }
		BOOL	SPREADROCK_NOISE_ABS						{  }
		
		GROUP	SPREADROCK_NOISE_2
		{
			BOOL	SPREADROCK_NOISE_2_ENABLE					{  }
			
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					REAL	SPREADROCK_NOISE_2_STRENGTH					{ MIN 0.0; }
				}
				
				GROUP
				{
					REAL	SPREADROCK_NOISE_2_OFFSET					{  }
				}
			}
		
			SEPARATOR											{  }
			
			LONG	SPREADROCK_NOISE_2_TYPE						{ CYCLE {
																			SPREADROCK_NOISE_TYPE_TURBULENCE;
																			SPREADROCK_NOISE_TYPE_WAVY;
																			SPREADROCK_NOISE_TYPE_NOISE;
																}	}
			VECTOR	SPREADROCK_NOISE_2_SCALE					{ STEP 0.01; }
			REAL	SPREADROCK_NOISE_2_OCT						{ MIN 0.1; STEP 0.1; MAX 20.0; }
			VECTOR	SPREADROCK_NOISE_2_SHIFT					{ STEP 0.01; }
			BOOL	SPREADROCK_NOISE_2_ABS						{  }
		}
	}
	
	GROUP	SPREADROCK_PRESETS
	{
		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 2;
			
			GROUP
			{
				BUTTON		SPREADROCK_MSG_PRESET_LOAD			{  }
			}
			GROUP
			{
				BUTTON		SPREADROCK_MSG_PRESET_SAVE			{  }
			}
		}
	}
}
