///////////////////////////////////////////////////
//
// SurfaceSPREAD Object Description Resource
// (c) 2009 Jack's Secret Stash
// (c) 2014 Laubwerk GmbH
// All rights reserved.
//
///////////////////////////////////////////////////

CONTAINER OSurfaceSpread
{
	NAME OSurfaceSpread;
	INCLUDE Obase;

	HIDE ID_BASEOBJECT_GROUP1;

	GROUP SURFACESPREAD_GENERAL
	{
		DEFAULT 1;

		// using ids instead of indentifiers for objects that 
		// might not be available in all versions of Cinema 4D
		// 1017305 = Ohair
		LINK SURFACESPREAD_GENERAL_SURFACE_LINK { ACCEPT { 1028308; 1023798; 1023726; 1022799; Opolygon; Ofractal; Orelief; Osds; Oplane; Osphere; Oplatonic; Otorus; Odisc; Opyramid; Ocapsule; Osinglepoly; 1017305; } }

		SEPARATOR { LINE; }

		LONG SURFACESPREAD_CLONEMODE
		{
			CYCLE
			{
				//SURFACESPREAD_CLONEMODE_VERTEX;
				SURFACESPREAD_CLONEMODE_POLYGON;
				SURFACESPREAD_CLONEMODE_POLYGONCENTER;
			}
		}
		
		SEPARATOR { }
		
		GROUP SURFACESPREAD_GENERAL_CLONECOUNT_GROUP
		{
			DEFAULT 1;
			
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG SURFACESPREAD_GENERAL_CLONECOUNT { MIN 1; }
				}
				
				GROUP
				{
					REAL SURFACESPREAD_GENERAL_CLONECOUNT_EDITORWEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; }
				}
			}
			
			SEPARATOR { }
			
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_GENERAL_SEED						{ MIN 1; }
				}
				
				GROUP
				{
					LONG	SURFACESPREAD_GENERAL_CLONEORDER_SEED			{ MIN 1; }
				}
			}
			
			SEPARATOR												{ LINE; }
			
			REAL	SURFACESPREAD_GENERAL_WEIGHTEDCLONESELECTION_VAL	{ UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			
//			SEPARATOR												{  }
			
//			LONG	SURFACESPREAD_CLONEMODE_POLYGON_MODE	{
//																CYCLE
//																{
//																	SURFACESPREAD_CLONEMODE_POLYGON_MODE_STD;
//																	SURFACESPREAD_CLONEMODE_POLYGON_MODE_PLANT;
//																}
//															}

//			LONG	SURFACESPREAD_CLONEMODE_POLYGON_MODE_PLANT_START	 { MIN 0; }
		}
		
		SEPARATOR { LINE; }
		
		LINK SURFACESPREAD_GENERAL_PARENTLINK { ACCEPT { Obase; } }
		
		SEPARATOR { LINE; }

		BOOL SURFACESPREAD_GENERAL_INSTANCES_ENABLE			{  }
		LONG SURFACESPREAD_GENERAL_INSTANCES_TYPE			{ CYCLE {
																			SURFACESPREAD_GENERAL_INSTANCES_TYPE_INSTANCE;
																			SURFACESPREAD_GENERAL_INSTANCES_TYPE_RENDERINSTANCE;
																		}  }
																		
		SEPARATOR { LINE; }
		
		LONG SURFACESPREAD_GENERAL_INSTANCES_DISPLAY
		{
			CYCLE
			{
				SURFACESPREAD_GENERAL_INSTANCES_DISPLAY_NORMAL;
				SURFACESPREAD_GENERAL_INSTANCES_DISPLAY_BOX;
				SURFACESPREAD_GENERAL_INSTANCES_DISPLAY_WIREBOX;
			}
		}

		SEPARATOR { LINE; }
		
		LONG SURFACESPREAD_GENERAL_CACHING
		{
			CYCLE
			{
				SURFACESPREAD_GENERAL_CACHING_OFF;
				SURFACESPREAD_GENERAL_CACHING_ALWAYS;
				SURFACESPREAD_GENERAL_CACHING_AUTO;
			}
		}

		SEPARATOR { LINE; }
		
		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 2;
			
			GROUP
			{
				REAL	SURFACESPREAD_GENERAL_TIMEOFFSET				{ MIN 0.0; STEP 0.1; }
			}
			
			GROUP
			{
				LONG	SURFACESPREAD_GENERAL_TIMEOFFSET_SEED			{ MIN 0; }
			}
		}
		
		SEPARATOR	SURFACESPREAD_SEP_GENERALINFORMATION		{  }
		
		STATICTEXT	SURFACESPREAD_TXT_OBJCOUNT					{ ANIM OFF; }
		STATICTEXT	SURFACESPREAD_TXT_POLYCOUNT					{ ANIM OFF; HIDDEN; }
	}


	GROUP SURFACESPREAD_DISTRIBUTION
	{								
		GROUP SURFACESPREAD_FILTERS
		{
			DEFAULT 1;
			
			GROUP SURFACESPREAD_FILTER_CONSTRAIN
			{
				LINK	SURFACESPREAD_FILTER_CONSTRAIN_VERTEXSELECTION	{ ACCEPT { Tpointselection; } }
				LINK	SURFACESPREAD_FILTER_CONSTRAIN_POLYSELECTION	{ ACCEPT { 5673; } }
				LINK	SURFACESPREAD_FILTER_CONSTRAIN_WEIGHTMAP		{ ACCEPT { 5682; } }
				BOOL	SURFACESPREAD_FILTER_CONSTRAIN_WEIGHTMAP_INVERT	{  }
			}
			
			GROUP SURFACESPREAD_FILTER_MATERIAL
			{
				REAL	SURFACESPREAD_FILTER_MATERIAL_INTENSITY				{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				SEPARATOR													{  }
				LINK	SURFACESPREAD_FILTER_MATERIAL_MATLINK				{ ACCEPT { 5703; } }
				BOOL	SURFACESPREAD_FILTER_MATERIAL_INVERT				{  }
			}
			
			GROUP SURFACESPREAD_FILTER_DISTRMODIFIER
			{
				REAL		SURFACESPREAD_FILTER_DISTRMODIFIER_INTENSITY	{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				
				SEPARATOR													{  }
				
				BUTTON		SURFACESPREAD_MSG_ADDDISTRMODIFIER				{  }
				IN_EXCLUDE	SURFACESPREAD_FILTER_DISTRMODIFIER_OBJLIST		{ NUM_FLAGS 0; ACCEPT { 1023725; } }
			}
			
			GROUP SURFACESPREAD_FILTER_DISTANCE
			{
				BOOL	SURFACESPREAD_FILTER_DISTANCE_ENABLE			{  }
				REAL	SURFACESPREAD_FILTER_DISTANCE_MIN				{ UNIT METER; MIN 0.0; }
			}
		}
		
		SEPARATOR												{  }

		GROUP SURFACESPREAD_FILTERS_GEO
		{
			DEFAULT 1;
			
			GROUP SURFACESPREAD_FILTER_FRACTALBREAKUP
			{
				REAL	SURFACESPREAD_FILTER_FRACTALBREAKUP_VAL			{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				REAL	SURFACESPREAD_FILTER_FRACTALBREAKUP_OCT			{ UNIT REAL; MIN 0.0; STEP 0.1; }
				REAL	SURFACESPREAD_FILTER_FRACTALBREAKUP_SCALE		{ UNIT REAL; MIN 0.0; STEP 0.01; }
				BOOL	SURFACESPREAD_FILTER_FRACTALBREAKUP_INVERT		{  }
				SPLINE	SURFACESPREAD_FILTER_FRACTALBREAKUP_CURVE		{
																			HIDDEN;
																			SHOWGRID_H; 
																			SHOWGRID_V; 
																			GRIDSIZE_H 10; 
																			GRIDSIZE_V 10; 
																		  
																			HAS_PRESET_BTN; 
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90; 
																		  
																			EDIT_H; 
																			EDIT_V; 
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0; 
																			X_MAX 1.0; 
																		  
																			Y_MIN 0.0; 
																			Y_MAX 1.0; 
																		  
																			X_STEPS 2; 
																			Y_STEPS 2; 
																		}
			}
			
			GROUP SURFACESPREAD_FILTER_HEIGHT
			{
				GROUP
				{
					LAYOUTGROUP;
					COLUMNS 2;
					
					GROUP
					{
						BOOL	SURFACESPREAD_FILTER_HEIGHT_MIN_ENABLE	{  }
						REAL	SURFACESPREAD_FILTER_HEIGHT_MIN			{ UNIT METER; }
						REAL	SURFACESPREAD_FILTER_HEIGHT_MIN_EDGE	{ UNIT METER; MIN 1.0; }
					}

					GROUP
					{
						BOOL	SURFACESPREAD_FILTER_HEIGHT_MAX_ENABLE	{  }
						REAL	SURFACESPREAD_FILTER_HEIGHT_MAX			{ UNIT METER; }
						REAL	SURFACESPREAD_FILTER_HEIGHT_MAX_EDGE	{ UNIT METER; MIN 1.0; }
					}
				}

				SEPARATOR											{ LINE; }

				BOOL	SURFACESPREAD_FILTER_HEIGHT_GLOBALCOORDINATES	{  }
				LONG	SURFACESPREAD_FILTER_HEIGHT_AXIS			{ CYCLE { SURFACESPREAD_AXIS_X; SURFACESPREAD_AXIS_Y; SURFACESPREAD_AXIS_Z; SURFACESPREAD_AXIS_SPHERICAL; } }
			}
			
			GROUP SURFACESPREAD_FILTER_SLOPE
			{
				GROUP
				{
					LAYOUTGROUP;
					COLUMNS 2;
					
					GROUP
					{
						BOOL	SURFACESPREAD_FILTER_SLOPE_MIN_ENABLE	{  }
						REAL	SURFACESPREAD_FILTER_SLOPE_MIN				{ UNIT DEGREE; MIN 0.0; MAX 180.0; }
						REAL	SURFACESPREAD_FILTER_SLOPE_MIN_EDGE		{ UNIT DEGREE; MIN 1.0; }
					}

					GROUP
					{
						BOOL	SURFACESPREAD_FILTER_SLOPE_MAX_ENABLE	{  }
						REAL	SURFACESPREAD_FILTER_SLOPE_MAX				{ UNIT DEGREE; MIN 0.0; MAX 180.0; }
						REAL	SURFACESPREAD_FILTER_SLOPE_MAX_EDGE		{ UNIT DEGREE; MIN 1.0; }
					}
				}
				
				BOOL	SURFACESPREAD_FILTER_SLOPE_USEPHONG			{  }
				
				SEPARATOR																			{ LINE; }

				LONG		SURFACESPREAD_FILTER_SLOPE_AXIS					{ CYCLE { SURFACESPREAD_AXIS_Y; SURFACESPREAD_AXIS_CUSTOM; } }
				LINK		SURFACESPREAD_FILTER_SLOPE_CUSTOMDIR		{ ACCEPT { Onull; } }
			}
		}
		
		SEPARATOR											{  }
		
		GROUP SURFACESPREAD_FILTERS_PERFORMANCE
		{
			BOOL	SURFACESPREAD_FILTERS_PERFORMANCE_USEINRENDERER		{  }
			LINK	SURFACESPREAD_FILTER_PERFORMANCECAM								{ ACCEPT { Ocamera; } }
			
			SEPARATOR													{  }
			
			GROUP SURFACESPREAD_FILTER_CAMDISTANCE
			{
				BOOL	SURFACESPREAD_FILTER_CAMDISTANCE_ENABLE				{  }
				
				GROUP
				{
					LAYOUTGROUP;
					COLUMNS 2;
					
					GROUP
					{
						REAL	SURFACESPREAD_FILTER_CAMDISTANCE_MIN				{ UNIT METER; MIN 0.0; }
						REAL	SURFACESPREAD_FILTER_CAMDISTANCE_EDGEMIN				{ UNIT METER; MIN 0.1; }
					}

					GROUP
					{
						REAL	SURFACESPREAD_FILTER_CAMDISTANCE_MAX				{ UNIT METER; MIN 0.0; }
						REAL	SURFACESPREAD_FILTER_CAMDISTANCE_EDGEMAX				{ UNIT METER; MIN 0.1; }
					}
				}
			}
			
			GROUP SURFACESPREAD_FILTER_CAMCONE
			{
				BOOL	SURFACESPREAD_FILTER_CAMCONE_ENABLE					{  }
				REAL	SURFACESPREAD_FILTER_CAMCONE_CORRVAL				{ UNIT DEGREE; MIN -90.0; MAX 90.0; }
			}
			
			GROUP SURFACESPREAD_FILTER_FACECULL
			{
				BOOL	SURFACESPREAD_FILTER_FACECULL_ENABLE				{  }
				REAL	SURFACESPREAD_FILTER_FACECULL_CORRVAL				{ UNIT DEGREE; MIN -90.0; MAX 90.0; }
			}
		}
	}
	
	GROUP SURFACESPREAD_ALIGN
	{
		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 1;
			
			GROUP
			{
				LONG	SURFACESPREAD_ALIGN_MODE	{ CYCLE
																								{
																									SURFACESPREAD_ALIGN_MODE_NONE;
					           															SURFACESPREAD_ALIGN_MODE_NORMAL;
										          										SURFACESPREAD_ALIGN_MODE_TARGET;
																									SURFACESPREAD_ALIGN_MODE_STATIC;
																								}
																				}
			}
		}
		
		SEPARATOR											{ LINE; }	
		
		GROUP	SURFACESPREAD_ALIGN_MODE_TARGET_SETTINGS
		{
			DEFAULT 1;
			
			LINK	SURFACESPREAD_ALIGN_MODE_TARGET_OBJ			{  }
			LINK	SURFACESPREAD_ALIGN_MODE_TARGET_UPOBJ		{  }
		}
		
		GROUP	SURFACESPREAD_ALIGN_MODE_NORMAL_SETTINGS
		{
			DEFAULT 1;
			
			BOOL	SURFACESPREAD_ALIGN_MODE_NORMAL_USEPHONG		{  }
			
			SEPARATOR												{  }
			
			LINK	SURFACESPREAD_ALIGN_MODE_NORMAL_UPOBJ			{ ACCEPT { Obase; } }
			
			SEPARATOR												{  }
			
			REAL	SURFACESPREAD_ALIGN_MODE_NORMAL_STATICMIX		{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			LONG	SURFACESPREAD_ALIGN_MODE_NORMAL_MIXAXIS			{
																														CYCLE	{
																																		SURFACESPREAD_AXIS_X;
																																		SURFACESPREAD_AXIS_Y;
																																		SURFACESPREAD_AXIS_Z;
																																		SURFACESPREAD_AXIS_SPHERICALAXIS;
																																		SURFACESPREAD_AXIS_CUSTOM;
																																	}
																													}
			VECTOR	SURFACESPREAD_ALIGN_MODE_NORMAL_MIXCUSTOM		{  }
		}

		GROUP	SURFACESPREAD_ALIGN_MODE_STATIC_SETTINGS
		{
			DEFAULT 1;
			
			VECTOR	SURFACESPREAD_ALIGN_MODE_STATIC_ROT			{ UNIT DEGREE; STEP 0.1; }
		}
	}
	
	GROUP SURFACESPREAD_EFFECT
	{
		GROUP	SURFACESPREAD_EFFECT_POSITION
		{
			DEFAULT 1;
			
			GROUP	SURFACESPREAD_EFFECT_STATICOFFSET
			{
				LONG	SURFACESPREAD_EFFECT_STATICOFFSET_MODE			{
																			CYCLE
																			{
																				SURFACESPREAD_EFFECT_STATICOFFSET_MODE_STD;
																				SURFACESPREAD_EFFECT_STATICOFFSET_MODE_NORMAL;
																			}
																		}
				VECTOR	SURFACESPREAD_EFFECT_STATICOFFSET_VECTOR		{ UNIT METER; }
				REAL	SURFACESPREAD_EFFECT_STATICOFFSET_REAL			{ UNIT METER; }
			}
			
			GROUP	SURFACESPREAD_EFFECT_RANDOMOFFSET
			{
				REAL	SURFACESPREAD_EFFECT_RANDOMOFFSET_INTENSITY		{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				REAL	SURFACESPREAD_EFFECT_RANDOMOFFSET_MIN			{ UNIT METER; }
				REAL	SURFACESPREAD_EFFECT_RANDOMOFFSET_MAX			{ UNIT METER; }
				LONG	SURFACESPREAD_EFFECT_RANDOMOFFSET_SEED			{ MIN 1; }
			}
			
			GROUP	SURFACESPREAD_EFFECT_MATERIALOFFSET
			{
				REAL	SURFACESPREAD_EFFECT_MATERIALOFFSET_HEIGHT		{ UNIT METER; }
				LINK	SURFACESPREAD_EFFECT_MATERIALOFFSET_MATLINK		{ ACCEPT { 5703; } }
			}
		}
		
		SEPARATOR												{  }
		
		GROUP	SURFACESPREAD_EFFECT_ROTATION
		{
			DEFAULT 1;
			
			GROUP	SURFACESPREAD_EFFECT_RNDROT
			{
				REAL	SURFACESPREAD_EFFECT_RNDROT_INTENSITY			{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				VECTOR	SURFACESPREAD_EFFECT_RNDROT_MAX					{ UNIT DEGREE; MIN 0.0; }
				LONG	SURFACESPREAD_EFFECT_RNDROT_SEED				{ MIN 1; }
			}
		}
		
		SEPARATOR												{  }
		
		GROUP	SURFACESPREAD_EFFECT_SCALE
		{
			DEFAULT 1;
			
			GROUP	SURFACESPREAD_EFFECT_STDSCALE
			{
				REAL	SURFACESPREAD_EFFECT_STDSCALE_SINGLEVAL			{ UNIT PERCENT; }
				VECTOR	SURFACESPREAD_EFFECT_STDSCALE_VAL				{ UNIT PERCENT; MIN 0.0; }
			}
			
			GROUP	SURFACESPREAD_EFFECT_RNDSCALE
			{	
				REAL	SURFACESPREAD_EFFECT_RNDSCALE_INTENSITY			{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				VECTOR	SURFACESPREAD_EFFECT_RNDSCALE_MAX				{ UNIT PERCENT; MIN 0.0; }
				BOOL	SURFACESPREAD_EFFECT_RNDSCALE_FRACTAL			{  }
				
				GROUP
				{
					SEPARATOR												{  }
					
					LONG	SURFACESPREAD_EFFECT_RNDSCALE_SEED				{ MIN 1; }
					BOOL	SURFACESPREAD_EFFECT_RNDSCALE_DISTORT			{  }
					REAL	SURFACESPREAD_EFFECT_RNDSCALE_FRACTAL_SCALE		{ UNIT REAL; STEP 0.01; }
					REAL	SURFACESPREAD_EFFECT_RNDSCALE_FRACTAL_SHIFT		{ UNIT REAL; STEP 0.01; }
				}
			}
			
			GROUP	SURFACESPREAD_EFFECT_VERTEXMAPSCALE
			{
				REAL		SURFACESPREAD_EFFECT_VERTEXMAPSCALE_INTENSITY	{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				
				SEPARATOR													{  }
				
				LINK		SURFACESPREAD_EFFECT_VERTEXMAPSCALE_VERTEXMAP	{ ACCEPT { 5682; } }				
			}
			
			GROUP	SURFACESPREAD_EFFECT_MATSCALE
			{
				REAL	SURFACESPREAD_EFFECT_MATSCALE_INTENSITY			{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				
				SEPARATOR												{  }
				
				LINK	SURFACESPREAD_EFFECT_MATSCALE_MATLINK			{ ACCEPT { 5703; } }				
			}
			
			GROUP	SURFACESPREAD_EFFECT_CTRLSCALE
			{
				REAL		SURFACESPREAD_EFFECT_CTRLSCALE_INTENSITY	{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				
				SEPARATOR												{  }
				
				BUTTON		SURFACESPREAD_MSG_ADDSCALEMODIFIER			{  }
				IN_EXCLUDE	SURFACESPREAD_EFFECT_CTRLSCALE_OBJLIST		{ NUM_FLAGS 0; ACCEPT { 1023659; } }
			}
			
			GROUP	SURFACESPREAD_EFFECT_WEIGHTSCALE
			{
				SEPARATOR	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_STD	{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_VERTEXMAP	{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_MODIFIER	{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_MATERIAL	{  }
				REAL SURFACESPREAD_EFFECT_WEIGHTSCALE_STDINTENSITY { UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				SPLINE SURFACESPREAD_EFFECT_WEIGHTSCALE_STDCURVE
				{
					SHOWGRID_H; 
					SHOWGRID_V; 
					GRIDSIZE_H 10; 
					GRIDSIZE_V 10; 
				  
					HAS_PRESET_BTN; 
				  
					//MINSIZE_H 100;
					MINSIZE_V 90; 
				  
					EDIT_H; 
					EDIT_V; 
				  
					HAS_ROUND_SLIDER;
				  
					X_MIN 0.0; 
					X_MAX 1.0; 
				  
					Y_MIN 0.0; 
					Y_MAX 1.0; 
				  
					X_STEPS 2; 
					Y_STEPS 2; 
				}

				SEPARATOR	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_GEO	{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_FRACTAL	{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_HEIGHT		{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_SLOPE		{  }
				REAL	SURFACESPREAD_EFFECT_WEIGHTSCALE_GEOINTENSITY	{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				SPLINE SURFACESPREAD_EFFECT_WEIGHTSCALE_GEOCURVE
				{
					SHOWGRID_H;
					SHOWGRID_V;
					GRIDSIZE_H 10;
					GRIDSIZE_V 10;
				  
					HAS_PRESET_BTN;
				  
					//MINSIZE_H 100;
					MINSIZE_V 90;
				  
					EDIT_H;
					EDIT_V;
				  
					HAS_ROUND_SLIDER;
				  
					X_MIN 0.0;
					X_MAX 1.0;
				  
					Y_MIN 0.0;
					Y_MAX 1.0;
				  
					X_STEPS 2;
					Y_STEPS 2;
				}

				SEPARATOR	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_PERF	{  }
				BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_CAMDIST	{  }
				//BOOL	SURFACESPREAD_EFFECT_WEIGHTSCALE_SRC_BACKFACE	{  }
				REAL	SURFACESPREAD_EFFECT_WEIGHTSCALE_PERFINTENSITY	{ UNIT PERCENT; STEP 1.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				SPLINE SURFACESPREAD_EFFECT_WEIGHTSCALE_PERFCURVE
				{
					SHOWGRID_H; 
					SHOWGRID_V; 
					GRIDSIZE_H 10; 
					GRIDSIZE_V 10; 
				  
					HAS_PRESET_BTN; 
				  
					//MINSIZE_H 100;
					MINSIZE_V 90; 
				  
					EDIT_H; 
					EDIT_V; 
				  
					HAS_ROUND_SLIDER;
				  
					X_MIN 0.0; 
					X_MAX 1.0; 
				  
					Y_MIN 0.0; 
					Y_MAX 1.0; 
				  
					X_STEPS 2; 
					Y_STEPS 2; 
				}
			}
		}
		
		SEPARATOR												{  }
		
//		GROUP SURFACESPREAD_EFFECT_MISC
//		{
//			DEFAULT 1;
//			
//			GROUP SURFACESPREAD_EFFECT_LOD
//			{
//				BOOL	SURFACESPREAD_EFFECT_LOD_ENABLE							{  }
//				
//				SEPARATOR														{  }
//				
//				GROUP
//				{
//					LAYOUTGROUP;
//					COLUMNS 2;
//					
//					GROUP
//					{
//						REAL	SURFACESPREAD_EFFECT_LOD_DIST_MIN					{ UNIT METER; MIN 0.0; }
//						REAL	SURFACESPREAD_EFFECT_LOD_VAL_MIN					{ UNIT PERCENT; MIN 0.0; }
//					}
//					
//					GROUP
//					{
//						REAL	SURFACESPREAD_EFFECT_LOD_DIST_MAX					{ UNIT METER; MIN 0.0; }
//						REAL	SURFACESPREAD_EFFECT_LOD_VAL_MAX					{ UNIT PERCENT; MIN 0.0; }
//						
//					}
//				}
//				SPLINE	SURFACESPREAD_EFFECT_LOD_CURVE	{
//															SHOWGRID_H; 
//															SHOWGRID_V; 
//															GRIDSIZE_H 10; 
//															GRIDSIZE_V 10; 
//														  
//															HAS_PRESET_BTN; 
//														  
//															//MINSIZE_H 100;
//															MINSIZE_V 90; 
//														  
//															EDIT_H; 
//															EDIT_V; 
//														  
//															HAS_ROUND_SLIDER;
//														  
//															X_MIN 0.0; 
//															X_MAX 1.0; 
//														  
//															Y_MIN 0.0; 
//															Y_MAX 1.0; 
//														  
//															X_STEPS 2; 
//															Y_STEPS 2; 
//														}
//			}
//		}
	}
}
