///////////////////////////////////////////////////
//
// SurfaceSPREAD Landscape Description Resource
// (c) 2009 Jack's Secret Stash
// All rights reserved.
//
///////////////////////////////////////////////////

CONTAINER OSurfaceSpreadLandscape
{
	NAME OSurfaceSpreadLandscape;
	INCLUDE Obase;

	GROUP SURFACESPREAD_LANDSCAPE_GENERAL
	{
		DEFAULT 1;

		VECTOR	SURFACESPREAD_LANDSCAPE_SIZE						{ UNIT METER; MIN 0.0; }
		
		SEPARATOR													{  }
		
		LONG	SURFACESPREAD_LANDSCAPE_SUB_X						{ MIN 4; }
		LONG	SURFACESPREAD_LANDSCAPE_SUB_Y						{ MIN 4; }
		
		SEPARATOR													{ LINE; }
		
		BOOL	SURFACESPREAD_LANDSCAPE_CACHING						{  }
				
		SEPARATOR											{  }
		
		GROUP
		{
			SEPARATOR SURFACESPREAD_LANDSCAPE_SEP_DETAILLAYERS	{  }
			
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					BOOL	SURFACESPREAD_LANDSCAPE_NOISE_1_ENABLE		{  }
					BOOL	SURFACESPREAD_LANDSCAPE_NOISE_2_ENABLE		{  }
					BOOL	SURFACESPREAD_LANDSCAPE_NOISE_3_ENABLE		{  }
				}
				GROUP
				{
					BOOL	SURFACESPREAD_LANDSCAPE_NOISE_4_ENABLE		{  }
					BOOL	SURFACESPREAD_LANDSCAPE_NOISE_5_ENABLE		{  }
					BOOL	SURFACESPREAD_LANDSCAPE_NOISE_6_ENABLE		{  }
				}
			}
		}
		
		SEPARATOR													{  }
		
		GROUP
		{
			SEPARATOR	SURFACESPREAD_LANDSCAPE_SEP_PRESETS				{  }
			
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					BUTTON		SURFACESPREAD_LANDSCAPE_MSG_PRESET_LOAD			{  }
				}
				GROUP
				{
					BUTTON		SURFACESPREAD_LANDSCAPE_MSG_PRESET_SAVE			{  }
				}
			}
		
		}
	}
	
	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_0
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_0_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_0_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_0_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_0_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_0_ABS			{  }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_0_NORMALIZE	{  }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_0_INVERT		{  }
	}
		
	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_1
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_1_LAYERTYPE	{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SPLINE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SHADER;
																	}  }
																
		SEPARATOR											{ LINE; }
		
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_1_MODE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_ADD;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_LOWEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_HIGHEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_MULTIPLY;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_SPLINESET;
																	}  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_HEIGHT		{  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_OFFSET		{  }

		SEPARATOR											{ LINE; }

		LINK	SURFACESPREAD_LANDSCAPE_NOISE_1_MATERIAL	{ ACCEPT { 5703; } }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_MATERIAL_BLUR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_1_SPLINE		{ ACCEPT { Ospline; 1023662; Osplineprofile; Osplineflower; Osplineformula; Osplinetext; Osplinenside; Ospline4side; Osplinecircle; Osplinearc; Osplinecissoid; Osplinecycloid; Osplinehelix; Osplinerectangle; Osplinestar; Osplinecogwheel; Osplinecontour; } }
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_1_SPLINE_ACC	{ MIN 2; MAX 1000; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_SPLINE_RAD	{ UNIT METER; MIN 0.0; }
		
		SEPARATOR											{  }
		
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_1_SPLINE_CURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_1_SPLINE_RADCURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_1_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_1_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_1_ABS			{  }
		BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_1_UPD			{  }
		
		GROUP 	SURFACESPREAD_LANDSCAPE_NOISE_1_SHAPE
		{
			REAL	SURFACESPREAD_LANDSCAPE_NOISE_1_SHAPE_MIX			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_1_SHAPE_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}

			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_LANDSCAPE_NOISE_1_SHAPE_PRESET		{ CYCLE {
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																				} }
				}
				
				GROUP
				{
					BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_1_SHAPE_APPLYPRESET	{  }
				}
				
			}
		}
	}

	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_2
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_2_LAYERTYPE	{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SPLINE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SHADER;
																	}  }

		SEPARATOR											{ LINE; }
		
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_2_MODE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_ADD;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_LOWEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_HIGHEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_MULTIPLY;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_SPLINESET;
																	}  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_HEIGHT		{  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_OFFSET		{  }

		SEPARATOR											{ LINE; }

		LINK	SURFACESPREAD_LANDSCAPE_NOISE_2_MATERIAL	{ ACCEPT { 5703; } }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_MATERIAL_BLUR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_2_SPLINE		{ ACCEPT { Ospline; 1023662; Osplineprofile; Osplineflower; Osplineformula; Osplinetext; Osplinenside; Ospline4side; Osplinecircle; Osplinearc; Osplinecissoid; Osplinecycloid; Osplinehelix; Osplinerectangle; Osplinestar; Osplinecogwheel; Osplinecontour; } }
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_2_SPLINE_ACC	{ MIN 2; MAX 1000; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_SPLINE_RAD	{ UNIT METER; MIN 0.0; }
		
		SEPARATOR											{  }
		
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_2_SPLINE_CURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_2_SPLINE_RADCURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_2_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_2_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_2_ABS			{  }
		BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_2_UPD			{  }
		
		GROUP 	SURFACESPREAD_LANDSCAPE_NOISE_2_SHAPE
		{
			REAL	SURFACESPREAD_LANDSCAPE_NOISE_2_SHAPE_MIX			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_2_SHAPE_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}

			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_LANDSCAPE_NOISE_2_SHAPE_PRESET		{ CYCLE {
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																				} }
				}
				
				GROUP
				{
					BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_2_SHAPE_APPLYPRESET	{  }
				}
				
			}
		}
	}

	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_3
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_3_LAYERTYPE	{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SPLINE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SHADER;
																	}  }

		SEPARATOR											{ LINE; }
		
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_3_MODE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_ADD;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_LOWEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_HIGHEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_MULTIPLY;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_SPLINESET;
																	}  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_HEIGHT		{  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_OFFSET		{  }

		SEPARATOR											{ LINE; }

		LINK	SURFACESPREAD_LANDSCAPE_NOISE_3_MATERIAL	{ ACCEPT { 5703; } }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_MATERIAL_BLUR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_3_SPLINE		{ ACCEPT { Ospline; 1023662; Osplineprofile; Osplineflower; Osplineformula; Osplinetext; Osplinenside; Ospline4side; Osplinecircle; Osplinearc; Osplinecissoid; Osplinecycloid; Osplinehelix; Osplinerectangle; Osplinestar; Osplinecogwheel; Osplinecontour; } }
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_3_SPLINE_ACC	{ MIN 2; MAX 1000; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_SPLINE_RAD	{ UNIT METER; MIN 0.0; }
		
		SEPARATOR											{  }
		
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_3_SPLINE_CURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_3_SPLINE_RADCURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_3_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_3_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_3_ABS			{  }
		BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_3_UPD			{  }
		
		GROUP 	SURFACESPREAD_LANDSCAPE_NOISE_3_SHAPE
		{
			REAL	SURFACESPREAD_LANDSCAPE_NOISE_3_SHAPE_MIX			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_3_SHAPE_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}

			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_LANDSCAPE_NOISE_3_SHAPE_PRESET		{ CYCLE {
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																				} }
				}
				
				GROUP
				{
					BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_3_SHAPE_APPLYPRESET	{  }
				}
				
			}
		}
	}

	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_4
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_4_LAYERTYPE	{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SPLINE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SHADER;
																	}  }

		SEPARATOR											{ LINE; }
		
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_4_MODE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_ADD;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_LOWEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_HIGHEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_MULTIPLY;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_SPLINESET;
																	}  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_HEIGHT		{  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_OFFSET		{  }

		SEPARATOR											{ LINE; }

		LINK	SURFACESPREAD_LANDSCAPE_NOISE_4_MATERIAL	{ ACCEPT { 5703; } }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_MATERIAL_BLUR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_4_SPLINE		{ ACCEPT { Ospline; 1023662; Osplineprofile; Osplineflower; Osplineformula; Osplinetext; Osplinenside; Ospline4side; Osplinecircle; Osplinearc; Osplinecissoid; Osplinecycloid; Osplinehelix; Osplinerectangle; Osplinestar; Osplinecogwheel; Osplinecontour; } }
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_4_SPLINE_ACC	{ MIN 2; MAX 1000; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_SPLINE_RAD	{ UNIT METER; MIN 0.0; }
		
		SEPARATOR											{  }
		
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_4_SPLINE_CURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_4_SPLINE_RADCURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_4_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_4_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_4_ABS			{  }
		BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_4_UPD			{  }
		
		GROUP 	SURFACESPREAD_LANDSCAPE_NOISE_4_SHAPE
		{
			REAL	SURFACESPREAD_LANDSCAPE_NOISE_4_SHAPE_MIX			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_4_SHAPE_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}

			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_LANDSCAPE_NOISE_4_SHAPE_PRESET		{ CYCLE {
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																				} }
				}
				
				GROUP
				{
					BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_4_SHAPE_APPLYPRESET	{  }
				}
				
			}
		}
	}

	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_5
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_5_LAYERTYPE	{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SPLINE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SHADER;
																	}  }

		SEPARATOR											{ LINE; }
		
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_5_MODE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_ADD;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_LOWEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_HIGHEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_MULTIPLY;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_SPLINESET;
																	}  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_HEIGHT		{  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_OFFSET		{  }

		SEPARATOR											{ LINE; }

		LINK	SURFACESPREAD_LANDSCAPE_NOISE_5_MATERIAL	{ ACCEPT { 5703; } }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_MATERIAL_BLUR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_5_SPLINE		{ ACCEPT { Ospline; 1023662; Osplineprofile; Osplineflower; Osplineformula; Osplinetext; Osplinenside; Ospline4side; Osplinecircle; Osplinearc; Osplinecissoid; Osplinecycloid; Osplinehelix; Osplinerectangle; Osplinestar; Osplinecogwheel; Osplinecontour; } }
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_5_SPLINE_ACC	{ MIN 2; MAX 1000; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_SPLINE_RAD	{ UNIT METER; MIN 0.0; }
		
		SEPARATOR											{  }
		
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_5_SPLINE_CURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_5_SPLINE_RADCURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_5_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_5_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_5_ABS			{  }
		BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_5_UPD			{  }
		
		GROUP 	SURFACESPREAD_LANDSCAPE_NOISE_5_SHAPE
		{
			REAL	SURFACESPREAD_LANDSCAPE_NOISE_5_SHAPE_MIX			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_5_SHAPE_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}

			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_LANDSCAPE_NOISE_5_SHAPE_PRESET		{ CYCLE {
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																				} }
				}
				
				GROUP
				{
					BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_5_SHAPE_APPLYPRESET	{  }
				}
				
			}
		}
	}

	GROUP	SURFACESPREAD_LANDSCAPE_NOISE_6
	{
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_6_LAYERTYPE	{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SPLINE;
																		SURFACESPREAD_LANDSCAPE_LAYER_TYPE_SHADER;
																	}  }

		SEPARATOR											{ LINE; }
		
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_6_MODE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_ADD;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_LOWEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_HIGHEST;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_MULTIPLY;
																		SURFACESPREAD_LANDSCAPE_NOISE_MODE_SPLINESET;
																	}  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_HEIGHT		{  }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_OFFSET		{  }
		
		SEPARATOR											{ LINE; }
		
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_6_MATERIAL	{ ACCEPT { 5703; } }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_MATERIAL_BLUR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LINK	SURFACESPREAD_LANDSCAPE_NOISE_6_SPLINE		{ ACCEPT { Ospline; 1023662; Osplineprofile; Osplineflower; Osplineformula; Osplinetext; Osplinenside; Ospline4side; Osplinecircle; Osplinearc; Osplinecissoid; Osplinecycloid; Osplinehelix; Osplinerectangle; Osplinestar; Osplinecogwheel; Osplinecontour; } }
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_6_SPLINE_ACC	{ MIN 2; MAX 1000; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_SPLINE_RAD	{ UNIT METER; MIN 0.0; }
		
		SEPARATOR											{  }
		
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_6_SPLINE_CURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_6_SPLINE_RADCURVE	{
																	SHOWGRID_H;
																	SHOWGRID_V;
																	GRIDSIZE_H 10;
																	GRIDSIZE_V 10;
																  
																	HAS_PRESET_BTN;
																  
																	MINSIZE_H 100;
																	MINSIZE_V 90;
																  
																	EDIT_H;
																	EDIT_V;
																  
																	HAS_ROUND_SLIDER;
																  
																	X_MIN 0.0;
																	X_MAX 1.0;
																  
																	Y_MIN 0.0;
																	Y_MAX 1.0;
																  
																	X_STEPS 2;
																	Y_STEPS 2;
																}
		LONG	SURFACESPREAD_LANDSCAPE_NOISE_6_TYPE		{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_TURBULENCE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_WAVY;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_NOISE;
																		SURFACESPREAD_LANDSCAPE_NOISE_TYPE_RIDGED;
																	}	}
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_SCALE		{ STEP 0.01; }
		REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_OCT			{ MIN 0.1; STEP 0.1; MAX 20.0; }
		VECTOR	SURFACESPREAD_LANDSCAPE_NOISE_6_SHIFT		{ STEP 0.01; }
		BOOL	SURFACESPREAD_LANDSCAPE_NOISE_6_ABS			{  }
		BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_6_UPD			{  }
		
		GROUP 	SURFACESPREAD_LANDSCAPE_NOISE_6_SHAPE
		{
			REAL	SURFACESPREAD_LANDSCAPE_NOISE_6_SHAPE_MIX			{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_NOISE_6_SHAPE_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}

			GROUP
			{
				LAYOUTGROUP;
				COLUMNS 2;
				
				GROUP
				{
					LONG	SURFACESPREAD_LANDSCAPE_NOISE_6_SHAPE_PRESET		{ CYCLE {
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																					SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																				} }
				}
				
				GROUP
				{
					BUTTON	SURFACESPREAD_LANDSCAPE_NOISE_6_SHAPE_APPLYPRESET	{  }
				}
				
			}
		}
	}

	GROUP SURFACESPREAD_LANDSCAPE_SHAPE
	{		
		REAL	SURFACESPREAD_LANDSCAPE_SHAPE_MIX					{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		SPLINE	SURFACESPREAD_LANDSCAPE_SHAPE_CURVE					{
																		SHOWGRID_H;
																		SHOWGRID_V;
																		GRIDSIZE_H 10;
																		GRIDSIZE_V 10;
																	  
																		HAS_PRESET_BTN;
																	  
																		MINSIZE_H 100;
																		MINSIZE_V 90;
																	  
																		EDIT_H;
																		EDIT_V;
																	  
																		HAS_ROUND_SLIDER;
																	  
																		X_MIN 0.0;
																		X_MAX 1.0;
																	  
																		Y_MIN 0.0;
																		Y_MAX 1.0;
																	  
																		X_STEPS 2;
																		Y_STEPS 2;
																	}

		GROUP
		{
			LAYOUTGROUP;
			COLUMNS 2;
			
			GROUP
			{
				LONG	SURFACESPREAD_LANDSCAPE_SHAPE_PRESET				{ CYCLE {
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_LINEAR;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_CANYONIZE;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_GLACIATE;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_PLATEAU;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_SOFTPLATEAU;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_DUNES2;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES5;
																				SURFACESPREAD_LANDSCAPE_SHAPE_PRESET_TERRACES10;
																			} }
			}
			
			GROUP
			{
				BUTTON	SURFACESPREAD_LANDSCAPE_SHAPE_APPLYPRESET			{  }
			}
			
		}
		
		SEPARATOR													{  }
		
		LONG	SURFACESPREAD_LANDSCAPE_SHAPE_ORDER					{ CYCLE {
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_L1;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_L2;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_L3;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_L4;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_L5;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_L6;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_EB;
																		SURFACESPREAD_LANDSCAPE_SHAPE_ORDER_STD;
																	} }
																			
		SEPARATOR													{  }

		GROUP
		{
			SEPARATOR	SURFACESPREAD_LANDSCAPE_SEP_EVENBORDER			{  }
			
			REAL	SURFACESPREAD_LANDSCAPE_EVENBORDER					{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			SPLINE	SURFACESPREAD_LANDSCAPE_EVENBORDER_CURVE			{
																			SHOWGRID_H;
																			SHOWGRID_V;
																			GRIDSIZE_H 10;
																			GRIDSIZE_V 10;
																		  
																			HAS_PRESET_BTN;
																		  
																			MINSIZE_H 100;
																			MINSIZE_V 90;
																		  
																			EDIT_H;
																			EDIT_V;
																		  
																			HAS_ROUND_SLIDER;
																		  
																			X_MIN 0.0;
																			X_MAX 1.0;
																		  
																			Y_MIN 0.0;
																			Y_MAX 1.0;
																		  
																			X_STEPS 2;
																			Y_STEPS 2;
																		}
		}
	}
	
	GROUP SURFACESPREAD_LANDSCAPE_PHONG
	{
		BOOL	SURFACESPREAD_LANDSCAPE_PHONG_ANGLE_LIMIT			{  }
		REAL	SURFACESPREAD_LANDSCAPE_PHONG_ANGLE					{ UNIT DEGREE; MIN 0.0; MAX 180.0; }
	}
}
