///////////////////////////////////////////////////
//
// Road Shader Description Resource
// (c) 2010 Jack's Secret Stash
// All rights reserved.
//
///////////////////////////////////////////////////

CONTAINER xroad
{
	NAME xroad;

	INCLUDE Mpreview;
	INCLUDE Xbase;

	GROUP ID_SHADERPROPERTIES
	{
		GROUP	ROAD_ASPHALT
		{
			DEFAULT 1;

			BOOL	ROAD_ASPHALT_ENABLE						{  }
			COLOR	ROAD_COLOR_ASPHALT						{  }

			SEPARATOR														{ LINE; }

			GROUP
			{
				COLUMNS 2;

				REAL	ROAD_ASPHALT_INTENSITY1			{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
				REAL	ROAD_ASPHALT_SCALE1					{ UNIT PERCENT; }
				REAL	ROAD_ASPHALT_INTENSITY2			{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
				REAL	ROAD_ASPHALT_SCALE2					{ UNIT PERCENT; }
				REAL	ROAD_ASPHALT_INTENSITY3			{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
				REAL	ROAD_ASPHALT_SCALE3					{ UNIT PERCENT; }
			}
		}

		GROUP	ROAD_MARKS
		{
			DEFAULT 1;

			COLOR	ROAD_COLOR_MARKS							{  }

			SEPARATOR														{ LINE; }
				
			BOOL ROAD_CENTERMARKS_ENABLE				{  }
			REAL ROAD_CENTERMARKS_LENGTH				{ MIN 1.0; }
			REAL ROAD_CENTERMARKS_WIDTH				{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL ROAD_CENTERMARKS_SOFTEN				{ UNIT PERCENT; MIN 0.1; MAX 100.0; STEP 0.1; }

			SEPARATOR { LINE; }

			BOOL ROAD_SIDEMARKS_ENABLE					{  }
			REAL ROAD_WIDTH										{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL ROAD_SIDEMARKS_WIDTH					{	UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL ROAD_SIDEMARKS_SOFTEN					{ UNIT PERCENT; MIN 0.1; MAX 100.0; STEP 0.1; }

			SEPARATOR														{ LINE; }

			REAL	ROAD_MARKS_BREAKUP_INTENSITY	{	UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL	ROAD_MARKS_BREAKUP_SHARPNESS	{	UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL	ROAD_MARKS_BREAKUP_SCALE			{	UNIT PERCENT; MIN 0.0; STEP 1.0; }

			SEPARATOR														{ LINE; }

			REAL	ROAD_MARKS_BLEND							{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			SPLINE	ROAD_MARKS_VBLEND						{
																						SHOWGRID_H; 
																						SHOWGRID_V; 
																						GRIDSIZE_H 10; 
																						GRIDSIZE_V 10; 
																					  
																						HAS_PRESET_BTN; 
																					  
																						MINSIZE_H 100;
																						MINSIZE_V 90; 
																					  
																						EDIT_H; 
																						EDIT_V; 
																					  
																						HAS_ROUND_SLIDER;
																					  
																						X_MIN 0.0; 
																						X_MAX 1.0; 
																					  
																						Y_MIN 0.0; 
																						Y_MAX 1.0; 
																					  
																						X_STEPS 2; 
																						Y_STEPS 2; 
																					}
		}
		
		GROUP	ROAD_TIREMARKS
		{
			DEFAULT 1;

			BOOL	ROAD_TIREMARKS_ENABLE					{  }
			
			GROUP
			{
				COLUMNS 2;
				
				REAL	ROAD_TIREMARKS_DISTANCE				{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
				REAL	ROAD_TIREMARKS_TIREWIDTH			{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
				REAL	ROAD_TIREMARKS_TRACKGAUGE			{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
				REAL	ROAD_TIREMARKS_SOFT						{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			}

			SEPARATOR														{ LINE; }

			REAL	ROAD_TIREMARKS_BLEND					{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			SPLINE	ROAD_TIREMARKS_VBLEND				{
																						SHOWGRID_H; 
																						SHOWGRID_V; 
																						GRIDSIZE_H 10; 
																						GRIDSIZE_V 10; 
																					  
																						HAS_PRESET_BTN; 
																					  
																						MINSIZE_H 100;
																						MINSIZE_V 90; 
																					  
																						EDIT_H; 
																						EDIT_V; 
																					  
																						HAS_ROUND_SLIDER;
																					  
																						X_MIN 0.0; 
																						X_MAX 1.0; 
																					  
																						Y_MIN 0.0; 
																						Y_MAX 1.0; 
																					  
																						X_STEPS 2; 
																						Y_STEPS 2; 
																					}
		}
		
		GROUP	ROAD_CRACKS
		{
			DEFAULT 1;

			BOOL	ROAD_CRACKS_ENABLE						{  }
			REAL	ROAD_CRACKS_SCALE							{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
			REAL	ROAD_CRACKS_COVERAGE					{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL	ROAD_CRACKS_COVERAGE_SHARPNESS		{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL	ROAD_CRACKS_COVERAGE_RANDOM		{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL	ROAD_CRACKS_COVERAGE_RANDOMSCALE	{ UNIT PERCENT; MIN 0.0; STEP 1.0; }

			SEPARATOR														{ LINE; }

			REAL	ROAD_CRACKS_BLEND							{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			BOOL	ROAD_CRACKS_OVERMARKS					{  }
		}
	}
}
