package laya.d3.core.particleShuriKen.module.shape {
	import laya.d3.math.Vector2;
	import laya.d3.math.Vector3;
	
	/**
	 * <code>CircleShape</code> 类用于创建环形粒子形状。
	 */
	public class CircleShape extends BaseShape {
		/** @private */
		protected static var _tempPositionPoint:Vector2 = new Vector2();
		
		/**发射器半径。*/
		public var radius:Number;
		/**环形弧度。*/
		public var arc:Number;
		/**从边缘发射。*/
		public var emitFromEdge:Boolean;
		/**随机方向。*/
		public var randomDirection:Boolean;
		
		/**
		 * 创建一个 <code>CircleShape</code> 实例。
		 */
		public function CircleShape() {
			super();
			radius = 1.0;
			arc = 360.0 / 180.0 * Math.PI;
			emitFromEdge = false;
			randomDirection = false;
		}
		
		/**
		 *  用于生成粒子初始位置和方向。
		 * @param	position 粒子位置。
		 * @param	direction 粒子方向。
		 */
		override public function generatePositionAndDirection(position:Vector3, direction:Vector3):void {
			var rpE:Float32Array = position.elements;
			var positionPointE:Float32Array = _tempPositionPoint.elements;
			if (emitFromEdge)
				ShapeUtils._randomPointUnitArcCircle(arc, _tempPositionPoint);
			else
				ShapeUtils._randomPointInsideUnitArcCircle(arc, _tempPositionPoint);
			
			rpE[0] = positionPointE[0];
			rpE[1] = positionPointE[1];
			rpE[2] = 0;
			
			Vector3.scale(position, radius, position);
			
			if (randomDirection) {
				ShapeUtils._randomPointUnitSphere(direction);
			} else {
				position.cloneTo(direction);
			}
		}
		
		override public function cloneTo(destObject:*):void {
			super.cloneTo(destObject);
			var destShape:CircleShape = destObject as CircleShape;
			destShape.radius = radius;
			destShape.arc = arc;
			destShape.emitFromEdge = emitFromEdge;
			destShape.randomDirection = randomDirection;
		}
	
	}

}