import * as code from 'vscode';
import * as ls from 'vscode-languageserver-types';
import * as proto from './protocol';
export interface Converter {
    asUri(uri: code.Uri): string;
    asTextDocumentIdentifier(textDocument: code.TextDocument): ls.TextDocumentIdentifier;
    asOpenTextDocumentParams(textDocument: code.TextDocument): proto.DidOpenTextDocumentParams;
    asChangeTextDocumentParams(textDocument: code.TextDocument): proto.DidChangeTextDocumentParams;
    asChangeTextDocumentParams(event: code.TextDocumentChangeEvent): proto.DidChangeTextDocumentParams;
    asCloseTextDocumentParams(textDocument: code.TextDocument): proto.DidCloseTextDocumentParams;
    asSaveTextDocumentParams(textDocument: code.TextDocument): proto.DidSaveTextDocumentParams;
    asTextDocumentPositionParams(textDocument: code.TextDocument, position: code.Position): proto.TextDocumentPositionParams;
    asWorkerPosition(position: code.Position): ls.Position;
    asRange(value: code.Range): ls.Range;
    asPosition(value: code.Position): ls.Position;
    asDiagnosticSeverity(value: code.DiagnosticSeverity): ls.DiagnosticSeverity;
    asDiagnostic(item: code.Diagnostic): ls.Diagnostic;
    asDiagnostics(items: code.Diagnostic[]): ls.Diagnostic[];
    asCompletionItem(item: code.CompletionItem): ls.CompletionItem;
    asTextEdit(edit: code.TextEdit): ls.TextEdit;
    asReferenceParams(textDocument: code.TextDocument, position: code.Position, options: {
        includeDeclaration: boolean;
    }): proto.ReferenceParams;
    asCodeActionContext(context: code.CodeActionContext): ls.CodeActionContext;
    asCommand(item: code.Command): ls.Command;
    asCodeLens(item: code.CodeLens): ls.CodeLens;
    asFormattingOptions(item: code.FormattingOptions): ls.FormattingOptions;
    asDocumentSymbolParams(textDocument: code.TextDocument): proto.DocumentSymbolParams;
    asCodeLensParams(textDocument: code.TextDocument): proto.CodeLensParams;
    asDocumentLink(item: code.DocumentLink): ls.DocumentLink;
    asDocumentLinkParams(textDocument: code.TextDocument): proto.DocumentLinkParams;
}
export interface URIConverter {
    (value: code.Uri): string;
}
export declare function createConverter(uriConverter?: URIConverter): Converter;
export declare const asTextDocumentIdentifier: (textDocument: code.TextDocument) => ls.TextDocumentIdentifier;
export declare const asOpenTextDocumentParams: (textDocument: code.TextDocument) => proto.DidOpenTextDocumentParams;
export declare const asChangeTextDocumentParams: (arg: code.TextDocumentChangeEvent | code.TextDocument) => proto.DidChangeTextDocumentParams;
export declare const asCloseTextDocumentParams: (textDocument: code.TextDocument) => proto.DidCloseTextDocumentParams;
export declare const asSaveTextDocumentParams: (textDocument: code.TextDocument) => proto.DidSaveTextDocumentParams;
export declare const asTextDocumentPositionParams: (textDocument: code.TextDocument, position: code.Position) => proto.TextDocumentPositionParams;
export declare const asWorkerPosition: (position: code.Position) => ls.Position;
export declare const asRange: (value: code.Range) => ls.Range;
export declare const asPosition: (value: code.Position) => ls.Position;
export declare const asDiagnosticSeverity: (value: code.DiagnosticSeverity) => ls.DiagnosticSeverity;
export declare const asDiagnostic: (item: code.Diagnostic) => ls.Diagnostic;
export declare const asDiagnostics: (items: code.Diagnostic[]) => ls.Diagnostic[];
export declare const asCompletionItem: (item: code.CompletionItem) => ls.CompletionItem;
export declare const asTextEdit: (edit: code.TextEdit) => ls.TextEdit;
export declare const asReferenceParams: (textDocument: code.TextDocument, position: code.Position, options: {
    includeDeclaration: boolean;
}) => proto.ReferenceParams;
export declare const asCodeActionContext: (context: code.CodeActionContext) => ls.CodeActionContext;
export declare const asCommand: (item: code.Command) => ls.Command;
export declare const asCodeLens: (item: code.CodeLens) => ls.CodeLens;
export declare const asFormattingOptions: (item: code.FormattingOptions) => ls.FormattingOptions;
export declare const asDocumentSymbolParams: (textDocument: code.TextDocument) => proto.DocumentSymbolParams;
export declare const asCodeLensParams: (textDocument: code.TextDocument) => proto.CodeLensParams;
