import * as cp from 'child_process';
import ChildProcess = cp.ChildProcess;
import { TextDocument, Disposable, OutputChannel, FileSystemWatcher, DiagnosticCollection, CancellationToken } from 'vscode';
import { Message, RequestHandler, NotificationHandler, ErrorCodes, ResponseError, RequestType, NotificationType, Trace, Event } from 'vscode-jsonrpc';
import { Range, Position, Location, TextEdit, WorkspaceChange, TextEditChange, TextDocumentIdentifier } from 'vscode-languageserver-types';
import { InitializeError, TextDocumentPositionParams } from './protocol';
import * as c2p from './codeConverter';
import * as p2c from './protocolConverter';
export { RequestType, NotificationType, NotificationHandler, RequestHandler, ResponseError, InitializeError, ErrorCodes, Position, Range, Location, TextDocumentIdentifier, TextDocumentPositionParams, TextEdit, TextEditChange, WorkspaceChange, c2p as Code2Protocol, p2c as Protocol2Code };
export interface StreamInfo {
    writer: NodeJS.WritableStream;
    reader: NodeJS.ReadableStream;
}
export interface ExecutableOptions {
    cwd?: string;
    stdio?: string | string[];
    env?: any;
    detached?: boolean;
}
export interface Executable {
    command: string;
    args?: string[];
    options?: ExecutableOptions;
}
export interface ForkOptions {
    cwd?: string;
    env?: any;
    encoding?: string;
    execArgv?: string[];
}
export declare enum TransportKind {
    stdio = 0,
    ipc = 1,
}
export interface NodeModule {
    module: string;
    transport?: TransportKind;
    args?: string[];
    runtime?: string;
    options?: ForkOptions;
}
export declare type ServerOptions = Executable | {
    run: Executable;
    debug: Executable;
} | {
    run: NodeModule;
    debug: NodeModule;
} | NodeModule | (() => Thenable<ChildProcess | StreamInfo>);
/**
 * An action to be performed when the connection is producing errors.
 */
export declare enum ErrorAction {
    /**
     * Continue running the server.
     */
    Continue = 1,
    /**
     * Shutdown the server.
     */
    Shutdown = 2,
}
/**
 * An action to be performed when the connection to a server got closed.
 */
export declare enum CloseAction {
    /**
     * Don't restart the server. The connection stays closed.
     */
    DoNotRestart = 1,
    /**
     * Restart the server.
     */
    Restart = 2,
}
/**
 * A pluggable error handler that is invoked when the connection is either
 * producing errors or got closed.
 */
export interface ErrorHandler {
    /**
     * An error has occurred while writing or reading from the connection.
     *
     * @param error - the error received
     * @param message - the message to be delivered to the server if know.
     * @param count - a count indicating how often an error is received. Will
     *  be reset if a message got successfully send or received.
     */
    error(error: Error, message: Message, count: number): ErrorAction;
    /**
     * The connection to the server got closed.
     */
    closed(): CloseAction;
}
export interface InitializationFailedHandler {
    (error: ResponseError<InitializeError> | Error | any): boolean;
}
export interface SynchronizeOptions {
    configurationSection?: string | string[];
    fileEvents?: FileSystemWatcher | FileSystemWatcher[];
    textDocumentFilter?: (textDocument: TextDocument) => boolean;
}
export declare enum RevealOutputChannelOn {
    Info = 1,
    Warn = 2,
    Error = 3,
    Never = 4,
}
export interface LanguageClientOptions {
    documentSelector?: string | string[];
    synchronize?: SynchronizeOptions;
    diagnosticCollectionName?: string;
    outputChannelName?: string;
    revealOutputChannelOn?: RevealOutputChannelOn;
    /**
     * The encoding use to read stdout and stderr. Defaults
     * to 'utf8' if ommitted.
     */
    stdioEncoding?: string;
    initializationOptions?: any | (() => any);
    initializationFailedHandler?: InitializationFailedHandler;
    errorHandler?: ErrorHandler;
    uriConverters?: {
        code2Protocol: c2p.URIConverter;
        protocol2Code: p2c.URIConverter;
    };
}
export declare enum State {
    Stopped = 1,
    Running = 2,
}
export interface StateChangeEvent {
    oldState: State;
    newState: State;
}
export declare class LanguageClient {
    private _id;
    private _name;
    private _serverOptions;
    private _clientOptions;
    private _forceDebug;
    private _state;
    private _onReady;
    private _onReadyCallbacks;
    private _connection;
    private _childProcess;
    private _outputChannel;
    private _capabilites;
    private _listeners;
    private _providers;
    private _diagnostics;
    private _syncExpression;
    private _documentSyncDelayer;
    private _fileEvents;
    private _fileEventDelayer;
    private _telemetryEmitter;
    private _stateChangeEmitter;
    private _trace;
    private _tracer;
    private _c2p;
    private _p2c;
    constructor(name: string, serverOptions: ServerOptions, clientOptions: LanguageClientOptions, forceDebug?: boolean);
    constructor(id: string, name: string, serverOptions: ServerOptions, clientOptions: LanguageClientOptions, forceDebug?: boolean);
    private state;
    private getPublicState();
    private computeSyncExpression();
    sendRequest<P, R, E>(type: RequestType<P, R, E>, params: P, token?: CancellationToken): Thenable<R>;
    private doSendRequest<P, R, E>(connection, type, params, token?);
    sendNotification<P>(type: NotificationType<P>, params?: P): void;
    onNotification<P>(type: NotificationType<P>, handler: NotificationHandler<P>): void;
    onRequest<P, R, E>(type: RequestType<P, R, E>, handler: RequestHandler<P, R, E>): void;
    onTelemetry: Event<any>;
    onDidChangeState: Event<StateChangeEvent>;
    outputChannel: OutputChannel;
    diagnostics: DiagnosticCollection;
    createDefaultErrorHandler(): ErrorHandler;
    trace: Trace;
    private data2String(data);
    info(message: string, data?: any): void;
    warn(message: string, data?: any): void;
    error(message: string, data?: any): void;
    private logTrace(message, data?);
    needsStart(): boolean;
    needsStop(): boolean;
    onReady(): Promise<void>;
    private isConnectionActive();
    start(): Disposable;
    private resolveConnection();
    private initialize(connection);
    stop(): Thenable<void>;
    private cleanUp(diagnostics?);
    private notifyConfigurationChanged(settings);
    private notifyFileEvent(event);
    private onDidOpenTextDoument(connection, textDocument);
    private onDidChangeTextDocument(connection, event);
    private onDidCloseTextDoument(connection, textDocument);
    private onDidSaveTextDocument(conneciton, textDocument);
    private forceDocumentSync();
    private handleDiagnostics(params);
    private createConnection();
    private handleConnectionClosed();
    private handleConnectionError(error, message, count);
    private checkProcessDied(childProcess);
    private hookConfigurationChanged(connection);
    private refreshTrace(connection, sendNotification?);
    private onDidChangeConfiguration(connection);
    private extractSettingsInformation(keys);
    private hookFileEvents(connection);
    private hookCapabilities(connection);
    private logFailedRequest(type, error);
    private hookCompletionProvider(documentSelector, connection);
    private hookHoverProvider(documentSelector, connection);
    private hookSignatureHelpProvider(documentSelector, connection);
    private hookDefinitionProvider(documentSelector, connection);
    private hookReferencesProvider(documentSelector, connection);
    private hookDocumentHighlightProvider(documentSelector, connection);
    private hookDocumentSymbolProvider(documentSelector, connection);
    private hookWorkspaceSymbolProvider(connection);
    private hookCodeActionsProvider(documentSelector, connection);
    private hookCodeLensProvider(documentSelector, connection);
    private hookDocumentFormattingProvider(documentSelector, connection);
    private hookDocumentRangeFormattingProvider(documentSelector, connection);
    private hookDocumentOnTypeFormattingProvider(documentSelector, connection);
    private hookRenameProvider(documentSelector, connection);
    private hookDocumentLinkProvider(documentSelector, connection);
}
export declare class SettingMonitor {
    private _client;
    private _setting;
    private _listeners;
    constructor(_client: LanguageClient, _setting: string);
    start(): Disposable;
    private onDidChangeConfiguration();
}
