import * as code from 'vscode';
import * as ls from 'vscode-languageserver-types';
import ProtocolCompletionItem from './protocolCompletionItem';
export interface Converter {
    asUri(value: string): code.Uri;
    asDiagnostics(diagnostics: ls.Diagnostic[]): code.Diagnostic[];
    asDiagnostic(diagnostic: ls.Diagnostic): code.Diagnostic;
    asRange(value: ls.Range): code.Range;
    asPosition(value: ls.Position): code.Position;
    asDiagnosticSeverity(value: number): code.DiagnosticSeverity;
    asHover(hover: ls.Hover): code.Hover;
    asCompletionResult(result: ls.CompletionItem[] | ls.CompletionList): code.CompletionItem[] | code.CompletionList;
    asCompletionItem(item: ls.CompletionItem): ProtocolCompletionItem;
    asTextEdit(edit: ls.TextEdit): code.TextEdit;
    asTextEdits(items: ls.TextEdit[]): code.TextEdit[];
    asSignatureHelp(item: ls.SignatureHelp): code.SignatureHelp;
    asSignatureInformations(items: ls.SignatureInformation[]): code.SignatureInformation[];
    asSignatureInformation(item: ls.SignatureInformation): code.SignatureInformation;
    asParameterInformations(item: ls.ParameterInformation[]): code.ParameterInformation[];
    asParameterInformation(item: ls.ParameterInformation): code.ParameterInformation;
    asDefinitionResult(item: ls.Definition): code.Definition;
    asLocation(item: ls.Location): code.Location;
    asReferences(values: ls.Location[]): code.Location[];
    asDocumentHighlights(values: ls.DocumentHighlight[]): code.DocumentHighlight[];
    asDocumentHighlight(item: ls.DocumentHighlight): code.DocumentHighlight;
    asDocumentHighlightKind(item: ls.DocumentHighlightKind): code.DocumentHighlightKind;
    asSymbolInformations(values: ls.SymbolInformation[], uri?: code.Uri): code.SymbolInformation[];
    asSymbolInformation(item: ls.SymbolInformation, uri?: code.Uri): code.SymbolInformation;
    asCommand(item: ls.Command): code.Command;
    asCommands(items: ls.Command[]): code.Command[];
    asCodeLens(item: ls.CodeLens): code.CodeLens;
    asCodeLenses(items: ls.CodeLens[]): code.CodeLens[];
    asWorkspaceEdit(item: ls.WorkspaceEdit): code.WorkspaceEdit;
    asDocumentLink(item: ls.DocumentLink): code.DocumentLink;
    asDocumentLinks(items: ls.DocumentLink[]): code.DocumentLink[];
}
export interface URIConverter {
    (value: string): code.Uri;
}
export declare function createConverter(uriConverter?: URIConverter): Converter;
export declare const asDiagnostics: (diagnostics: ls.Diagnostic[]) => code.Diagnostic[];
export declare const asDiagnostic: (diagnostic: ls.Diagnostic) => code.Diagnostic;
export declare const asRange: (value: ls.Range) => code.Range;
export declare const asPosition: (value: ls.Position) => code.Position;
export declare const asDiagnosticSeverity: (value: number) => code.DiagnosticSeverity;
export declare const asHover: (hover: ls.Hover) => code.Hover;
export declare const asCompletionResult: (result: ls.CompletionItem[] | ls.CompletionList) => code.CompletionItem[] | code.CompletionList;
export declare const asCompletionItem: (item: ls.CompletionItem) => ProtocolCompletionItem;
export declare const asTextEdit: (edit: ls.TextEdit) => code.TextEdit;
export declare const asTextEdits: (items: ls.TextEdit[]) => code.TextEdit[];
export declare const asSignatureHelp: (item: ls.SignatureHelp) => code.SignatureHelp;
export declare const asSignatureInformations: (items: ls.SignatureInformation[]) => code.SignatureInformation[];
export declare const asSignatureInformation: (item: ls.SignatureInformation) => code.SignatureInformation;
export declare const asParameterInformations: (item: ls.ParameterInformation[]) => code.ParameterInformation[];
export declare const asParameterInformation: (item: ls.ParameterInformation) => code.ParameterInformation;
export declare const asDefinitionResult: (item: ls.Definition) => code.Definition;
export declare const asLocation: (item: ls.Location) => code.Location;
export declare const asReferences: (values: ls.Location[]) => code.Location[];
export declare const asDocumentHighlights: (values: ls.DocumentHighlight[]) => code.DocumentHighlight[];
export declare const asDocumentHighlight: (item: ls.DocumentHighlight) => code.DocumentHighlight;
export declare const asDocumentHighlightKind: (item: ls.DocumentHighlightKind) => code.DocumentHighlightKind;
export declare const asSymbolInformations: (values: ls.SymbolInformation[], uri?: code.Uri) => code.SymbolInformation[];
export declare const asSymbolInformation: (item: ls.SymbolInformation, uri?: code.Uri) => code.SymbolInformation;
export declare const asCommand: (item: ls.Command) => code.Command;
export declare const asCommands: (items: ls.Command[]) => code.Command[];
export declare const asCodeLens: (item: ls.CodeLens) => code.CodeLens;
export declare const asCodeLenses: (items: ls.CodeLens[]) => code.CodeLens[];
export declare const asWorkspaceEdit: (item: ls.WorkspaceEdit) => code.WorkspaceEdit;
export declare const asDocumentLink: (item: ls.DocumentLink) => code.DocumentLink;
export declare const asDocumentLinks: (item: ls.DocumentLink[]) => code.DocumentLink[];
