/// <reference types="node" />
import { ChildProcess } from 'child_process';
import { Socket } from 'net';
import { Message } from './messages';
import { Event } from './events';
export interface MessageWriter {
    readonly onError: Event<[Error, Message | undefined, number | undefined]>;
    readonly onClose: Event<void>;
    write(msg: Message): void;
}
export declare abstract class AbstractMessageWriter {
    private errorEmitter;
    private closeEmitter;
    constructor();
    readonly onError: Event<[Error, Message, number]>;
    protected fireError(error: any, message?: Message, count?: number): void;
    readonly onClose: Event<void>;
    protected fireClose(): void;
    private asError(error);
}
export declare class StreamMessageWriter extends AbstractMessageWriter implements MessageWriter {
    private writable;
    private encoding;
    private errorCount;
    constructor(writable: NodeJS.WritableStream, encoding?: string);
    write(msg: Message): void;
}
export declare class IPCMessageWriter extends AbstractMessageWriter implements MessageWriter {
    private process;
    private queue;
    private sending;
    private errorCount;
    constructor(process: NodeJS.Process | ChildProcess);
    write(msg: Message): void;
    doWriteMessage(msg: Message): void;
}
export declare class SocketMessageWriter extends AbstractMessageWriter implements MessageWriter {
    private socket;
    private queue;
    private sending;
    private encoding;
    private errorCount;
    constructor(socket: Socket, encoding?: string);
    write(msg: Message): void;
    doWriteMessage(msg: Message): void;
    private handleError(error, msg);
}
