/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var is = require("./is");
/**
 * Predefined error codes.
 */
var ErrorCodes;
(function (ErrorCodes) {
    // Defined by JSON RPC
    ErrorCodes.ParseError = -32700;
    ErrorCodes.InvalidRequest = -32600;
    ErrorCodes.MethodNotFound = -32601;
    ErrorCodes.InvalidParams = -32602;
    ErrorCodes.InternalError = -32603;
    ErrorCodes.serverErrorStart = -32099;
    ErrorCodes.serverErrorEnd = -32000;
    ErrorCodes.ServerNotInitialized = -32002;
    ErrorCodes.UnknownErrorCode = -32001;
    // Defined by the protocol.
    ErrorCodes.RequestCancelled = -32800;
    // Defined by VSCode library.
    ErrorCodes.MessageWriteError = 1;
    ErrorCodes.MessageReadError = 2;
})(ErrorCodes = exports.ErrorCodes || (exports.ErrorCodes = {}));
/**
 * A error object return in a response in case a request
 * has failed.
 */
var ResponseError = (function (_super) {
    __extends(ResponseError, _super);
    function ResponseError(code, message, data) {
        var _this = _super.call(this, message) || this;
        _this.code = is.number(code) ? code : ErrorCodes.UnknownErrorCode;
        if (data !== void 0) {
            _this.data = data;
        }
        Object.setPrototypeOf(_this, ResponseError.prototype);
        return _this;
    }
    ResponseError.prototype.toJson = function () {
        var result = {
            code: this.code,
            message: this.message
        };
        if (this.data !== void 0) {
            result.data = this.data;
        }
        ;
        return result;
    };
    return ResponseError;
}(Error));
exports.ResponseError = ResponseError;
/**
 * An abstract implementation of a MessageType.
 */
var AbstractMessageType = (function () {
    function AbstractMessageType(_method, _numberOfParams) {
        this._method = _method;
        this._numberOfParams = _numberOfParams;
    }
    Object.defineProperty(AbstractMessageType.prototype, "method", {
        get: function () {
            return this._method;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AbstractMessageType.prototype, "numberOfParams", {
        get: function () {
            return this._numberOfParams;
        },
        enumerable: true,
        configurable: true
    });
    return AbstractMessageType;
}());
exports.AbstractMessageType = AbstractMessageType;
/**
 * Classes to type request response pairs
 */
var RequestType0 = (function (_super) {
    __extends(RequestType0, _super);
    function RequestType0(method) {
        var _this = _super.call(this, method, 0) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType0;
}(AbstractMessageType));
exports.RequestType0 = RequestType0;
var RequestType = (function (_super) {
    __extends(RequestType, _super);
    function RequestType(method) {
        var _this = _super.call(this, method, 1) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType;
}(AbstractMessageType));
exports.RequestType = RequestType;
var RequestType1 = (function (_super) {
    __extends(RequestType1, _super);
    function RequestType1(method) {
        var _this = _super.call(this, method, 1) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType1;
}(AbstractMessageType));
exports.RequestType1 = RequestType1;
var RequestType2 = (function (_super) {
    __extends(RequestType2, _super);
    function RequestType2(method) {
        var _this = _super.call(this, method, 2) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType2;
}(AbstractMessageType));
exports.RequestType2 = RequestType2;
var RequestType3 = (function (_super) {
    __extends(RequestType3, _super);
    function RequestType3(method) {
        var _this = _super.call(this, method, 3) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType3;
}(AbstractMessageType));
exports.RequestType3 = RequestType3;
var RequestType4 = (function (_super) {
    __extends(RequestType4, _super);
    function RequestType4(method) {
        var _this = _super.call(this, method, 4) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType4;
}(AbstractMessageType));
exports.RequestType4 = RequestType4;
var RequestType5 = (function (_super) {
    __extends(RequestType5, _super);
    function RequestType5(method) {
        var _this = _super.call(this, method, 5) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType5;
}(AbstractMessageType));
exports.RequestType5 = RequestType5;
var RequestType6 = (function (_super) {
    __extends(RequestType6, _super);
    function RequestType6(method) {
        var _this = _super.call(this, method, 6) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType6;
}(AbstractMessageType));
exports.RequestType6 = RequestType6;
var RequestType7 = (function (_super) {
    __extends(RequestType7, _super);
    function RequestType7(method) {
        var _this = _super.call(this, method, 7) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType7;
}(AbstractMessageType));
exports.RequestType7 = RequestType7;
var RequestType8 = (function (_super) {
    __extends(RequestType8, _super);
    function RequestType8(method) {
        var _this = _super.call(this, method, 8) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType8;
}(AbstractMessageType));
exports.RequestType8 = RequestType8;
var RequestType9 = (function (_super) {
    __extends(RequestType9, _super);
    function RequestType9(method) {
        var _this = _super.call(this, method, 9) || this;
        _this._ = undefined;
        return _this;
    }
    return RequestType9;
}(AbstractMessageType));
exports.RequestType9 = RequestType9;
var NotificationType = (function (_super) {
    __extends(NotificationType, _super);
    function NotificationType(method) {
        var _this = _super.call(this, method, 1) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType;
}(AbstractMessageType));
exports.NotificationType = NotificationType;
var NotificationType0 = (function (_super) {
    __extends(NotificationType0, _super);
    function NotificationType0(method) {
        var _this = _super.call(this, method, 0) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType0;
}(AbstractMessageType));
exports.NotificationType0 = NotificationType0;
var NotificationType1 = (function (_super) {
    __extends(NotificationType1, _super);
    function NotificationType1(method) {
        var _this = _super.call(this, method, 1) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType1;
}(AbstractMessageType));
exports.NotificationType1 = NotificationType1;
var NotificationType2 = (function (_super) {
    __extends(NotificationType2, _super);
    function NotificationType2(method) {
        var _this = _super.call(this, method, 2) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType2;
}(AbstractMessageType));
exports.NotificationType2 = NotificationType2;
var NotificationType3 = (function (_super) {
    __extends(NotificationType3, _super);
    function NotificationType3(method) {
        var _this = _super.call(this, method, 3) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType3;
}(AbstractMessageType));
exports.NotificationType3 = NotificationType3;
var NotificationType4 = (function (_super) {
    __extends(NotificationType4, _super);
    function NotificationType4(method) {
        var _this = _super.call(this, method, 4) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType4;
}(AbstractMessageType));
exports.NotificationType4 = NotificationType4;
var NotificationType5 = (function (_super) {
    __extends(NotificationType5, _super);
    function NotificationType5(method) {
        var _this = _super.call(this, method, 5) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType5;
}(AbstractMessageType));
exports.NotificationType5 = NotificationType5;
var NotificationType6 = (function (_super) {
    __extends(NotificationType6, _super);
    function NotificationType6(method) {
        var _this = _super.call(this, method, 6) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType6;
}(AbstractMessageType));
exports.NotificationType6 = NotificationType6;
var NotificationType7 = (function (_super) {
    __extends(NotificationType7, _super);
    function NotificationType7(method) {
        var _this = _super.call(this, method, 7) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType7;
}(AbstractMessageType));
exports.NotificationType7 = NotificationType7;
var NotificationType8 = (function (_super) {
    __extends(NotificationType8, _super);
    function NotificationType8(method) {
        var _this = _super.call(this, method, 8) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType8;
}(AbstractMessageType));
exports.NotificationType8 = NotificationType8;
var NotificationType9 = (function (_super) {
    __extends(NotificationType9, _super);
    function NotificationType9(method) {
        var _this = _super.call(this, method, 9) || this;
        _this._ = undefined;
        return _this;
    }
    return NotificationType9;
}(AbstractMessageType));
exports.NotificationType9 = NotificationType9;
/**
 * Tests if the given message is a request message
 */
function isRequestMessage(message) {
    var candidate = message;
    return candidate && is.string(candidate.method) && (is.string(candidate.id) || is.number(candidate.id));
}
exports.isRequestMessage = isRequestMessage;
/**
 * Tests if the given message is a notification message
 */
function isNotificationMessage(message) {
    var candidate = message;
    return candidate && is.string(candidate.method) && message.id === void 0;
}
exports.isNotificationMessage = isNotificationMessage;
/**
 * Tests if the given message is a response message
 */
function isReponseMessage(message) {
    var candidate = message;
    return candidate && (candidate.result !== void 0 || !!candidate.error) && (is.string(candidate.id) || is.number(candidate.id) || candidate.id === null);
}
exports.isReponseMessage = isReponseMessage;
