import { TextDocument, Position, CompletionItem, CompletionList, Hover, Range, SymbolInformation, Diagnostic, TextEdit, DocumentHighlight, FormattingOptions, MarkedString, DocumentLink } from 'vscode-languageserver-types';
export { TextDocument, Position, CompletionItem, CompletionList, Hover, Range, SymbolInformation, Diagnostic, TextEdit, DocumentHighlight, FormattingOptions, MarkedString, DocumentLink };
export interface HTMLFormatConfiguration {
    tabSize?: number;
    insertSpaces?: boolean;
    wrapLineLength?: number;
    unformatted?: string;
    contentUnformatted?: string;
    indentInnerHtml?: boolean;
    wrapAttributes?: 'auto' | 'force' | 'force-aligned' | 'force-expand-multiline';
    preserveNewLines?: boolean;
    maxPreserveNewLines?: number;
    indentHandlebars?: boolean;
    endWithNewline?: boolean;
    extraLiners?: string;
}
export interface CompletionConfiguration {
    [provider: string]: boolean;
}
export interface Node {
    tag: string;
    start: number;
    end: number;
    endTagStart: number;
    children: Node[];
    parent: Node;
    attributes?: {
        [name: string]: string;
    };
}
export declare enum TokenType {
    StartCommentTag = 0,
    Comment = 1,
    EndCommentTag = 2,
    StartTagOpen = 3,
    StartTagClose = 4,
    StartTagSelfClose = 5,
    StartTag = 6,
    EndTagOpen = 7,
    EndTagClose = 8,
    EndTag = 9,
    DelimiterAssign = 10,
    AttributeName = 11,
    AttributeValue = 12,
    StartDoctypeTag = 13,
    Doctype = 14,
    EndDoctypeTag = 15,
    Content = 16,
    Whitespace = 17,
    Unknown = 18,
    Script = 19,
    Styles = 20,
    EOS = 21,
}
export declare enum ScannerState {
    WithinContent = 0,
    AfterOpeningStartTag = 1,
    AfterOpeningEndTag = 2,
    WithinDoctype = 3,
    WithinTag = 4,
    WithinEndTag = 5,
    WithinComment = 6,
    WithinScriptContent = 7,
    WithinStyleContent = 8,
    AfterAttributeName = 9,
    BeforeAttributeValue = 10,
}
export interface Scanner {
    scan(): TokenType;
    getTokenType(): TokenType;
    getTokenOffset(): number;
    getTokenLength(): number;
    getTokenEnd(): number;
    getTokenText(): string;
    getTokenError(): string;
    getScannerState(): ScannerState;
}
export declare type HTMLDocument = {
    roots: Node[];
    findNodeBefore(offset: number): Node;
    findNodeAt(offset: number): Node;
};
export interface DocumentContext {
    resolveReference(ref: string, base?: string): string;
}
export interface LanguageService {
    createScanner(input: string): Scanner;
    parseHTMLDocument(document: TextDocument): HTMLDocument;
    findDocumentHighlights(document: TextDocument, position: Position, htmlDocument: HTMLDocument): DocumentHighlight[];
    doComplete(document: TextDocument, position: Position, htmlDocument: HTMLDocument, options?: CompletionConfiguration): CompletionList;
    doHover(document: TextDocument, position: Position, htmlDocument: HTMLDocument): Hover;
    format(document: TextDocument, range: Range, options: HTMLFormatConfiguration): TextEdit[];
    findDocumentLinks(document: TextDocument, documentContext: DocumentContext): DocumentLink[];
    findDocumentSymbols(document: TextDocument, htmlDocument: HTMLDocument): SymbolInformation[];
}
export declare function getLanguageService(): LanguageService;
