export declare enum TokenType {
    StartCommentTag = 0,
    Comment = 1,
    EndCommentTag = 2,
    StartTagOpen = 3,
    StartTagClose = 4,
    StartTagSelfClose = 5,
    StartTag = 6,
    EndTagOpen = 7,
    EndTagClose = 8,
    EndTag = 9,
    DelimiterAssign = 10,
    AttributeName = 11,
    AttributeValue = 12,
    StartDoctypeTag = 13,
    Doctype = 14,
    EndDoctypeTag = 15,
    Content = 16,
    Whitespace = 17,
    Unknown = 18,
    Script = 19,
    Styles = 20,
    EOS = 21,
}
export declare enum ScannerState {
    WithinContent = 0,
    AfterOpeningStartTag = 1,
    AfterOpeningEndTag = 2,
    WithinDoctype = 3,
    WithinTag = 4,
    WithinEndTag = 5,
    WithinComment = 6,
    WithinScriptContent = 7,
    WithinStyleContent = 8,
    AfterAttributeName = 9,
    BeforeAttributeValue = 10,
}
export interface Scanner {
    scan(): TokenType;
    getTokenType(): TokenType;
    getTokenOffset(): number;
    getTokenLength(): number;
    getTokenEnd(): number;
    getTokenText(): string;
    getTokenError(): string;
    getScannerState(): ScannerState;
}
export declare function createScanner(input: string, initialOffset?: number, initialState?: ScannerState): Scanner;
