(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../parser/htmlTags", "../parser/razorTags"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    var htmlTags_1 = require("../parser/htmlTags");
    var razorTags_1 = require("../parser/razorTags");
    exports.allTagProviders = [
        htmlTags_1.getHTML5TagProvider(),
        htmlTags_1.getAngularTagProvider(),
        htmlTags_1.getIonicTagProvider(),
        razorTags_1.getRazorTagProvider()
    ];
});
//# sourceMappingURL=tagProviders.js.map