(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "assert", "../htmlLanguageService", "vscode-languageserver-types"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    var assert = require("assert");
    var htmlLanguageService = require("../htmlLanguageService");
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    suite('JSON Document Symbols', function () {
        function getOutline(value) {
            var ls = htmlLanguageService.getLanguageService();
            var uri = 'test://test.json';
            var document = vscode_languageserver_types_1.TextDocument.create(uri, 'json', 0, value);
            var htmlDoc = ls.parseHTMLDocument(document);
            return htmlLanguageService.getLanguageService().findDocumentSymbols(document, htmlDoc);
        }
        function assertOutline(value, expected, message) {
            var actual = getOutline(value);
            assert.equal(actual.length, expected.length, message);
            for (var i = 0; i < expected.length; i++) {
                assert.equal(actual[i].name, expected[i].label, message);
                assert.equal(actual[i].kind, expected[i].kind, message);
                assert.equal(actual[i].containerName, expected[i].containerName, message);
            }
        }
        ;
        test('No attrib', function () {
            var content = '<html><body><div></div></body></html>';
            var expected = [
                { label: 'html', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: '' },
                { label: 'body', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: 'html' },
                { label: 'div', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: 'body' }
            ];
            assertOutline(content, expected);
        });
        test('Id and classes', function () {
            var content = '<html id=\'root\'><body id="Foo" class="bar"><div class="a b"></div></body></html>';
            var expected = [
                { label: 'html#root', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: '' },
                { label: 'body#Foo.bar', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: 'html#root' },
                { label: 'div.a.b', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: 'body#Foo.bar' },
            ];
            assertOutline(content, expected);
        });
        test('Self closing', function () {
            var content = '<html><br id="Foo"><br id=Bar></html>';
            var expected = [
                { label: 'html', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: '' },
                { label: 'br#Foo', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: 'html' },
                { label: 'br#Bar', kind: vscode_languageserver_types_1.SymbolKind.Field, containerName: 'html' },
            ];
            assertOutline(content, expected);
        });
    });
});
//# sourceMappingURL=documentSymbols.test.js.map