(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "../htmlLanguageService", "assert", "./textEditSupport"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var htmlLanguageService_1 = require("../htmlLanguageService");
    var assert = require("assert");
    var textEditSupport_1 = require("./textEditSupport");
    suite('JSON Formatter', function () {
        function format(unformatted, expected, insertSpaces) {
            if (insertSpaces === void 0) { insertSpaces = true; }
            var range = null;
            var uri = 'test://test.html';
            var rangeStart = unformatted.indexOf('|');
            var rangeEnd = unformatted.lastIndexOf('|');
            if (rangeStart !== -1 && rangeEnd !== -1) {
                // remove '|'
                unformatted = unformatted.substring(0, rangeStart) + unformatted.substring(rangeStart + 1, rangeEnd) + unformatted.substring(rangeEnd + 1);
                var unformattedDoc = vscode_languageserver_types_1.TextDocument.create(uri, 'html', 0, unformatted);
                var startPos = unformattedDoc.positionAt(rangeStart);
                var endPos = unformattedDoc.positionAt(rangeEnd - 1);
                range = vscode_languageserver_types_1.Range.create(startPos, endPos);
            }
            var document = vscode_languageserver_types_1.TextDocument.create(uri, 'html', 0, unformatted);
            var edits = htmlLanguageService_1.getLanguageService().format(document, range, { tabSize: 2, insertSpaces: insertSpaces, unformatted: '' });
            var formatted = textEditSupport_1.applyEdits(document, edits);
            assert.equal(formatted, expected);
        }
        test('full document', function () {
            var content = [
                '<div  class = "foo">',
                '<br>',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div class="foo">',
                '  <br>',
                '</div>',
            ].join('\n');
            format(content, expected);
        });
        test('range', function () {
            var content = [
                '<div  class = "foo">',
                '  |<img  src = "foo">|',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div  class = "foo">',
                '  <img src="foo">',
                ' </div>'
            ].join('\n');
            format(content, expected);
        });
        test('range 2', function () {
            var content = [
                '<div  class = "foo">',
                '  |<img  src = "foo">|',
                '  ',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div  class = "foo">',
                '  <img src="foo">',
                '  ',
                ' </div>'
            ].join('\n');
            format(content, expected);
        });
        test('range 3', function () {
            var content = [
                '<div  class = "foo">',
                '  |<img  src = "foo">|    ',
                '  ',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div  class = "foo">',
                '  <img src="foo">',
                '  ',
                ' </div>'
            ].join('\n');
            format(content, expected);
        });
        test('range with indent', function () {
            var content = [
                '<div  class = "foo">',
                '  |<img src = "foo">',
                '  <img  src = "foo">|',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div  class = "foo">',
                '  <img src="foo">',
                '  <img src="foo">',
                ' </div>'
            ].join('\n');
            format(content, expected);
        });
        test('range with indent 2', function () {
            var content = [
                '<div  class = "foo">',
                '|  <img  src = "foo">',
                '  <img  src = "foo">|',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div  class = "foo">',
                '  <img src="foo">',
                '  <img src="foo">',
                ' </div>'
            ].join('\n');
            format(content, expected);
        });
        test('range with indent 3', function () {
            var content = [
                '<div  class = "foo">',
                '  <div></div>   |<img  src = "foo"|>',
                ' </div>'
            ].join('\n');
            var expected = [
                '<div  class = "foo">',
                '  <div></div><img src="foo">',
                ' </div>'
            ].join('\n');
            format(content, expected);
        });
    });
});
//# sourceMappingURL=formatter.test.js.map