(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "assert", "../htmlLanguageService", "vscode-languageserver-types"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    var assert = require("assert");
    var htmlLanguageService = require("../htmlLanguageService");
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    suite('HTML Hover', function () {
        function assertHover(value, expectedHoverLabel, expectedHoverOffset) {
            var offset = value.indexOf('|');
            value = value.substr(0, offset) + value.substr(offset + 1);
            var document = vscode_languageserver_types_1.TextDocument.create('test://test/test.html', 'html', 0, value);
            var position = document.positionAt(offset);
            var ls = htmlLanguageService.getLanguageService();
            var htmlDoc = ls.parseHTMLDocument(document);
            var hover = ls.doHover(document, position, htmlDoc);
            assert.equal(hover && hover.contents[0].value, expectedHoverLabel);
            assert.equal(hover && document.offsetAt(hover.range.start), expectedHoverOffset);
        }
        test('Single', function () {
            assertHover('|<html></html>', void 0, void 0);
            assertHover('<|html></html>', '<html>', 1);
            assertHover('<h|tml></html>', '<html>', 1);
            assertHover('<htm|l></html>', '<html>', 1);
            assertHover('<html|></html>', '<html>', 1);
            assertHover('<html>|</html>', void 0, void 0);
            assertHover('<html><|/html>', void 0, void 0);
            assertHover('<html></|html>', '</html>', 8);
            assertHover('<html></h|tml>', '</html>', 8);
            assertHover('<html></ht|ml>', '</html>', 8);
            assertHover('<html></htm|l>', '</html>', 8);
            assertHover('<html></html|>', '</html>', 8);
            assertHover('<html></html>|', void 0, void 0);
        });
    });
});
//# sourceMappingURL=hover.test.js.map