import * as code from 'vscode';
import * as types from 'vscode-languageserver-types';
import * as proto from './protocol';
export interface Converter {
    asUri(uri: code.Uri): string;
    asTextDocumentIdentifier(textDocument: code.TextDocument): types.TextDocumentIdentifier;
    asOpenTextDocumentParams(textDocument: code.TextDocument): proto.DidOpenTextDocumentParams;
    asChangeTextDocumentParams(textDocument: code.TextDocument): proto.DidChangeTextDocumentParams;
    asChangeTextDocumentParams(event: code.TextDocumentChangeEvent): proto.DidChangeTextDocumentParams;
    asCloseTextDocumentParams(textDocument: code.TextDocument): proto.DidCloseTextDocumentParams;
    asSaveTextDocumentParams(textDocument: code.TextDocument, includeContent?: boolean): proto.DidSaveTextDocumentParams;
    asWillSaveTextDocumentParams(event: code.TextDocumentWillSaveEvent): proto.WillSaveTextDocumentParams;
    asTextDocumentPositionParams(textDocument: code.TextDocument, position: code.Position): proto.TextDocumentPositionParams;
    asWorkerPosition(position: code.Position): types.Position;
    asPosition(value: code.Position): types.Position;
    asPosition(value: undefined): undefined;
    asPosition(value: null): null;
    asPosition(value: code.Position | undefined | null): types.Position | undefined | null;
    asRange(value: code.Range): types.Range;
    asRange(value: undefined): undefined;
    asRange(value: null): null;
    asRange(value: code.Range | undefined | null): types.Range | undefined | null;
    asDiagnosticSeverity(value: code.DiagnosticSeverity): number;
    asDiagnostic(item: code.Diagnostic): types.Diagnostic;
    asDiagnostics(items: code.Diagnostic[]): types.Diagnostic[];
    asCompletionItem(item: code.CompletionItem): types.CompletionItem;
    asTextEdit(edit: code.TextEdit): types.TextEdit;
    asReferenceParams(textDocument: code.TextDocument, position: code.Position, options: {
        includeDeclaration: boolean;
    }): proto.ReferenceParams;
    asCodeActionContext(context: code.CodeActionContext): types.CodeActionContext;
    asCommand(item: code.Command): types.Command;
    asCodeLens(item: code.CodeLens): types.CodeLens;
    asFormattingOptions(item: code.FormattingOptions): types.FormattingOptions;
    asDocumentSymbolParams(textDocument: code.TextDocument): types.DocumentSymbolParams;
    asCodeLensParams(textDocument: code.TextDocument): proto.CodeLensParams;
    asDocumentLink(item: code.DocumentLink): types.DocumentLink;
    asDocumentLinkParams(textDocument: code.TextDocument): proto.DocumentLinkParams;
}
export interface URIConverter {
    (value: code.Uri): string;
}
export declare function createConverter(uriConverter?: URIConverter): Converter;
