/// <reference types="node" />
import * as cp from 'child_process';
import ChildProcess = cp.ChildProcess;
import { Disposable, OutputChannel, FileSystemWatcher, DiagnosticCollection, CancellationToken } from 'vscode';
import { Message, MessageType as RPCMessageType, ErrorCodes, ResponseError, RequestType, RequestType0, RequestHandler, RequestHandler0, GenericRequestHandler, NotificationType, NotificationType0, NotificationHandler, NotificationHandler0, GenericNotificationHandler, Trace, Event } from 'vscode-jsonrpc';
import { InitializeError, DocumentSelector } from './protocol';
import * as c2p from './codeConverter';
import * as p2c from './protocolConverter';
export { ResponseError, InitializeError, ErrorCodes, RequestType, RequestType0, RequestHandler, RequestHandler0, GenericRequestHandler, NotificationType, NotificationType0, NotificationHandler, NotificationHandler0, GenericNotificationHandler };
export { Converter as Code2ProtocolConverter } from './codeConverter';
export { Converter as Protocol2CodeConverter } from './protocolConverter';
export * from 'vscode-languageserver-types';
export * from './protocol';
export interface StreamInfo {
    writer: NodeJS.WritableStream;
    reader: NodeJS.ReadableStream;
}
export interface ExecutableOptions {
    cwd?: string;
    stdio?: string | string[];
    env?: any;
    detached?: boolean;
}
export interface Executable {
    command: string;
    args?: string[];
    options?: ExecutableOptions;
}
export interface ForkOptions {
    cwd?: string;
    env?: any;
    encoding?: string;
    execArgv?: string[];
}
export declare enum TransportKind {
    stdio = 0,
    ipc = 1,
    pipe = 2,
}
export interface NodeModule {
    module: string;
    transport?: TransportKind;
    args?: string[];
    runtime?: string;
    options?: ForkOptions;
}
export declare type ServerOptions = Executable | {
    run: Executable;
    debug: Executable;
} | {
    run: NodeModule;
    debug: NodeModule;
} | NodeModule | (() => Thenable<ChildProcess | StreamInfo>);
/**
 * An action to be performed when the connection is producing errors.
 */
export declare enum ErrorAction {
    /**
     * Continue running the server.
     */
    Continue = 1,
    /**
     * Shutdown the server.
     */
    Shutdown = 2,
}
/**
 * An action to be performed when the connection to a server got closed.
 */
export declare enum CloseAction {
    /**
     * Don't restart the server. The connection stays closed.
     */
    DoNotRestart = 1,
    /**
     * Restart the server.
     */
    Restart = 2,
}
/**
 * A pluggable error handler that is invoked when the connection is either
 * producing errors or got closed.
 */
export interface ErrorHandler {
    /**
     * An error has occurred while writing or reading from the connection.
     *
     * @param error - the error received
     * @param message - the message to be delivered to the server if know.
     * @param count - a count indicating how often an error is received. Will
     *  be reset if a message got successfully send or received.
     */
    error(error: Error, message: Message, count: number): ErrorAction;
    /**
     * The connection to the server got closed.
     */
    closed(): CloseAction;
}
export interface InitializationFailedHandler {
    (error: ResponseError<InitializeError> | Error | any): boolean;
}
export interface SynchronizeOptions {
    configurationSection?: string | string[];
    fileEvents?: FileSystemWatcher | FileSystemWatcher[];
}
export declare enum RevealOutputChannelOn {
    Info = 1,
    Warn = 2,
    Error = 3,
    Never = 4,
}
export interface LanguageClientOptions {
    documentSelector?: DocumentSelector | string[];
    synchronize?: SynchronizeOptions;
    diagnosticCollectionName?: string;
    outputChannelName?: string;
    revealOutputChannelOn?: RevealOutputChannelOn;
    /**
     * The encoding use to read stdout and stderr. Defaults
     * to 'utf8' if ommitted.
     */
    stdioEncoding?: string;
    initializationOptions?: any | (() => any);
    initializationFailedHandler?: InitializationFailedHandler;
    errorHandler?: ErrorHandler;
    uriConverters?: {
        code2Protocol: c2p.URIConverter;
        protocol2Code: p2c.URIConverter;
    };
}
export declare enum State {
    Stopped = 1,
    Running = 2,
}
export interface StateChangeEvent {
    oldState: State;
    newState: State;
}
export declare class LanguageClient {
    private _id;
    private _name;
    private _serverOptions;
    private _clientOptions;
    private _forceDebug;
    private _state;
    private _onReady;
    private _onReadyCallbacks;
    private _connectionPromise;
    private _resolvedConnection;
    private _childProcess;
    private _outputChannel;
    private _capabilites;
    private _listeners;
    private _providers;
    private _diagnostics;
    private _fileEvents;
    private _fileEventDelayer;
    private _telemetryEmitter;
    private _stateChangeEmitter;
    private _trace;
    private _tracer;
    private _c2p;
    private _p2c;
    constructor(name: string, serverOptions: ServerOptions, clientOptions: LanguageClientOptions, forceDebug?: boolean);
    constructor(id: string, name: string, serverOptions: ServerOptions, clientOptions: LanguageClientOptions, forceDebug?: boolean);
    private state;
    private getPublicState();
    sendRequest<R, E, RO>(type: RequestType0<R, E, RO>, token?: CancellationToken): Thenable<R>;
    sendRequest<P, R, E, RO>(type: RequestType<P, R, E, RO>, params: P, token?: CancellationToken): Thenable<R>;
    sendRequest<R>(method: string, token?: CancellationToken): Thenable<R>;
    sendRequest<R>(method: string, param: any, token?: CancellationToken): Thenable<R>;
    onRequest<R, E, RO>(type: RequestType0<R, E, RO>, handler: RequestHandler0<R, E>): void;
    onRequest<P, R, E, RO>(type: RequestType<P, R, E, RO>, handler: RequestHandler<P, R, E>): void;
    onRequest<R, E>(method: string, handler: GenericRequestHandler<R, E>): void;
    sendNotification<RO>(type: NotificationType0<RO>): void;
    sendNotification<P, RO>(type: NotificationType<P, RO>, params?: P): void;
    sendNotification(method: string): void;
    sendNotification(method: string, params: any): void;
    onNotification<RO>(type: NotificationType0<RO>, handler: NotificationHandler0): void;
    onNotification<P, RO>(type: NotificationType<P, RO>, handler: NotificationHandler<P>): void;
    onNotification(method: string, handler: GenericNotificationHandler): void;
    readonly protocol2CodeConverter: p2c.Converter;
    readonly code2ProtocolConverter: c2p.Converter;
    readonly onTelemetry: Event<any>;
    readonly onDidChangeState: Event<StateChangeEvent>;
    readonly outputChannel: OutputChannel;
    readonly diagnostics: DiagnosticCollection | undefined;
    createDefaultErrorHandler(): ErrorHandler;
    trace: Trace;
    private data2String(data);
    info(message: string, data?: any): void;
    warn(message: string, data?: any): void;
    error(message: string, data?: any): void;
    private logTrace(message, data?);
    needsStart(): boolean;
    needsStop(): boolean;
    onReady(): Promise<void>;
    private isConnectionActive();
    start(): Disposable;
    private resolveConnection();
    private initialize(connection);
    stop(): Thenable<void>;
    private cleanUp(diagnostics?);
    private notifyFileEvent(event);
    private forceDocumentSync();
    private handleDiagnostics(params);
    private createConnection();
    private handleConnectionClosed();
    private handleConnectionError(error, message, count);
    private checkProcessDied(childProcess);
    private hookConfigurationChanged(connection);
    private refreshTrace(connection, sendNotification?);
    private onDidChangeConfiguration(connection);
    private extractSettingsInformation(keys);
    private hookFileEvents(_connection);
    private _registeredHandlers;
    private initRegistrationHandlers(_connection);
    private handleRegistrationRequest(params);
    private handleUnregistrationRequest(params);
    private handleApplyWorkspaceEdit(params);
    private hookCapabilities(_connection);
    protected logFailedRequest(type: RPCMessageType, error: any): void;
    private createCompletionProvider(options);
    private createHoverProvider(options);
    private createSignatureHelpProvider(options);
    private createDefinitionProvider(options);
    private createReferencesProvider(options);
    private createDocumentHighlightProvider(options);
    private createDocumentSymbolProvider(options);
    private createWorkspaceSymbolProvider(_options);
    private createCodeActionsProvider(options);
    private createCodeLensProvider(options);
    private createDocumentFormattingProvider(options);
    private createDocumentRangeFormattingProvider(options);
    private createDocumentOnTypeFormattingProvider(options);
    private createRenameProvider(options);
    private createDocumentLinkProvider(options);
}
export declare class SettingMonitor {
    private _client;
    private _setting;
    private _listeners;
    constructor(_client: LanguageClient, _setting: string);
    start(): Disposable;
    private onDidChangeConfiguration();
}
