import * as code from 'vscode';
import * as ls from 'vscode-languageserver-types';
import ProtocolCompletionItem from './protocolCompletionItem';
export interface Converter {
    asUri(value: string): code.Uri;
    asDiagnostic(diagnostic: ls.Diagnostic): code.Diagnostic;
    asDiagnostics(diagnostics: ls.Diagnostic[]): code.Diagnostic[];
    asPosition(value: undefined | null): undefined;
    asPosition(value: ls.Position): code.Position;
    asPosition(value: ls.Position | undefined | null): code.Position | undefined;
    asRange(value: undefined | null): undefined;
    asRange(value: ls.Range): code.Range;
    asRange(value: ls.Range | undefined | null): code.Range | undefined;
    asDiagnosticSeverity(value: number | undefined | null): code.DiagnosticSeverity;
    asHover(hover: ls.Hover): code.Hover;
    asHover(hover: undefined | null): undefined;
    asHover(hover: ls.Hover | undefined | null): code.Hover | undefined;
    asCompletionResult(result: ls.CompletionItem[] | ls.CompletionList): code.CompletionItem[] | code.CompletionList;
    asCompletionResult(result: undefined | null): undefined;
    asCompletionResult(result: ls.CompletionItem[] | ls.CompletionList | undefined | null): code.CompletionItem[] | code.CompletionList | undefined;
    asCompletionItem(item: ls.CompletionItem): ProtocolCompletionItem;
    asTextEdit(edit: ls.TextEdit): code.TextEdit;
    asTextEdits(items: ls.TextEdit[]): code.TextEdit[];
    asTextEdits(items: undefined | null): undefined;
    asTextEdits(items: ls.TextEdit[] | undefined | null): code.TextEdit[] | undefined;
    asSignatureHelp(item: undefined | null): undefined;
    asSignatureHelp(item: ls.SignatureHelp): code.SignatureHelp;
    asSignatureHelp(item: ls.SignatureHelp | undefined | null): code.SignatureHelp | undefined;
    asSignatureInformation(item: ls.SignatureInformation): code.SignatureInformation;
    asSignatureInformations(items: ls.SignatureInformation[]): code.SignatureInformation[];
    asParameterInformation(item: ls.ParameterInformation): code.ParameterInformation;
    asParameterInformations(item: ls.ParameterInformation[]): code.ParameterInformation[];
    asDefinitionResult(item: ls.Definition): code.Definition;
    asDefinitionResult(item: undefined | null): undefined;
    asDefinitionResult(item: ls.Definition | undefined | null): code.Definition | undefined;
    asLocation(item: ls.Location): code.Location;
    asLocation(item: undefined | null): undefined;
    asLocation(item: ls.Location | undefined | null): code.Location | undefined;
    asReferences(values: ls.Location[]): code.Location[];
    asReferences(values: undefined | null): code.Location[] | undefined;
    asReferences(values: ls.Location[] | undefined | null): code.Location[] | undefined;
    asDocumentHighlightKind(item: number): code.DocumentHighlightKind;
    asDocumentHighlight(item: ls.DocumentHighlight): code.DocumentHighlight;
    asDocumentHighlights(values: ls.DocumentHighlight[]): code.DocumentHighlight[];
    asDocumentHighlights(values: undefined | null): undefined;
    asDocumentHighlights(values: ls.DocumentHighlight[] | undefined | null): code.DocumentHighlight[] | undefined;
    asSymbolInformation(item: ls.SymbolInformation, uri?: code.Uri): code.SymbolInformation;
    asSymbolInformations(values: ls.SymbolInformation[], uri?: code.Uri): code.SymbolInformation[];
    asSymbolInformations(values: undefined | null, uri?: code.Uri): undefined;
    asSymbolInformations(values: ls.SymbolInformation[] | undefined | null, uri?: code.Uri): code.SymbolInformation[] | undefined;
    asCommand(item: ls.Command): code.Command;
    asCommands(items: ls.Command[]): code.Command[];
    asCommands(items: undefined | null): undefined;
    asCommands(items: ls.Command[] | undefined | null): code.Command[] | undefined;
    asCodeLens(item: ls.CodeLens): code.CodeLens;
    asCodeLens(item: undefined | null): undefined;
    asCodeLens(item: ls.CodeLens | undefined | null): code.CodeLens | undefined;
    asCodeLenses(items: ls.CodeLens[]): code.CodeLens[];
    asCodeLenses(items: undefined | null): undefined;
    asCodeLenses(items: ls.CodeLens[] | undefined | null): code.CodeLens[] | undefined;
    asWorkspaceEdit(item: ls.WorkspaceEdit): code.WorkspaceEdit;
    asWorkspaceEdit(item: undefined | null): undefined;
    asWorkspaceEdit(item: ls.WorkspaceEdit | undefined | null): code.WorkspaceEdit | undefined;
    asDocumentLink(item: ls.DocumentLink): code.DocumentLink;
    asDocumentLinks(items: ls.DocumentLink[]): code.DocumentLink[];
    asDocumentLinks(items: undefined | null): undefined;
    asDocumentLinks(items: ls.DocumentLink[] | undefined | null): code.DocumentLink[] | undefined;
}
export interface URIConverter {
    (value: string): code.Uri;
}
export declare function createConverter(uriConverter?: URIConverter): Converter;
